/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.Token;
import antlr.TokenImpl;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.ArrayList;
import java.util.List;

public class TokenBuffer {
    private int nMarkers = 0;
    private int p = 0;
    public static final int INITIAL_BUFFER_SIZE = 2048;
    private final List tokens = new ArrayList(2048);
    private int size = 0;
    private int[] data = new int[2048];

    public TokenBuffer(TokenStream tokenStream) {
        try {
            int n = 0;
            Token token = tokenStream.nextToken();
            while (token != null && token.getType() != 1) {
                this.tokens.add(token);
                if (n == this.data.length) {
                    this.resizeData();
                }
                this.data[n++] = token.getType();
                token = tokenStream.nextToken();
            }
            this.size = n;
        }
        catch (TokenStreamException tokenStreamException) {
            System.err.println("tmp error: can't load tokens: " + tokenStreamException);
        }
    }

    private final void resizeData() {
        int[] nArray = new int[this.data.length * 2];
        System.arraycopy(this.data, 0, nArray, 0, this.data.length);
        this.data = nArray;
    }

    public final void consume() {
        ++this.p;
    }

    public final int LA(int n) {
        int n2 = this.p + n - 1;
        if (n2 >= this.size) {
            return 1;
        }
        return this.data[n2];
    }

    public final Token LT(int n) {
        if (this.p + n - 1 >= this.tokens.size()) {
            return TokenImpl.EOF_TOKEN;
        }
        return (Token)this.tokens.get(this.p + n - 1);
    }

    public final int mark() {
        ++this.nMarkers;
        return this.p;
    }

    public final int index() {
        return this.p;
    }

    public final void seek(int n) {
        this.p = n;
    }

    public final void rewind(int n) {
        this.seek(n);
        --this.nMarkers;
    }
}

