/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.BaseValue;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.IDRef;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.model.TimeAttributesNode;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;

public abstract class TraitAnimationNode
extends TimeAttributesNode
implements BaseValue,
IDRef {
    public static final int TYPE_GENERIC = 1;
    boolean hasNoEffect;
    TraitAnim traitAnim;
    BaseValue baseVal;
    String traitName;
    String traitNamespace;
    int type = 1;
    protected ElementNode targetElement;
    protected String idRef;

    public TraitAnimationNode(DocumentNode ownerDocument, String localName) {
        super(ownerDocument, localName);
    }

    public String getIdRef() {
        return this.idRef;
    }

    public void resolveTo(ElementNode ref) {
        this.targetElement = ref;
    }

    public void setIdRef(String idRef) {
        this.idRef = idRef;
        this.ownerDocument.resolveIDRef(this, idRef);
    }

    public void activate() {
        this.timedElementSupport.activate();
    }

    final Object[] compute() {
        return this.f(this.timedElementSupport.lastSampleTime);
    }

    abstract Object[] f(long var1);

    public Object[] getBaseValue() {
        return this.compute();
    }

    public void dispatchEvent(ModelEvent evt) {
        super.dispatchEvent(evt);
        if (this.targetElement != null) {
            if ("beginEvent".equals(evt.getType()) || "seekBeginEvent".equals(evt.getType())) {
                if (this.traitAnim != null && !this.hasNoEffect) {
                    this.traitAnim.removeAnimation(this);
                    this.traitAnim.addAnimation(this);
                }
            } else if ("lastDurEndEvent".equals(evt.getType())) {
                if (this.timedElementSupport.fillBehavior != 2 && this.traitAnim != null && !this.hasNoEffect) {
                    this.traitAnim.removeAnimation(this);
                }
            } else if ("seekEndEvent".equals(evt.getType()) && this.traitAnim != null && !this.hasNoEffect) {
                this.traitAnim.removeAnimation(this);
            }
        }
    }

    void validate() throws DOMException {
        if (this.targetElement == null) {
            this.targetElement = (ElementNode)this.parent;
        }
    }

    public String getTraitNSImpl(String namespaceURI, String name) throws DOMException {
        if ("http://www.w3.org/1999/xlink".equals(namespaceURI) && "href".equals(name)) {
            if (this.idRef == null) {
                return "";
            }
            return "#" + this.idRef;
        }
        return super.getTraitNSImpl(namespaceURI, name);
    }

    public void setTraitNSImpl(String namespaceURI, String name, String value) throws DOMException {
        if ("http://www.w3.org/1999/xlink".equals(namespaceURI) && "href".equals(name)) {
            if (value == null || !value.startsWith("#")) {
                throw this.illegalTraitValue(name, value);
            }
            this.setIdRef(value.substring(1));
        } else {
            super.setTraitNSImpl(namespaceURI, name, value);
        }
    }

    protected boolean supportsTraitNS(String namespaceURI, String traitName) {
        if ("http://www.w3.org/1999/xlink".equals(namespaceURI) && "href".equals(traitName)) {
            return true;
        }
        return super.supportsTraitNS(namespaceURI, traitName);
    }

    final void nodeUnhookedFromDocumentTree() {
        super.nodeUnhookedFromDocumentTree();
        if (this.traitAnim != null) {
            this.traitAnim.removeAnimation(this);
        }
    }
}

