/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.GenericResourceBean;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.SourceGroupUISupport;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SingletonSetupPanelVisual
extends JPanel
implements AbstractPanel.Settings {
    private Project project;
    private List<ChangeListener> listeners;
    private boolean uriOveridden;
    private boolean resourceClassNameOveridden;
    private JLabel classLabel;
    private JTextField classTextField;
    private JLabel contentClassLabel;
    private JTextField contentClassTextField;
    private JSeparator jSeparator2;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JComboBox medaTypeComboBox;
    private JLabel mediaTypeLabel;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JLabel resourceNameLabel;
    private JTextField resourceNameTextField;
    private JButton selectClassButton;
    private JLabel uriLabel;
    private JTextField uriTextField;
    public static final String DEFAULT_RESOURCE_NAME = "Generic";

    public SingletonSetupPanelVisual(String string) {
        this.setName(string);
        this.listeners = new ArrayList<ChangeListener>();
        this.initComponents();
        this.packageComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.fireChange();
            }
        });
        this.medaTypeComboBox.setModel(new DefaultComboBoxModel<Constants.MimeType>(GenericResourceBean.getSupportedMimeTypes()));
    }

    private void initComponents() {
        this.classLabel = new JLabel();
        this.classTextField = new JTextField();
        this.uriLabel = new JLabel();
        this.uriTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.medaTypeComboBox = new JComboBox();
        this.mediaTypeLabel = new JLabel();
        this.contentClassLabel = new JLabel();
        this.selectClassButton = new JButton();
        this.contentClassTextField = new JTextField();
        this.resourceNameLabel = new JLabel();
        this.resourceNameTextField = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.setName("null");
        this.classLabel.setLabelFor(this.classTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/rest/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)resourceBundle.getString("MSG_ClassName"));
        this.classTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.classTextFieldKeyReleased(keyEvent);
            }
        });
        this.uriLabel.setLabelFor(this.uriTextField);
        Mnemonics.setLocalizedText((JLabel)this.uriLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_UriTemplate"));
        this.uriTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.uriChanged(keyEvent);
            }
        });
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.setEnabled(false);
        this.locationComboBox.setMinimumSize(new Dimension(4, 20));
        this.locationComboBox.setPreferredSize(new Dimension(130, 23));
        this.locationComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingletonSetupPanelVisual.this.locationComboBoxActionPerformed(actionEvent);
            }
        });
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        this.packageComboBox.setMinimumSize(new Dimension(4, 20));
        this.packageComboBox.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.packageComboBoxKeyReleased(keyEvent);
            }
        });
        this.medaTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.medaTypeComboBox.setMinimumSize(new Dimension(4, 20));
        this.mediaTypeLabel.setLabelFor(this.medaTypeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.mediaTypeLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_MimeType"));
        this.contentClassLabel.setLabelFor(this.contentClassTextField);
        Mnemonics.setLocalizedText((JLabel)this.contentClassLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_RepresentationClass"));
        Mnemonics.setLocalizedText((AbstractButton)this.selectClassButton, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Select"));
        this.selectClassButton.setHorizontalAlignment(10);
        this.selectClassButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SingletonSetupPanelVisual.this.mouseClickHandler(mouseEvent);
            }
        });
        this.selectClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingletonSetupPanelVisual.this.selectClassButtonActionPerformed(actionEvent);
            }
        });
        this.contentClassTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.representationClassChanged(keyEvent);
            }
        });
        this.resourceNameLabel.setLabelFor(this.resourceNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.resourceNameLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_ResourceName"));
        this.resourceNameTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.resourceNameChanged(keyEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jSeparator2, -1, 476, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.locationLabel).add((Component)this.projectLabel).add((Component)this.packageLabel)).add(23, 23, 23).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectTextField, -1, 347, Short.MAX_VALUE).add((Component)this.locationComboBox, 0, 347, Short.MAX_VALUE).add(2, (Component)this.packageComboBox, 0, 347, Short.MAX_VALUE)).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.contentClassLabel).add((Component)this.resourceNameLabel).add((Component)this.classLabel).add((Component)this.uriLabel).add((Component)this.mediaTypeLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.uriTextField, -1, 346, Short.MAX_VALUE).add((Component)this.classTextField, -1, 346, Short.MAX_VALUE).add((Component)this.resourceNameTextField, -1, 346, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.contentClassTextField, -1, 267, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.selectClassButton)).add(2, (Component)this.medaTypeComboBox, 0, 346, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLabel).add((Component)this.projectTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.locationLabel).add((Component)this.locationComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.packageLabel).add((Component)this.packageComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.resourceNameLabel).add((Component)this.resourceNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.classLabel).add((Component)this.classTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.uriLabel).add((Component)this.uriTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.mediaTypeLabel).add((Component)this.medaTypeComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.contentClassLabel).add((Component)this.selectClassButton).add((Component)this.contentClassTextField, -2, 22, -2))));
        this.classLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ClassName"));
        this.classLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ClassName"));
        this.classTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ClassName"));
        this.classTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ClassName"));
        this.uriLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"UirTemplate"));
        this.uriLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Uri"));
        this.uriTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"UriTemplate"));
        this.uriTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Uri"));
        this.projectLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Project"));
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Project"));
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Project"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Project"));
        this.locationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Location"));
        this.locationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Location"));
        this.packageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ResourcePackage"));
        this.packageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.packageComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ResourcePackage"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.medaTypeComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"MimeType"));
        this.medaTypeComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_MimeType"));
        this.mediaTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"MimeType"));
        this.mediaTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_MimeType"));
        this.contentClassLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"RepresentationClass"));
        this.contentClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_RepresentationClass"));
        this.selectClassButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"SelectRepresentationClass"));
        this.selectClassButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_SelectRepresenationClass"));
        this.contentClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"RepresentationClass"));
        this.contentClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_RepresentationClass"));
        this.resourceNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_ResourceName"));
        this.resourceNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ResourceName"));
        this.resourceNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ResourceName"));
        this.resourceNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ResourceName"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Specify_Resource_Class"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Specify_Resource_Class"));
    }

    private void containerTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void representationClassChanged(KeyEvent keyEvent) {
        this.fireChange();
    }

    private void uriChanged(KeyEvent keyEvent) {
        this.uriOveridden = true;
        this.fireChange();
    }

    private void resourceNameChanged(KeyEvent keyEvent) {
        String string = this.resourceNameTextField.getText();
        if (!this.resourceClassNameOveridden) {
            this.classTextField.setText(Util.deriveResourceClassName(string));
        }
        if (!this.uriOveridden) {
            this.uriTextField.setText(Util.lowerFirstChar(string));
        }
        this.fireChange();
    }

    private void selectClassButtonActionPerformed(ActionEvent actionEvent) {
        this.fireChange();
    }

    private void mouseClickHandler(MouseEvent mouseEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ElementHandle elementHandle = TypeElementFinder.find((ClasspathInfo)Util.getClasspathInfo(SingletonSetupPanelVisual.this.project), (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String string, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> set) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(string, nameKind, set);
                    }

                    public boolean accept(ElementHandle<TypeElement> elementHandle) {
                        return true;
                    }
                });
                if (elementHandle != null) {
                    SingletonSetupPanelVisual.this.contentClassTextField.setText(elementHandle.getQualifiedName());
                    SingletonSetupPanelVisual.this.fireChange();
                }
            }
        });
    }

    private void locationComboBoxActionPerformed(ActionEvent actionEvent) {
        this.locationChanged();
    }

    private void classTextFieldKeyReleased(KeyEvent keyEvent) {
        this.resourceClassNameOveridden = true;
        this.fireChange();
    }

    private void packageComboBoxKeyReleased(KeyEvent keyEvent) {
        this.fireChange();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        AbstractPanel.clearErrorMessage(wizardDescriptor);
        String string = this.resourceNameTextField.getText().trim();
        String string2 = this.getPackage();
        String string3 = this.classTextField.getText().trim();
        SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.project);
        if (sourceGroupArray == null || sourceGroupArray.length < 1) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_NoJavaSourceRoots");
        } else {
            if (string.length() == 0 || !Utilities.isJavaIdentifier((String)string)) {
                AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_InvalidResourceName");
                return false;
            }
            if (string3.length() == 0 || !Utilities.isJavaIdentifier((String)string3)) {
                AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_InvalidResourceClassName");
                return false;
            }
            if (this.uriTextField.getText().trim().length() == 0) {
                AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_EmptyUriTemplate");
                return false;
            }
            if (!Util.isValidPackageName(string2)) {
                AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_InvalidPackageName");
                return false;
            }
            if (this.getResourceClassFile() != null) {
                AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_ExistingClass");
                return false;
            }
        }
        return true;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackage() {
        return ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).getText();
    }

    private void locationChanged() {
        this.updateSourceGroupPackages();
        this.fireChange();
    }

    private String getResourceName() {
        return this.resourceNameTextField.getText();
    }

    private String getResourceClassName() {
        return this.classTextField.getText();
    }

    private FileObject getResourceClassFile() {
        FileObject fileObject = null;
        try {
            fileObject = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage());
            if (fileObject != null) {
                return fileObject.getFileObject(this.getResourceClassName(), "java");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void read(WizardDescriptor wizardDescriptor) {
        SourceGroup sourceGroup;
        String[] stringArray;
        String string = (String)wizardDescriptor.getProperty("ResourceName");
        if (string == null || string.trim().length() == 0) {
            this.resourceNameTextField.setText(DEFAULT_RESOURCE_NAME);
            this.classTextField.setText(Util.deriveResourceClassName(this.getResourceName()));
            this.uriTextField.setText(Util.lowerFirstChar(this.getResourceName()));
            this.contentClassTextField.setText(GenericResourceBean.getDefaultRepresetationClass((Constants.MimeType)((Object)this.medaTypeComboBox.getSelectedItem())));
        } else {
            this.resourceNameTextField.setText(string);
            this.classTextField.setText((String)wizardDescriptor.getProperty("ResourceClass"));
            this.uriTextField.setText((String)wizardDescriptor.getProperty("ResourceURI"));
            this.medaTypeComboBox.setSelectedItem((Object)((Constants.MimeType[])wizardDescriptor.getProperty("MimeTypes"))[0]);
            stringArray = (String[])wizardDescriptor.getProperty("RepresentationTypes");
            if (stringArray != null && stringArray.length > 0) {
                this.contentClassTextField.setText(stringArray[0]);
            }
        }
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        stringArray = Templates.getTargetFolder((WizardDescriptor)wizardDescriptor);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroupArray);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updateSourceGroupPackages();
        if (stringArray != null && (sourceGroup = SourceGroupSupport.findSourceGroupForFile(sourceGroupArray, (FileObject)stringArray)) != null) {
            this.locationComboBox.setSelectedItem(sourceGroup);
            String string2 = SourceGroupSupport.getPackageForFolder(sourceGroup, (FileObject)stringArray);
            if (string2 != null) {
                ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).setText(string2);
            }
        }
    }

    public void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("resourcePackage", (Object)this.getPackage());
        wizardDescriptor.putProperty("ResourceName", (Object)this.resourceNameTextField.getText());
        wizardDescriptor.putProperty("ResourceClass", (Object)this.classTextField.getText());
        wizardDescriptor.putProperty("ResourceURI", (Object)this.uriTextField.getText());
        wizardDescriptor.putProperty("MimeTypes", (Object)new Constants.MimeType[]{(Constants.MimeType)((Object)this.medaTypeComboBox.getSelectedItem())});
        wizardDescriptor.putProperty("RepresentationTypes", (Object)new String[]{this.contentClassTextField.getText()});
        try {
            Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage(), true));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel comboBoxModel = PackageView.createListView((SourceGroup)sourceGroup);
            if (comboBoxModel.getSelectedItem() != null && comboBoxModel.getSelectedItem().toString().startsWith("META-INF") && comboBoxModel.getSize() > 1) {
                comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(1));
            }
            this.packageComboBox.setModel(comboBoxModel);
        }
    }
}

