/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.websvc.rest.wizard.EntitySelectionPanel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public abstract class AbstractPanel
implements ChangeListener,
WizardDescriptor.FinishablePanel,
WizardDescriptor.Panel {
    private final Set listeners = new HashSet(1);
    protected String panelName;
    protected WizardDescriptor wizardDescriptor;

    public AbstractPanel(String string, WizardDescriptor wizardDescriptor) {
        this.panelName = string;
        this.wizardDescriptor = wizardDescriptor;
    }

    public abstract Component getComponent();

    public abstract boolean isFinishPanel();

    public void readSettings(Object object) {
        this.wizardDescriptor = (WizardDescriptor)object;
        ((Settings)((Object)this.getComponent())).read(this.wizardDescriptor);
    }

    public void storeSettings(Object object) {
        WizardDescriptor wizardDescriptor = (WizardDescriptor)object;
        ((Settings)((Object)this.getComponent())).store(this.wizardDescriptor);
    }

    public boolean isValid() {
        if (this.getComponent() instanceof Settings) {
            return ((Settings)((Object)this.getComponent())).valid(this.wizardDescriptor);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent(ChangeEvent changeEvent) {
        Iterator iterator;
        Set set = this.listeners;
        synchronized (set) {
            iterator = new HashSet(this.listeners).iterator();
        }
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    static void clearErrorMessage(WizardDescriptor wizardDescriptor) {
        AbstractPanel.setErrorMessage(wizardDescriptor, (String)null);
    }

    static void setErrorMessage(WizardDescriptor wizardDescriptor, Throwable throwable) {
        String string = "";
        if (throwable != null) {
            string = throwable.getLocalizedMessage();
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    static void setErrorMessage(WizardDescriptor wizardDescriptor, String string, String ... stringArray) {
        String string2 = "";
        if (string != null) {
            string2 = NbBundle.getMessage(EntitySelectionPanel.class, (String)string, (Object[])stringArray);
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string2);
    }

    static void setErrorMessage(WizardDescriptor wizardDescriptor, String string) {
        String string2 = "";
        if (string != null) {
            string2 = NbBundle.getMessage(EntitySelectionPanel.class, (String)string);
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string2);
    }

    protected void setErrorMessage(String string) {
        AbstractPanel.setErrorMessage(this.wizardDescriptor, string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Component component = this.getComponent();
        if (component instanceof Settings) {
            ((Settings)((Object)component)).valid(this.wizardDescriptor);
        }
        this.fireChangeEvent(changeEvent);
    }

    public String getName() {
        return this.panelName;
    }

    public static interface Settings {
        public void read(WizardDescriptor var1);

        public void store(WizardDescriptor var1);

        public boolean valid(WizardDescriptor var1);

        public void addChangeListener(ChangeListener var1);
    }
}

