/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.projects;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.modules.websvc.rest.projects.AntFilesHelper;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class WebProjectRestSupport
extends RestSupport {
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";

    public WebProjectRestSupport(Project project) {
        super(project);
    }

    public void extendBuildScripts() throws IOException {
        new AntFilesHelper(this).initRestBuildExtension();
    }

    public void ensureRestDevelopmentReady() throws IOException {
        boolean bl = false;
        if (!this.isRestSupportOn()) {
            bl = true;
            this.setProjectProperty("rest.support.on", "true");
        }
        this.extendBuildScripts();
        if (this.ignorePlatformRestLibrary() || !this.hasSwdpLibrary()) {
            this.addSwdpLibrary(new String[]{"classpath/compile", "classpath/execute"});
        }
        this.addResourceConfigToWebApp();
        ProjectManager.getDefault().saveProject(this.getProject());
        if (bl) {
            this.refreshRestServicesMetadataModel();
        }
    }

    public void removeRestDevelopmentReadiness() throws IOException {
        this.removeResourceConfigFromWebApp();
        this.removeSwdpLibrary(new String[]{"classpath/compile", "classpath/execute"});
        this.setProjectProperty("rest.support.on", "false");
        ProjectManager.getDefault().saveProject(this.getProject());
    }

    public boolean isReady() {
        return this.isRestSupportOn() && this.hasSwdpLibrary() && this.hasRestServletAdaptor();
    }

    public boolean hasSwdpLibrary() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return false;
        }
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID());
        if (j2eePlatform == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (File file : j2eePlatform.getClasspathEntries()) {
            if (file.getName().equals("jsr311-api.jar")) {
                bl = true;
            }
            if (file.getName().equals("jersey.jar")) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return true;
        }
        return false;
    }

    private boolean hasRestServletAdaptor(WebApp webApp) {
        return this.getRestServletAdaptor(webApp) != null;
    }

    private Servlet getRestServletAdaptor(WebApp webApp) {
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlet()) {
                if (!"ServletAdaptor".equals(servlet.getServletName())) continue;
                return servlet;
            }
        }
        return null;
    }

    private ServletMapping getRestServletMapping(WebApp webApp) {
        for (ServletMapping servletMapping : webApp.getServletMapping()) {
            if (!"ServletAdaptor".equals(servletMapping.getServletName())) continue;
            return servletMapping;
        }
        return null;
    }

    private boolean hasRestServletAdaptor() {
        try {
            return this.hasRestServletAdaptor(this.getWebApp());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    private FileObject getDeploymentDescriptor() {
        WebModuleProvider webModuleProvider = (WebModuleProvider)this.project.getLookup().lookup(WebModuleProvider.class);
        if (webModuleProvider != null) {
            return webModuleProvider.findWebModule(this.project.getProjectDirectory()).getDeploymentDescriptor();
        }
        return null;
    }

    private void addResourceConfigToWebApp() throws IOException {
        FileObject fileObject = this.getDeploymentDescriptor();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        boolean bl = false;
        try {
            ServletMapping servletMapping;
            Servlet servlet = this.getRestServletAdaptor(webApp);
            if (servlet == null) {
                servlet = (Servlet)webApp.createBean("Servlet");
                servlet.setServletName("ServletAdaptor");
                servlet.setServletClass("com.sun.ws.rest.impl.container.servlet.ServletAdaptor");
                servlet.setLoadOnStartup(BigInteger.valueOf(1L));
                webApp.addServlet(servlet);
                bl = true;
            }
            if ((servletMapping = this.getRestServletMapping(webApp)) == null) {
                servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                servletMapping.setServletName(servlet.getServletName());
                servletMapping.setUrlPattern("/resources/*");
                webApp.addServletMapping(servletMapping);
                bl = true;
            }
            if (bl) {
                webApp.write(fileObject);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
    }

    private void removeResourceConfigFromWebApp() throws IOException {
        ServletMapping servletMapping;
        FileObject fileObject = this.getDeploymentDescriptor();
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return;
        }
        boolean bl = false;
        Servlet servlet = this.getRestServletAdaptor(webApp);
        if (servlet != null) {
            webApp.removeServlet(servlet);
            bl = true;
        }
        if ((servletMapping = this.getRestServletMapping(webApp)) != null) {
            webApp.removeServletMapping(servletMapping);
            bl = true;
        }
        if (bl) {
            webApp.write(fileObject);
        }
    }

    private WebApp getWebApp() throws IOException {
        WebModuleImplementation webModuleImplementation = (WebModuleImplementation)this.project.getLookup().lookup(WebModuleImplementation.class);
        FileObject fileObject = webModuleImplementation.getDeploymentDescriptor();
        if (fileObject != null) {
            return DDProvider.getDefault().getDDRoot(fileObject);
        }
        return null;
    }

    public FileObject getPersistenceXml() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (persistenceScope != null) {
            return persistenceScope.getPersistenceXml();
        }
        return null;
    }

    public void setDirectoryDeploymentProperty(Properties properties) {
        String string = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty(J2EE_SERVER_INSTANCE);
        if (string != null) {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            String string2 = j2eeModuleProvider.getServerInstanceID();
            J2eeModule j2eeModule = j2eeModuleProvider.getJ2eeModule();
            if (string2 != null && j2eeModule != null) {
                boolean bl = Deployment.getDefault().canFileDeploy(string, j2eeModule);
                properties.setProperty(DIRECTORY_DEPLOYMENT_SUPPORTED, String.valueOf(bl));
            }
        }
    }
}

