/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.projects;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class ProjectTestRestServicesAction
extends AbstractAction
implements Presenter.Menu,
ContextAwareAction,
LookupListener {
    private String command;
    private ProjectActionPerformer performer;
    private String namePattern;
    private String presenterName;
    private JMenuItem menuPresenter;
    private Lookup lookup;
    private Class<?>[] watch;
    private Lookup.Result[] results;
    private boolean needsRefresh = true;
    private boolean initialized = false;
    private boolean refreshing = false;

    public ProjectTestRestServicesAction() {
        this((Lookup)null);
    }

    private ProjectTestRestServicesAction(Lookup lookup) {
        if (lookup == null) {
            lookup = Utilities.actionsGlobalContext();
        }
        this.lookup = lookup;
        this.watch = new Class[]{Project.class, DataObject.class};
        this.command = "test-restbeans";
        this.presenterName = NbBundle.getMessage(ProjectTestRestServicesAction.class, (String)"LBL_TestRestBeansAction_Name");
        this.setDisplayName(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    protected final void setDisplayName(String string) {
        this.putValue("Name", string);
    }

    protected void actionPerformed(Lookup lookup) {
        Project[] projectArray = Utils.getProjectsFromLookup(lookup);
        if (projectArray.length == 1) {
            Properties properties = this.setupTestRestBeans(projectArray[0]);
            try {
                FileObject fileObject = Utils.findBuildXml(projectArray[0]);
                if (fileObject != null) {
                    ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{this.command}, (Properties)properties);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private Properties setupTestRestBeans(Project project) {
        Properties properties = new Properties();
        properties.setProperty("base.url.token", "___BASE_URL___");
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        AntProjectHelper antProjectHelper = restSupport.getAntProjectHelper();
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        String string = editableProperties.getProperty("restbeans.test.dir");
        if (string == null) {
            string = "build/generated/rest-test";
        }
        File file = antProjectHelper.resolveFile(string);
        try {
            FileObject fileObject = restSupport.generateTestClient(file);
            properties.setProperty("restbeans.test.url", fileObject.getURL().toString());
            properties.setProperty("restbeans.test.file", FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return properties;
    }

    protected void refresh(Lookup lookup) {
        Project[] projectArray = Utils.getProjectsFromLookup(lookup);
        if (projectArray.length == 1) {
            this.setEnabled(((RestSupport)projectArray[0].getLookup().lookup(RestSupport.class)).isRestSupportOn());
        } else {
            this.setEnabled(false);
        }
        this.setLocalizedTextToMenuPresented(this.presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)this.presenterName));
    }

    protected final void setLocalizedTextToMenuPresented(String string) {
        if (this.menuPresenter != null) {
            Mnemonics.setLocalizedText((AbstractButton)this.menuPresenter, (String)string);
        }
    }

    public JMenuItem getMenuPresenter() {
        if (this.menuPresenter == null) {
            this.menuPresenter = new JMenuItem(this);
            Icon icon = null;
            if (!Boolean.TRUE.equals(this.getValue("noIconInMenu"))) {
                icon = (Icon)this.getValue("SmallIcon");
            }
            this.menuPresenter.setIcon(icon);
            Mnemonics.setLocalizedText((AbstractButton)this.menuPresenter, (String)this.presenterName);
        }
        return this.menuPresenter;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ProjectTestRestServicesAction(lookup);
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        assert (EventQueue.isDispatchThread()) : "Cannot be called outside EQ!";
        this.results = new Lookup.Result[this.watch.length];
        for (int i = 0; i < this.watch.length; ++i) {
            this.results[i] = this.lookup.lookupResult(this.watch[i]);
            this.results[i].allItems();
            LookupListener lookupListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)this.results[i]);
            this.results[i].addLookupListener(lookupListener);
        }
        this.initialized = true;
    }

    public Object getValue(String string) {
        this.init();
        if (this.needsRefresh) {
            this.doRefresh();
        }
        return super.getValue(string);
    }

    public boolean isEnabled() {
        this.init();
        if (this.needsRefresh) {
            this.doRefresh();
        }
        return super.isEnabled();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        this.init();
        this.actionPerformed(this.lookup);
    }

    protected final Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh() {
        this.refreshing = true;
        try {
            this.refresh(this.lookup);
        }
        finally {
            this.refreshing = false;
        }
        this.needsRefresh = false;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        if (this.refreshing) {
            return;
        }
        if (this.getPropertyChangeListeners().length == 0) {
            this.needsRefresh = true;
        } else {
            this.doRefresh();
        }
    }
}

