/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.nodes.OpenCookieFactory;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class HttpMethodNode
extends AbstractNode {
    private String methodName;
    private String produceMime;
    private String consumeMime;
    private String returnType;
    private MetadataModel<RestServicesMetadata> model;
    private static final Image METHOD_BADGE = Utilities.loadImage((String)"org/netbeans/modules/websvc/rest/nodes/resources/method.png");

    public HttpMethodNode(Project project, String string, HttpMethod httpMethod) {
        this(project, string, httpMethod, new InstanceContent());
    }

    private HttpMethodNode(Project project, String string, HttpMethod httpMethod, InstanceContent instanceContent) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.methodName = httpMethod.getName();
        this.produceMime = httpMethod.getProduceMime();
        this.consumeMime = httpMethod.getConsumeMime();
        this.returnType = httpMethod.getReturnType();
        instanceContent.add((Object)this);
        instanceContent.add((Object)OpenCookieFactory.create(project, string, this.methodName));
    }

    public String getDisplayName() {
        return this.methodName + "() : " + Utils.stripPackageName(this.returnType);
    }

    public String getShortDescription() {
        String string = "";
        if (this.consumeMime.length() > 0) {
            string = string + "@ConsumeMime(\"" + this.consumeMime + "\") ";
        }
        if (this.produceMime.length() > 0) {
            string = string + "@ProduceMime(\"" + this.produceMime + "\") ";
        }
        return string;
    }

    public static String getKey(HttpMethod httpMethod) {
        return httpMethod.getName() + ":" + httpMethod.getReturnType() + ":" + httpMethod.getConsumeMime() + ":" + httpMethod.getProduceMime();
    }

    public Image getIcon(int n) {
        return METHOD_BADGE;
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean bl) {
        return new SystemAction[]{SystemAction.get(OpenAction.class), null, SystemAction.get(PropertiesAction.class)};
    }
}

