/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientStubsGenerator
extends AbstractGenerator {
    public static final String RESOURCES = "resources";
    public static final String TEMPLATES = "templates";
    public static final String DOJO = "dojo";
    public static final String REST = "rest";
    public static final String RDJ = "rdj";
    public static final String DATA = "data";
    public static final String WIDGET = "widget";
    public static final String RJS = "rjs";
    public static final String TABLE = "table";
    public static final String STORE = "Store";
    public static final String CSS = "css";
    public static final String JS = "js";
    public static final String HTML = "html";
    public static final String HTM = "htm";
    public static final String TXT = "txt";
    public static final String JSON = "json";
    public static final String GIF = "gif";
    public static final String JSP = "jsp";
    public static final String PHP = "php";
    public static final String RHTML = "rhtml";
    public static final String EJS = "ejs";
    public static final String IMAGES = "images";
    public static final String BUNDLE = "Bundle";
    public static final String PROPERTIES = "properties";
    public static final String LIBS = "libs";
    public static final String DJD43 = "djd43";
    public static final String JMAKI_DOJO = "jmaki-dojo";
    public static final String JMAKI_COMP_LIB = "jmakicomplib";
    public static final String JS_SUPPORT = "Support";
    public static final String JS_TESTSTUBS = "TestStubs";
    public static final String JS_README = "Readme";
    public static final String JS_TESTSTUBS_TEMPLATE = "Templates/WebServices/JsTestStubs.html";
    public static final String JS_STUBSUPPORT_TEMPLATE = "Templates/WebServices/JsStubSupport.js";
    public static final String JS_PROJECTSTUB_TEMPLATE = "Templates/WebServices/JsProjectStub.js";
    public static final String JS_CONTAINERSTUB_TEMPLATE = "Templates/WebServices/JsContainerStub.js";
    public static final String JS_CONTAINERITEMSTUB_TEMPLATE = "Templates/WebServices/JsContainerItemStub.js";
    public static final String JS_GENERICSTUB_TEMPLATE = "Templates/WebServices/JsGenericStub.js";
    public static final String JS_README_TEMPLATE = "Templates/WebServices/JsReadme.txt";
    public static final String DOJO_RESTSTORE = "RestStore";
    public static final String DOJO_COLLECTIONSTORE = "CollectionStore";
    public static final String DOJO_RESOURCESTABLE = "ResourcesTable";
    public static final String DOJO_TESTRESOURCESTABLE = "TestResourcesTable";
    public static final String DOJO_SUPPORT = "Support";
    public static final String DOJO_RESTSTORE_TEMPLATE = "Templates/WebServices/DojoRestStore.js";
    public static final String DOJO_COLLECTIONSTORE_TEMPLATE = "Templates/WebServices/DojoCollectionStore.js";
    public static final String DOJO_RESOURCESTABLE_TEMPLATE = "Templates/WebServices/DojoResourcesTable.js";
    public static final String DOJO_SUPPORT_TEMPLATE = "Templates/WebServices/DojoSupport.js";
    public static final String DOJO_TESTRESOURCESTABLE_TEMPLATE = "Templates/WebServices/DojoTestResourcesTable.html";
    public static final String JMAKI_README = "Readme";
    public static final String JMAKI_COMPONENT = "component";
    public static final String JMAKI_TESTRESOURCESTABLE = "TestResourcesTable";
    public static final String JMAKI_RESOURCESTABLE_SRC = "JmakiResourcesTable";
    public static final String JMAKI_RESOURCESTABLEUP_SRC = "JmakiResourcesTableUp";
    public static final String JMAKI_RESOURCESTABLEDOWN_SRC = "JmakiResourcesTableDown";
    public static final String JMAKI_RESOURCESTABLE_DEST = "rtable";
    public static final String JMAKI_RESOURCESTABLEUP_DEST = "rtableUp";
    public static final String JMAKI_RESOURCESTABLEDOWN_DEST = "rtableDown";
    public static final String JMAKI_README_TEMPLATE = "Templates/WebServices/JmakiReadme.txt";
    public static final String JMAKI_COMPONENTCSS_TEMPLATE = "Templates/WebServices/JmakiComponent.css";
    public static final String JMAKI_COMPONENTHTM_TEMPLATE = "Templates/WebServices/JmakiComponent.htm";
    public static final String JMAKI_COMPONENTJS_TEMPLATE = "Templates/WebServices/JmakiComponent.js";
    public static final String JMAKI_RESTBUNDLE_TEMPLATE = "Templates/WebServices/JmakiRestBundle.properties";
    public static final String JMAKI_TEMPLATESBUNDLE_TEMPLATE = "Templates/WebServices/JmakiTemplatesBundle.properties";
    public static final String JMAKI_TEMPLATESEJS_TEMPLATE = "Templates/WebServices/JmakiTemplates.ejs";
    public static final String JMAKI_TEMPLATESJSP_TEMPLATE = "Templates/WebServices/JmakiTemplates.jsp";
    public static final String JMAKI_TEMPLATESPHP_TEMPLATE = "Templates/WebServices/JmakiTemplates.php";
    public static final String JMAKI_TEMPLATESRHTML_TEMPLATE = "Templates/WebServices/JmakiTemplates.rhtml";
    public static final String JMAKI_TESTRESOURCESTABLE_TEMPLATE = "Templates/WebServices/JmakiTestResourcesTable.jsp";
    public static final String JMAKI_WIDGETJSON_TEMPLATE = "Templates/WebServices/JmakiWidget.json";
    private FileObject root;
    private Project p;
    private boolean createJmaki;
    private boolean overwrite;
    private String projectName;
    private ClientStubModel model;
    private FileObject resourcesDir;
    private FileObject dojoDir;
    private FileObject restDir;
    private FileObject rdjDir;
    private FileObject dataDir;
    private FileObject rjsDir;
    private FileObject templatesDir;
    private String includeJs = "";
    private String libsJs = "";
    private String resourcesDojo = "";
    private String requireDojo = "";
    protected String dojoResSelList = "";
    protected String jmakiResSelList = "";
    protected String jmakiResTagList = "";
    private static final int READ_BUF_SIZE = 65536;
    private static final int WRITE_BUF_SIZE = 65536;
    private FileObject wadlFile;
    private String folderName;
    private String baseUrl;
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "8080";
    private FileObject rF0 = null;

    public ClientStubsGenerator(FileObject fileObject, Project project, boolean bl, boolean bl2) throws IOException {
        assert (fileObject != null);
        assert (project != null);
        this.root = fileObject;
        this.p = project;
        this.createJmaki = bl;
        this.overwrite = bl2;
        this.projectName = ProjectUtils.getInformation((Project)this.getProject()).getName();
    }

    public ClientStubsGenerator(FileObject fileObject, String string, Project project, boolean bl, boolean bl2) throws IOException {
        assert (fileObject != null);
        assert (project != null);
        this.root = fileObject;
        this.folderName = string;
        this.p = project;
        this.createJmaki = bl;
        this.overwrite = bl2;
        this.projectName = ProjectUtils.getInformation((Project)this.getProject()).getName();
    }

    public ClientStubsGenerator(FileObject fileObject, String string, FileObject fileObject2, boolean bl, boolean bl2) throws IOException {
        assert (fileObject != null);
        assert (fileObject2 != null);
        this.root = fileObject;
        this.folderName = string;
        this.wadlFile = fileObject2;
        this.createJmaki = bl;
        this.overwrite = bl2;
        this.projectName = "NewProject";
    }

    public FileObject getRootDir() {
        return this.root;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public Project getProject() {
        return this.p;
    }

    public boolean canOverwrite() {
        return this.overwrite;
    }

    public boolean createJmaki() {
        return this.createJmaki;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public ClientStubModel getModel() {
        return this.model;
    }

    private String getApplicationNameFromUrl(String string) {
        String[] stringArray;
        String string2 = string.replaceAll("http://", "");
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((stringArray = string2.split("/")) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3 == null || !string3.startsWith(DEFAULT_HOST) || i + 1 >= stringArray.length || stringArray[i + 1] == null || stringArray[i + 1].trim().length() <= 0) continue;
                return stringArray[i + 1];
            }
        }
        return ClientStubModel.normailizeName(string2);
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        File file;
        Object object;
        Object object2;
        HashSet<FileObject> hashSet;
        Object object3;
        if (progressHandle != null) {
            this.initProgressReporting(progressHandle, false);
        }
        this.model = new ClientStubModel();
        this.baseUrl = "http://localhost:8080/";
        if (this.p != null) {
            this.model.buildModel(this.p);
            this.baseUrl = this.baseUrl + this.getProjectName() + "/resources";
        } else if (this.wadlFile != null && (object3 = this.model.buildModel(this.wadlFile)) != null) {
            this.baseUrl = object3;
            this.projectName = this.getApplicationNameFromUrl(this.baseUrl);
        }
        object3 = this.model.getResources();
        this.includeJs = "    rdj.includeJS('../rjs/" + this.getProjectName().toLowerCase() + "/" + this.getProjectName() + "." + JS + "');\n";
        this.libsJs = "                   '../rjs/" + this.getProjectName().toLowerCase() + "/" + this.getProjectName() + "." + JS + "',\n";
        this.resourcesDojo = "";
        this.requireDojo = "";
        FileObject fileObject = object3.iterator();
        while (fileObject.hasNext()) {
            hashSet = (ClientStubModel.Resource)fileObject.next();
            this.includeJs = this.includeJs + "    rdj.includeJS('../rjs/" + this.getProjectName().toLowerCase() + "/" + ((ClientStubModel.Resource)((Object)hashSet)).getName() + "." + JS + "');\n";
            this.libsJs = this.libsJs + "                   '../rjs/" + this.getProjectName().toLowerCase() + "/" + ((ClientStubModel.Resource)((Object)hashSet)).getName() + "." + JS + "',\n";
            if (!((ClientStubModel.Resource)((Object)hashSet)).isContainer()) continue;
            this.resourcesDojo = this.resourcesDojo + "                   '../rdj/data/" + ((ClientStubModel.Resource)((Object)hashSet)).getName() + STORE + "." + JS + "',\n";
            this.requireDojo = this.requireDojo + "djd43.require(\"rdj.data." + ((ClientStubModel.Resource)((Object)hashSet)).getName() + STORE + "\");\n";
        }
        if (this.createJmaki()) {
            this.resourcesDir = this.createFolder(this.getRootDir(), RESOURCES);
            this.dojoDir = this.createFolder(this.resourcesDir, DOJO);
            this.restDir = this.createFolder(this.dojoDir, REST);
            this.rjsDir = this.createFolder(this.restDir, RJS);
            this.rdjDir = this.createFolder(this.restDir, RDJ);
            this.templatesDir = this.createFolder(this.getRootDir(), TEMPLATES);
            this.initJs(this.p);
            this.initDojo(this.p, (List<ClientStubModel.Resource>)object3);
            this.initJmaki(this.p, (List<ClientStubModel.Resource>)object3);
        } else {
            this.rjsDir = this.createFolder(this.getRootDir(), this.getFolderName());
            this.initJs(this.p);
        }
        fileObject = this.createFolder(this.rjsDir, this.getProjectName().toLowerCase());
        this.createDataObjectFromTemplate(JS_PROJECTSTUB_TEMPLATE, fileObject, this.getProjectName(), JS, this.canOverwrite());
        this.updateProjectStub(fileObject.getFileObject(this.getProjectName(), JS), this.getProjectName(), "", this.baseUrl);
        hashSet = object3.iterator();
        while (hashSet.hasNext()) {
            object2 = (ClientStubModel.Resource)hashSet.next();
            if (progressHandle != null) {
                this.reportProgress(NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_GeneratingClass", (Object)((ClientStubModel.Resource)object2).getName(), (Object)JS));
            }
            object = new ResourceJavaScript((ClientStubModel.Resource)object2, fileObject).generate();
            if (!this.createJmaki()) continue;
            new ResourceDojoComponents((ClientStubModel.Resource)object2, this.rdjDir).generate();
            new ResourceJmakiComponent((ClientStubModel.Resource)object2, this.restDir).generate();
            file = new File(FileUtil.toFile((FileObject)this.templatesDir), DOJO + File.separator + REST);
            FileUtil.createFolder((File)file);
            new ResourceJmakiTemplate((ClientStubModel.Resource)object2, FileUtil.toFileObject((File)file)).generate();
        }
        this.updateRestStub(this.rjsDir.getFileObject(JS_TESTSTUBS, HTML), (List<ClientStubModel.Resource>)object3, "");
        hashSet = new HashSet<FileObject>();
        if (this.createJmaki()) {
            FileObject fileObject2;
            if (progressHandle != null) {
                this.reportProgress(NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_CopyLibs", (Object)DJD43, (Object)JS));
            }
            this.copyDojoLibs();
            if (progressHandle != null) {
                this.reportProgress(NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_GeneratingZip", (Object)this.getProjectName(), (Object)"zip"));
            }
            object2 = FileUtil.toFile((FileObject)this.resourcesDir.getParent().getParent());
            object = FileUtil.toFile((FileObject)this.dojoDir.getFileObject(RESOURCES));
            file = new File((File)object2, this.getProjectName() + ".zip");
            String[] stringArray = new String[]{FileUtil.toFile((FileObject)this.restDir).getAbsolutePath(), FileUtil.toFile((FileObject)this.templatesDir).getAbsolutePath(), FileUtil.toFile((FileObject)this.resourcesDir.getParent()).getAbsolutePath() + File.separator + BUNDLE + "." + PROPERTIES, ((File)object).getAbsolutePath()};
            String[] stringArray2 = new String[]{File.separator + RESOURCES + File.separator + DOJO, "", "", File.separator + RESOURCES + File.separator + DOJO};
            ClientStubsGenerator.zip(file, stringArray, stringArray2);
            FileObject fileObject3 = this.restDir.getFileObject("TestResourcesTable", JSP);
            if (fileObject3 != null) {
                hashSet.add(fileObject3);
            }
            if ((fileObject2 = this.restDir.getFileObject("Readme", TXT)) != null) {
                hashSet.add(fileObject2);
            }
        } else {
            object2 = this.rjsDir.getFileObject(JS_TESTSTUBS, HTML);
            if (object2 != null) {
                hashSet.add((FileObject)object2);
            }
            if ((object = this.rjsDir.getFileObject("Readme", TXT)) != null) {
                hashSet.add((FileObject)object);
            }
        }
        return hashSet;
    }

    private FileObject createDataObjectFromTemplate(final String string, final FileObject fileObject, final String string2, final String string3, final boolean bl) throws IOException {
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                ClientStubsGenerator.this.rF0 = fileObject.getFileObject(string2, string3);
                if (ClientStubsGenerator.this.rF0 != null) {
                    if (bl) {
                        ClientStubsGenerator.this.rF0.delete();
                    } else {
                        return;
                    }
                }
                DataObject dataObject = RestUtils.createDataObjectFromTemplate(string, fileObject, string2);
                ClientStubsGenerator.this.rF0 = dataObject.getPrimaryFile();
            }
        });
        return this.rF0;
    }

    private void copyDojoLibs() throws FileNotFoundException, IOException {
        String string = System.getProperty("netbeans.user");
        if (string == null || string.length() == 0) {
            throw new RuntimeException("Cannot locate netbeans user folder.");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException("NetBeans user folder (" + file.getPath() + ") does not exist.");
        }
        File file2 = new File(file, JMAKI_COMP_LIB);
        if (!file2.exists()) {
            throw new RuntimeException("Cannot find jMaki component folder (" + file2 + ").");
        }
        File file3 = this.findDojoLibrary(file2);
        if (file3 != null) {
            ClientStubsGenerator.unzip(new FileInputStream(file3), this.resourcesDir.getParent(), this.canOverwrite());
        } else {
            File file4 = new File(file2, RESOURCES + File.separator + DOJO + File.separator + RESOURCES);
            File file5 = FileUtil.toFile((FileObject)this.dojoDir);
            FileSystem fileSystem = FileUtil.toFileObject((File)file5).getFileSystem();
            this.copyDirectory(fileSystem, file4, file5);
        }
        if (this.dojoDir.getFileObject(RESOURCES) == null) {
            throw new IOException("Copying dojo libs from :" + file2.getAbsolutePath() + " to " + this.resourcesDir.getParent() + " failed.");
        }
    }

    private File findDojoLibrary(File file) {
        File file2 = null;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string != null && string.startsWith(ClientStubsGenerator.JMAKI_DOJO) && string.endsWith(".zip");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray != null && fileArray.length > 0) {
            file2 = fileArray[0];
        }
        return file2;
    }

    public void copyDirectory(FileSystem fileSystem, final File file, final File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.copyDirectory(fileSystem, new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            if (!file.exists()) {
                throw new IOException("File or directory does not exist.");
            }
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    try {
                        int n;
                        byte[] byArray = new byte[1024];
                        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                            ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        }
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                        ((OutputStream)fileOutputStream).close();
                    }
                }
            });
        }
    }

    private void initJs(Project project) throws IOException {
        this.createDataObjectFromTemplate(JS_TESTSTUBS_TEMPLATE, this.rjsDir, JS_TESTSTUBS, HTML, false);
        this.createDataObjectFromTemplate(JS_STUBSUPPORT_TEMPLATE, this.rjsDir, "Support", JS, this.canOverwrite());
        this.createDataObjectFromTemplate(JS_README_TEMPLATE, this.rjsDir, "Readme", TXT, this.canOverwrite());
    }

    private void initDojo(Project project, List<ClientStubModel.Resource> list) throws IOException {
        this.dataDir = this.createFolder(this.rdjDir, DATA);
        FileObject fileObject = this.createFolder(this.rdjDir, WIDGET);
        ClientStubModel.Resource resource = null;
        for (ClientStubModel.Resource resource2 : list) {
            if (!resource2.isContainer()) continue;
            resource = resource2;
            break;
        }
        this.dojoResSelList = this.createDojoResourceSelectList(list);
        this.jmakiResSelList = this.createJmakiResourceSelectList(list);
        this.jmakiResTagList = this.createJmakiResourceTagList(list);
        this.createDataObjectFromTemplate(DOJO_RESOURCESTABLE_TEMPLATE, fileObject, DOJO_RESOURCESTABLE, JS, this.canOverwrite());
        FileObject fileObject2 = this.createDataObjectFromTemplate(DOJO_SUPPORT_TEMPLATE, this.rdjDir, "Support", JS, false);
        if (resource != null) {
            new ResourceDojoComponents(resource, this.rdjDir).replaceTokens(fileObject2);
        }
        fileObject2 = this.createDataObjectFromTemplate(DOJO_TESTRESOURCESTABLE_TEMPLATE, this.rdjDir, "TestResourcesTable", HTML, false);
        if (resource != null) {
            new ResourceDojoComponents(resource, this.rdjDir).replaceTokens(fileObject2);
        }
    }

    private void initJmaki(Project project, List<ClientStubModel.Resource> list) throws IOException {
        this.createDataObjectFromTemplate(JMAKI_README_TEMPLATE, this.restDir, "Readme", TXT, this.canOverwrite());
        this.createDataObjectFromTemplate(JMAKI_RESTBUNDLE_TEMPLATE, this.getRootDir(), BUNDLE, PROPERTIES, this.canOverwrite());
        ClientStubModel.Resource resource = null;
        for (ClientStubModel.Resource resource2 : list) {
            if (!resource2.isContainer()) continue;
            resource = resource2;
            break;
        }
        FileObject fileObject = this.createDataObjectFromTemplate(JMAKI_TESTRESOURCESTABLE_TEMPLATE, this.restDir, "TestResourcesTable", JSP, false);
        if (resource != null) {
            new ResourceDojoComponents(resource, this.restDir).replaceTokens(fileObject);
        }
    }

    protected String createDojoResourceSelectList(List<ClientStubModel.Resource> list) {
        String string = "";
        for (ClientStubModel.Resource resource : list) {
            if (!resource.isContainer()) continue;
            string = string + "            <option value='http://localhost:8080/" + this.getProjectName() + "/resources/" + resource.getRepresentation().getRoot().getName() + "/;" + resource.getName() + "'>" + resource.getName() + "</option>\n";
        }
        return string;
    }

    protected String createJmakiResourceSelectList(List<ClientStubModel.Resource> list) {
        String string = "";
        for (ClientStubModel.Resource resource : list) {
            if (!resource.isContainer()) continue;
            string = string + "                <option value='" + resource.getName() + "' <%=p.equals(\"" + resource.getName() + "\")?\"selected\":\"\"%>>" + resource.getName() + "</option>\n";
        }
        return string;
    }

    protected String createJmakiResourceTagList(List<ClientStubModel.Resource> list) {
        String string = "";
        int n = 0;
        for (ClientStubModel.Resource resource : list) {
            if (!resource.isContainer()) continue;
            String string2 = resource.getName();
            String string3 = resource.getRepresentation().getRoot().getName();
            if (n++ == 0) {
                string = string + "         <% if(p.equals(\"" + string2 + "\")) {%>\n" + "            <a:widget name=\"dojo.rest." + string3 + "table\" service=\"http://localhost:8080/" + this.getProjectName() + "/resources/" + string3 + "/\" />\n";
                continue;
            }
            string = string + "         <% } else if(p.equals(\"" + string2 + "\")) {%>\n" + "            <a:widget name=\"dojo.rest." + string3 + "table\" service=\"http://localhost:8080/" + this.getProjectName() + "/resources/" + string3 + "/\" />\n";
        }
        string = string + "<% }%>";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String string, File file) throws IOException {
        String string2 = "resources/" + string;
        if (!file.exists()) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = ClientStubsGenerator.class.getResourceAsStream(string2);
                outputStream = new FileOutputStream(file);
                while ((n = inputStream.read()) != -1) {
                    outputStream.write(n);
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    private FileObject createFolder(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder(string);
        }
        return fileObject2;
    }

    private static void zip(File file, String[] stringArray, String[] stringArray2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(stringArray[i]);
                ClientStubsGenerator.addEntry(file2, stringArray2[i], zipOutputStream);
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private static void addEntry(File file, String string, ZipOutputStream zipOutputStream) throws FileNotFoundException, IOException {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file + File.separator + stringArray[i]);
                ClientStubsGenerator.addEntry(file2, string + File.separator + file.getName(), zipOutputStream);
            }
        } else {
            int n;
            byte[] byArray = new byte[65536];
            BufferedInputStream bufferedInputStream = null;
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 65536);
            ZipEntry zipEntry = new ZipEntry(string + File.separator + file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            while ((n = bufferedInputStream.read(byArray, 0, 65536)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unzip(InputStream inputStream, FileObject fileObject, boolean bl) throws IOException {
        boolean bl2 = true;
        FileSystem fileSystem = fileObject.getFileSystem();
        File file = FileUtil.toFile((FileObject)fileObject);
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            final byte[] byArray = new byte[65536];
            final ZipInputStream zipInputStream2 = zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream, 65536));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file2;
                if (!zipEntry.getName().startsWith("resources/dojo/resources/libs") && !zipEntry.getName().startsWith(RESOURCES + File.separator + DOJO + File.separator + RESOURCES + File.separator + LIBS)) continue;
                final File file3 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (file3.exists()) continue;
                    try {
                        file2 = FileUtil.createFolder((File)file3);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Failed to create folder: " + file3.getName() + ".  Terminating archive installation.");
                    }
                }
                if (file3.exists() && bl && !file3.delete()) {
                    throw new RuntimeException("Failed to delete file: " + file3.getName() + ".  Terminating archive installation.");
                }
                file2 = file3.getParentFile();
                if (!file2.exists()) {
                    try {
                        FileObject fileObject2 = FileUtil.createFolder((File)file2);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Failed to create folder: " + file2.getName() + ".  Terminating archive installation.");
                    }
                }
                fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        FileOutputStream fileOutputStream = null;
                        try {
                            int n;
                            fileOutputStream = new FileOutputStream(file3);
                            while ((n = zipInputStream2.read(byArray)) >= 0) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                        }
                        finally {
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                        }
                    }
                });
            }
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProjectStub(FileObject fileObject, String string, String string2, String string3) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            Object object;
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.contains("__BASE_URL__")) {
                    stringBuffer.append(string4.replaceAll("__BASE_URL__", string3));
                } else if (string4.contains("__PROJECT_NAME__")) {
                    stringBuffer.append(string4.replaceAll("__PROJECT_NAME__", string));
                } else if (string4.contains("__PROJECT_INIT_BODY__")) {
                    object = "";
                    int n = 0;
                    List<ClientStubModel.Resource> list = this.model.getResources();
                    for (ClientStubModel.Resource resource : list) {
                        if (!resource.isContainer()) continue;
                        object = (String)object + "      this.resources[" + n++ + "] = new " + string2 + resource.getName() + "(this.uri+'" + resource.getPath() + "');\n";
                    }
                    stringBuffer.append((String)object);
                } else {
                    stringBuffer.append(string4);
                }
                stringBuffer.append("\n");
            }
            object = new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8");
            try {
                ((Writer)object).write(stringBuffer.toString());
            }
            finally {
                ((OutputStreamWriter)object).close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRestStub(FileObject fileObject, List<ClientStubModel.Resource> list, String string) throws IOException {
        ClientStubModel.Resource resource2;
        String string2 = this.getProjectName();
        String string3 = string2.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t<script type='text/javascript' src='./" + string3 + "/" + string2 + "." + JS + "'></script>\n");
        for (ClientStubModel.Resource resource2 : list) {
            stringBuffer.append("\t<script type='text/javascript' src='./" + string3 + "/" + resource2.getName() + "." + JS + "'></script>\n");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("\n\t<!-- Using JavaScript files for project " + string2 + "-->\n");
        stringBuffer2.append("\t<script language='Javascript'>\n");
        stringBuffer2.append("\t\tvar str = '';\n");
        stringBuffer2.append("\t\t//Example test code for " + string2 + "\n");
        stringBuffer2.append("\t\tstr = '<h2>Resources for " + string2 + ":</h2><br><table border=\"1\">';\n");
        stringBuffer2.append("\t\tvar app = new " + string + string2 + "('" + this.baseUrl + "');\n");
        stringBuffer2.append("\t\tvar resources = app.getResources();\n");
        stringBuffer2.append("\t\tfor(i=0;i<resources.length;i++) {\n");
        stringBuffer2.append("\t\t  var resource = resources[i];\n");
        stringBuffer2.append("\t\t  var uri = resource.getUri();\n");
        stringBuffer2.append("\t\t  str += '<tr><td valign=\"top\"><a href=\"'+uri+'\" target=\"_blank\">'+uri+'</a></td><td>';\n");
        stringBuffer2.append("\t\t  var items  = resource.getItems();\n");
        stringBuffer2.append("\t\t  if(items != undefined && items.length > 0) {\n");
        stringBuffer2.append("\t\t    for(j=0;j<items.length;j++) {\n");
        stringBuffer2.append("\t\t        var item = items[j];\n");
        stringBuffer2.append("\t\t        var uri2 = item.getUri();\n");
        stringBuffer2.append("\t\t        str += '<a href=\"'+uri2+'\" target=\"_blank\">'+uri2+'</a><br/>';\n");
        stringBuffer2.append("\t\t        str += '&nbsp;&nbsp;<font size=\"-3\">'+item.toString()+'</font><br/>';\n");
        stringBuffer2.append("\t\t    }\n");
        stringBuffer2.append("\t\t  } else {\n");
        stringBuffer2.append("\t\t    str += 'No items, please check the url: <a href=\"'+uri+'\" target=\"_blank\">'+uri+'</a>';\n");
        stringBuffer2.append("\t\t  }\n");
        stringBuffer2.append("\t\t  str += '</td></tr>';\n");
        stringBuffer2.append("\t\t}\n");
        stringBuffer2.append("\t\tstr += '</table><br>';\n");
        stringBuffer2.append("\t\tvar n = document.getElementById('containerContent');\n");
        stringBuffer2.append("\t\tn.innerHTML = n.innerHTML + str;\n\n");
        stringBuffer2.append("\t</script>\n");
        resource2 = fileObject.lock();
        try {
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
            StringBuffer stringBuffer3 = new StringBuffer();
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.contains("JS_DECLARE_END")) {
                    stringBuffer3.append(stringBuffer.toString());
                } else if (string4.contains("JS_USAGE_END")) {
                    stringBuffer3.append(stringBuffer2.toString());
                }
                stringBuffer3.append(string4);
                stringBuffer3.append("\n");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream((FileLock)resource2), "UTF-8");
            try {
                outputStreamWriter.write(stringBuffer3.toString());
            }
            finally {
                outputStreamWriter.close();
            }
        }
        finally {
            resource2.releaseLock();
        }
    }

    public class ResourceJmakiTemplate
    extends ResourceJavaScript {
        public ResourceJmakiTemplate(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
        }

        public FileObject generate() throws IOException {
            if (!this.r.isContainer()) {
                return null;
            }
            String string = this.r.getRepresentation().getRoot().getName() + ClientStubsGenerator.TABLE;
            FileObject fileObject = ClientStubsGenerator.this.createFolder(this.getFolder(), string);
            FileObject fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_TEMPLATESBUNDLE_TEMPLATE, fileObject, ClientStubsGenerator.BUNDLE, ClientStubsGenerator.PROPERTIES, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_TEMPLATESJSP_TEMPLATE, fileObject, string, ClientStubsGenerator.JSP, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_TEMPLATESPHP_TEMPLATE, fileObject, string, ClientStubsGenerator.PHP, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_TEMPLATESEJS_TEMPLATE, fileObject, string, ClientStubsGenerator.EJS, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_TEMPLATESRHTML_TEMPLATE, fileObject, string, ClientStubsGenerator.RHTML, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            return this.getFolder();
        }
    }

    public class ResourceJmakiComponent
    extends ResourceDojoComponents {
        public ResourceJmakiComponent(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
        }

        public FileObject generate() throws IOException {
            if (!this.r.isContainer()) {
                return null;
            }
            String string = this.r.getRepresentation().getRoot().getName();
            FileObject fileObject = ClientStubsGenerator.this.createFolder(this.getFolder(), string + ClientStubsGenerator.TABLE);
            ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_COMPONENTCSS_TEMPLATE, fileObject, ClientStubsGenerator.JMAKI_COMPONENT, ClientStubsGenerator.CSS, ClientStubsGenerator.this.canOverwrite());
            ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_COMPONENTHTM_TEMPLATE, fileObject, ClientStubsGenerator.JMAKI_COMPONENT, ClientStubsGenerator.HTM, ClientStubsGenerator.this.canOverwrite());
            FileObject fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_COMPONENTJS_TEMPLATE, fileObject, ClientStubsGenerator.JMAKI_COMPONENT, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JMAKI_WIDGETJSON_TEMPLATE, fileObject, ClientStubsGenerator.WIDGET, ClientStubsGenerator.JSON, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            FileObject fileObject3 = ClientStubsGenerator.this.createFolder(fileObject, ClientStubsGenerator.IMAGES);
            File file = FileUtil.toFile((FileObject)fileObject3);
            ClientStubsGenerator.this.copyFile("JmakiResourcesTable.gif", new File(file, "rtable.gif"));
            ClientStubsGenerator.this.copyFile("JmakiResourcesTableUp.gif", new File(file, "rtableUp.gif"));
            ClientStubsGenerator.this.copyFile("JmakiResourcesTableDown.gif", new File(file, "rtableDown.gif"));
            return this.getFolder();
        }
    }

    public class ResourceDojoComponents
    extends ResourceJavaScript {
        public ResourceDojoComponents(ClientStubModel.Resource resource, FileObject fileObject) {
            super(resource, fileObject);
        }

        public FileObject generate() throws IOException {
            if (!this.r.isContainer()) {
                return null;
            }
            String string = this.r.getName();
            FileObject fileObject = this.getFolder().getFileObject(ClientStubsGenerator.DATA);
            FileObject fileObject2 = ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.DOJO_COLLECTIONSTORE_TEMPLATE, fileObject, string + ClientStubsGenerator.STORE, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            this.replaceTokens(fileObject2);
            return ClientStubsGenerator.this.rdjDir;
        }

        protected String replaceTokens(String string, String string2, String string3) {
            String string4 = string;
            string4 = string4.replaceAll("//__INCLUDE_JS_SCRIPTS__", ClientStubsGenerator.this.includeJs + "\n//__INCLUDE_JS_SCRIPTS__");
            string4 = string4.replaceAll("//__LIBS_JS_SCRIPTS__", ClientStubsGenerator.this.libsJs + "\n//__LIBS_JS_SCRIPTS__");
            string4 = string4.replaceAll("//__RESOURCES_DOJO_SCRIPTS__", ClientStubsGenerator.this.resourcesDojo + "\n//__RESOURCES_DOJO_SCRIPTS__");
            string4 = string4.replaceAll("//__REQUIRE_DOJO_SCRIPTS__", ClientStubsGenerator.this.requireDojo + "\n//__REQUIRE_DOJO_SCRIPTS__");
            return super.replaceTokens(string4, string2, string3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResourceJavaScript {
        protected ClientStubModel.Resource r;
        protected FileObject jsFolder;
        public static final String RJSSUPPORT = "rjsSupport";

        public ResourceJavaScript(ClientStubModel.Resource resource, FileObject fileObject) {
            this.r = resource;
            this.jsFolder = fileObject;
        }

        public FileObject getFolder() {
            return this.jsFolder;
        }

        public FileObject generate() throws IOException {
            String string = this.r.getName();
            String string2 = this.r.getName() + "." + ClientStubsGenerator.JS;
            FileObject fileObject = this.jsFolder.getFileObject(string2);
            if (fileObject != null) {
                if (ClientStubsGenerator.this.canOverwrite()) {
                    fileObject.delete();
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_SkippingStubGeneration", (Object)(this.jsFolder.getPath() + File.separator + string2)));
                }
            }
            if (this.r.isContainer()) {
                ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JS_CONTAINERSTUB_TEMPLATE, this.jsFolder, string, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            } else if (this.r.getRepresentation().getRoot() != null) {
                ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JS_CONTAINERITEMSTUB_TEMPLATE, this.jsFolder, string, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            } else {
                ClientStubsGenerator.this.createDataObjectFromTemplate(ClientStubsGenerator.JS_GENERICSTUB_TEMPLATE, this.jsFolder, string, ClientStubsGenerator.JS, ClientStubsGenerator.this.canOverwrite());
            }
            fileObject = this.jsFolder.getFileObject(string2);
            this.replaceTokens(fileObject);
            return fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void replaceTokens(FileObject fileObject) throws IOException {
            FileLock fileLock = fileObject.lock();
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fileObject)));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    string = this.replaceTokens(string, "", "");
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8");
                try {
                    outputStreamWriter.write(stringBuffer.toString());
                }
                finally {
                    outputStreamWriter.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }

        protected String replaceTokens(String string, String string2, String string3) {
            ClientStubModel.RepresentationNode representationNode = this.r.getRepresentation().getRoot();
            String string4 = string;
            String[] stringArray = new String[]{"__CONTAINER_NAME__", "__CONTAINER_PATH_NAME__", "__CONTAINER_ITEM_NAME__", "__CONTAINER_ITEM_PATH_NAME__", "__STUB_METHODS__", "__PROJECT_NAME__", "<!-- __DOJO_RESOURCE_SELECT_LIST__ -->", "<!-- __JMAKI_RESOURCE_SELECT_LIST__ -->", "<!-- __JMAKI_RESOURCE_TAG_LIST__ -->"};
            String[] stringArray2 = new String[]{"__GENERIC_NAME__", "__GENERIC_PATH_NAME__", "__FIELDS_DEFINITION__", "__GETTER_SETTER_METHODS__", "__FIELDS_INIT__", "__SUB_RESOURCE_NAME__", "__SUB_RESOURCE_PATH_NAME__", "__FIELDS_TOSTRING__", "__FIELD_NAMES_TOSTRING__", "__STUB_METHODS__"};
            String[] stringArray3 = new String[]{"__RESOURCE_NAME__", "__STUB_METHODS__"};
            if (this.r.isContainer() && representationNode != null && representationNode.getChildren().size() > 0) {
                String string5 = this.r.getName();
                String string6 = representationNode.getName();
                String string7 = representationNode.getChildren().get(0).getName();
                if (string7.indexOf("Ref") != -1) {
                    string7 = string7.substring(0, string7.indexOf("Ref"));
                }
                String string8 = string7.substring(0, 1).toUpperCase() + string7.substring(1);
                for (String string9 : stringArray) {
                    if ("__CONTAINER_NAME__".equals(string9)) {
                        string4 = string4.replaceAll("__CONTAINER_NAME__", string5);
                        continue;
                    }
                    if ("__CONTAINER_PATH_NAME__".equals(string9)) {
                        string4 = string4.replaceAll("__CONTAINER_PATH_NAME__", string6);
                        continue;
                    }
                    if ("__CONTAINER_ITEM_NAME__".equals(string9)) {
                        string4 = string4.replaceAll("__CONTAINER_ITEM_NAME__", string8);
                        continue;
                    }
                    if ("__CONTAINER_ITEM_PATH_NAME__".equals(string9)) {
                        string4 = string4.replaceAll("__CONTAINER_ITEM_PATH_NAME__", string7);
                        continue;
                    }
                    if ("__STUB_METHODS__".equals(string9)) {
                        string4 = string4.replace("__STUB_METHODS__", this.createStubJSMethods(this.r, string2, string3));
                        continue;
                    }
                    if ("__PROJECT_NAME__".equals(string9)) {
                        string4 = string4.replaceAll("__PROJECT_NAME__", ClientStubsGenerator.this.getProjectName());
                        continue;
                    }
                    if ("<!-- __DOJO_RESOURCE_SELECT_LIST__ -->".equals(string9)) {
                        string4 = string4.replaceAll("<!-- __DOJO_RESOURCE_SELECT_LIST__ -->", ClientStubsGenerator.this.dojoResSelList + "\n<!-- __DOJO_RESOURCE_SELECT_LIST__ -->");
                        continue;
                    }
                    if ("<!-- __JMAKI_RESOURCE_SELECT_LIST__ -->".equals(string9)) {
                        string4 = string4.replaceAll("<!-- __JMAKI_RESOURCE_SELECT_LIST__ -->", ClientStubsGenerator.this.jmakiResSelList + "\n<!-- __JMAKI_RESOURCE_SELECT_LIST__ -->");
                        continue;
                    }
                    if (!"<!-- __JMAKI_RESOURCE_TAG_LIST__ -->".equals(string9)) continue;
                    string4 = string4.replaceAll("<!-- __JMAKI_RESOURCE_TAG_LIST__ -->", ClientStubsGenerator.this.jmakiResTagList + "\n<!-- __JMAKI_RESOURCE_TAG_LIST__ -->");
                }
            } else if (representationNode != null) {
                String string10 = this.r.getName();
                String string11 = representationNode.getName();
                for (String string12 : stringArray2) {
                    String string13;
                    if ("__GENERIC_NAME__".equals(string12)) {
                        string4 = string4.replaceAll("__GENERIC_NAME__", string10);
                        continue;
                    }
                    if ("__GENERIC_PATH_NAME__".equals(string12)) {
                        string4 = string4.replaceAll("__GENERIC_PATH_NAME__", string11);
                        continue;
                    }
                    if ("__FIELDS_DEFINITION__".equals(string12)) {
                        string4 = string4.replaceAll("__FIELDS_DEFINITION__", this.createFieldsDefinition(representationNode, true));
                        continue;
                    }
                    if ("__GETTER_SETTER_METHODS__".equals(string12)) {
                        string4 = string4.replace("__GETTER_SETTER_METHODS__", this.createGetterSetterMethods(representationNode, true));
                        continue;
                    }
                    if ("__FIELDS_INIT__".equals(string12)) {
                        string4 = string4.replace("__FIELDS_INIT__", this.createFieldsInitBody(representationNode, true, string3));
                        continue;
                    }
                    if ("__SUB_RESOURCE_NAME__".equals(string12)) {
                        string4 = string4.replaceAll("__SUB_RESOURCE_NAME__", "");
                        continue;
                    }
                    if ("__SUB_RESOURCE_PATH_NAME__".equals(string12)) {
                        string4 = string4.replaceAll("__SUB_RESOURCE_PATH_NAME__", "");
                        continue;
                    }
                    if ("__FIELDS_TOSTRING__".equals(string12)) {
                        string13 = this.createFieldsToStringBody(representationNode, true);
                        if (string13.endsWith(",'+\n")) {
                            string13 = string13.substring(0, string13.length() - 4) + "'+\n";
                        }
                        string4 = string4.replace("__FIELDS_TOSTRING__", string13);
                        continue;
                    }
                    if ("__FIELD_NAMES_TOSTRING__".equals(string12)) {
                        string13 = this.createFieldNamesBody(representationNode, true);
                        string4 = string4.replace("__FIELD_NAMES_TOSTRING__", string13);
                        continue;
                    }
                    if (!"__STUB_METHODS__".equals(string12)) continue;
                    string4 = string4.replace("__STUB_METHODS__", this.createStubJSMethods(this.r, string2, string3));
                }
            } else {
                String string14 = this.r.getName();
                for (String string15 : stringArray3) {
                    if ("__RESOURCE_NAME__".equals(string15)) {
                        string4 = string4.replaceAll("__RESOURCE_NAME__", string14);
                        continue;
                    }
                    if (!"__STUB_METHODS__".equals(string15)) continue;
                    string4 = string4.replace("__STUB_METHODS__", this.createStubJSMethods(this.r, string2, string3));
                }
            }
            return string4;
        }

        protected String createStubJSMethods(ClientStubModel.Resource resource, String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            ClientStubModel.Method method = null;
            Object object = resource.getMethods().iterator();
            while (object.hasNext()) {
                ClientStubModel.Method method2 = object.next();
                if (method2.getType() != ClientStubModel.MethodType.GET) continue;
                method = method2;
            }
            if (method != null && (object = this.createDefaultGetMethod(method, "rjsSupport.")) != null) {
                stringBuffer.append((String)object + ",\n\n");
            }
            for (ClientStubModel.Method method2 : resource.getMethods()) {
                stringBuffer.append(this.createMethod(method2, "rjsSupport.", string2) + ",\n\n");
            }
            object = stringBuffer.toString();
            if (((String)object).length() > 3) {
                return ((String)object).substring(0, ((String)object).length() - 3) + "\n";
            }
            return object;
        }

        private String createGetterSetterMethods(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.createGetterSetterMethods(representationNode.getAttributes(), bl));
            stringBuffer.append(this.createGetterSetterMethods(representationNode.getChildren(), bl));
            return stringBuffer.toString();
        }

        private String createGetterSetterMethods(List<ClientStubModel.RepresentationNode> list, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode : list) {
                String string = representationNode.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append(this.createGetterMethod(representationNode) + ",\n\n");
                stringBuffer.append(this.createSetterMethod(representationNode) + ",\n\n");
            }
            return stringBuffer.toString();
        }

        private String createFieldsDefinition(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string = representationNode2.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append("    this." + string + " = '';\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string = representationNode2.getName();
                if (representationNode2.isRoot()) {
                    stringBuffer.append("    this." + string + " = new Array();\n");
                    continue;
                }
                stringBuffer.append("    this." + string + " = '';\n");
            }
            return stringBuffer.toString();
        }

        private String createFieldsInitBody(ClientStubModel.RepresentationNode representationNode, boolean bl, String string) {
            String string2;
            String string3 = representationNode.getName();
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string2 = representationNode2.getName();
                if (bl && string2.equals("uri")) continue;
                stringBuffer.append("         this." + string2 + " = " + string3 + "['@" + string2 + "'];\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string2 = representationNode2.getName();
                if (representationNode2.isReference() || representationNode2.isRoot()) {
                    String string4 = this.findRepresentationName(string2);
                    stringBuffer.append("         this." + string2 + " = new " + string + this.findResourceName(string2) + "(" + string3 + "['" + string2 + "']['@uri']);\n");
                    continue;
                }
                stringBuffer.append("         this." + string2 + " = this.findValue(this." + string2 + ", " + string3 + "['" + string2 + "']);\n");
            }
            return stringBuffer.toString();
        }

        private String createFieldsToStringBody(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string = representationNode2.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append("         '\"@" + string + "\":\"'+this." + string + "+'\",'+\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string = representationNode2.getName();
                if (representationNode2.isReference()) {
                    String string2 = this.findRepresentationName(string);
                    if (representationNode2.isEntity()) {
                        stringBuffer.append("         '\"" + string + "\":{\"@uri\":\"'+" + "this." + string + ".getUri()+'\", \"" + string2 + "\":" + ":\"'+eval(\"this." + string + ".get\"+this." + string + ".getFields()[0].substring(0,1).toUpperCase()+this." + string + ".getFields()[0].substring(1)+\"()\")+'\"},'+\n");
                        continue;
                    }
                    stringBuffer.append("         '\"" + string + "\":{\"@uri\":\"'+this." + string + ".getUri()+'\"},'+\n");
                    continue;
                }
                if (representationNode2.isRoot()) {
                    stringBuffer.append("         this." + string + ".toString()+','+\n");
                    continue;
                }
                stringBuffer.append("         '\"" + string + "\":\"'+this." + string + "+'\",'+\n");
            }
            return stringBuffer.toString();
        }

        private String createFieldNamesBody(ClientStubModel.RepresentationNode representationNode, boolean bl) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getAttributes()) {
                string = representationNode2.getName();
                if (bl && string.equals("uri")) continue;
                stringBuffer.append("         fields.push('" + string + "');\n");
            }
            for (ClientStubModel.RepresentationNode representationNode2 : representationNode.getChildren()) {
                string = representationNode2.getName();
                if (representationNode2.isReference() || representationNode2.isRoot()) continue;
                stringBuffer.append("         fields.push('" + string + "');\n");
            }
            return stringBuffer.toString();
        }

        private String findResourceName(String string) {
            if (string.contains("Ref")) {
                string = string.substring(0, string.indexOf("Ref"));
            }
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }

        private String findRepresentationName(String string) {
            if (string.contains("Ref")) {
                return string.substring(0, string.indexOf("Ref"));
            }
            return string;
        }

        private String createGetterMethod(ClientStubModel.RepresentationNode representationNode) {
            String string = RestUtils.createGetterMethodName(representationNode);
            String string2 = representationNode.getName();
            return "   " + string + " : function() {\n" + "      if(!this.initialized)\n" + "         this.init();\n" + "      return this." + string2 + ";\n" + "   }";
        }

        private String createSetterMethod(ClientStubModel.RepresentationNode representationNode) {
            String string = this.createSetterMethodName(representationNode);
            String string2 = representationNode.getName();
            return "   " + string + " : function(" + string2 + "_) {\n" + "      this." + string2 + " = " + string2 + "_;\n" + "   }";
        }

        private String createSetterMethodName(ClientStubModel.RepresentationNode representationNode) {
            String string = "set";
            if (representationNode.getLink() != null) {
                string = RestUtils.escapeJSReserved(representationNode.getLink().getName().toString());
                string = "set" + string.substring(3);
            } else {
                string = representationNode.getName();
                string = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
            }
            return string;
        }

        private String createMethod(ClientStubModel.Method method, String string, String string2) {
            if (method.getType() == ClientStubModel.MethodType.GET) {
                return this.createGetMethod(method, string);
            }
            if (method.getType() == ClientStubModel.MethodType.POST) {
                return this.createPostMethod(method, string);
            }
            if (method.getType() == ClientStubModel.MethodType.PUT) {
                return this.createPutMethod(method, string);
            }
            if (method.getType() == ClientStubModel.MethodType.DELETE) {
                return this.createDeleteMethod(method, string);
            }
            if (method instanceof ClientStubModel.NavigationMethod) {
                return this.createNavigationMethod((ClientStubModel.NavigationMethod)method, string2);
            }
            return "";
        }

        private String createMethodName(ClientStubModel.Method method, String string, int n) {
            if (n > 1) {
                for (Constants.MimeType mimeType : Constants.MimeType.values()) {
                    if (!mimeType.value().equals(string)) continue;
                    return method.getName() + mimeType.suffix();
                }
            }
            return method.getName();
        }

        private String createDefaultGetMethod(ClientStubModel.Method method, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = null;
            for (ClientStubModel.Representation representation : method.getResponse().getRepresentation()) {
                String string3 = representation.getMime();
                if (!(string3 = string3.replaceAll("\"", "").trim()).equals(Constants.MimeType.JSON.value())) continue;
                string2 = string3;
            }
            if (string2 != null) {
                stringBuffer.append("/* Default getJson() method used by Container/Containee init() methods. Do not remove. */\n");
                stringBuffer.append("   getJson : function() {\n      return " + string + "get(this.uri, '" + string2 + "');\n" + "   }");
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
            return null;
        }

        private String createGetMethod(ClientStubModel.Method method, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = method.getResponse().getRepresentation().size();
            for (ClientStubModel.Representation representation : method.getResponse().getRepresentation()) {
                String string2 = representation.getMime();
                string2 = string2.replaceAll("\"", "").trim();
                stringBuffer.append("   " + this.createMethodName(method, string2, n) + " : function() {\n" + "      return " + string + "get(this.uri, '" + string2 + "');\n" + "   },\n\n");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 3) {
                return string3.substring(0, string3.length() - 3);
            }
            return string3;
        }

        private String createPostMethod(ClientStubModel.Method method, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = method.getRequest().getRepresentation().size();
            for (ClientStubModel.Representation representation : method.getRequest().getRepresentation()) {
                String string2 = representation.getMime();
                string2 = string2.replaceAll("\"", "").trim();
                stringBuffer.append("   " + this.createMethodName(method, string2, n) + " : function(content) {\n" + "      return " + string + "post(this.uri, '" + string2 + "', content);\n" + "   },\n\n");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 3) {
                return string3.substring(0, string3.length() - 3);
            }
            return string3;
        }

        private String createPutMethod(ClientStubModel.Method method, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = method.getRequest().getRepresentation().size();
            for (ClientStubModel.Representation representation : method.getRequest().getRepresentation()) {
                String string2 = representation.getMime();
                string2 = string2.replaceAll("\"", "").trim();
                stringBuffer.append("   " + this.createMethodName(method, string2, n) + " : function(content) {\n" + "      return " + string + "put(this.uri, '" + string2 + "', content);\n" + "   },\n\n");
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 3) {
                return string3.substring(0, string3.length() - 3);
            }
            return string3;
        }

        private String createDeleteMethod(ClientStubModel.Method method, String string) {
            return "   " + RestUtils.escapeJSReserved(method.getName()) + " : function() {\n" + "      return " + string + "delete_(this.uri);\n" + "   }";
        }

        private String createNavigationMethod(ClientStubModel.NavigationMethod navigationMethod, String string) {
            String string2 = "";
            String string3 = "";
            if (navigationMethod.getNavigationUri().contains(",")) {
                String[] stringArray;
                for (String string4 : stringArray = navigationMethod.getNavigationUri().split(",")) {
                    if (string4.startsWith("{")) {
                        string4 = string4.substring(1);
                    } else if (string4.endsWith("}")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    string2 = string2 + string4 + "+','+";
                    string3 = string3 + string4 + ",";
                }
                string2 = string2.substring(0, string2.length() - 5);
                string3 = string3.substring(0, string3.length() - 1);
            } else {
                string3 = string2 = navigationMethod.getNavigationUri();
            }
            return "   " + navigationMethod.getName() + " : function(" + string3 + ") {\n" + "      var link = new " + string + navigationMethod.getLinkName() + "(this.uri+'/'+" + string2 + ")()\n" + "      return link;\n" + "   }";
        }
    }
}

