/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.anttasks;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.tools.ant.BuildException;
import org.netbeans.modules.xslt.project.anttasks.jbi.TMapServiceEntry;
import org.netbeans.modules.xslt.tmap.model.xsltmap.TransformationDescType;
import org.netbeans.modules.xslt.tmap.model.xsltmap.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldProjectTransformer {
    private Map<String, String> mNameSpacePrefix = new HashMap<String, String>();
    private String mSourceDirectory = null;
    private String mBuildDirectory = null;
    private List<TMapServiceEntry> mProviders = new ArrayList<TMapServiceEntry>();
    private List<TMapServiceEntry> mConsumers = new ArrayList<TMapServiceEntry>();
    private Logger logger = Logger.getLogger(OldProjectTransformer.class.getName());
    public static final String VERSION_ATTR_NAME = "version";
    public static final String VERSION_ATTR_VALUE = "1.0";
    public static final String NS_ATTR_NAME = "xmlns";
    public static final String NS_ATTR_VALUE = "http://java.sun.com/xml/ns/jbi";
    public static final String NS_XSI_ATTR_NAME = "xmlns:xsi";
    public static final String NS_XSI_ATTR_VALUE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_ATTR_NAME = "xsi:schemaLocation";
    public static final String XSI_ATTR_VALUE = "http://java.sun.com/xml/ns/jbi jbi.xsd";
    public static final String NAMESPACE_PREFIX = "ns";
    public static final String COLON_SEPARATOR = ":";

    public OldProjectTransformer(String srcDir, String buildDir) {
        this.mSourceDirectory = srcDir;
        this.mBuildDirectory = buildDir;
    }

    public void setBuildDirectory(String buildDir) {
        this.mBuildDirectory = buildDir;
    }

    public String getBuildDirectory() {
        return this.mBuildDirectory;
    }

    public void setSourceDirectory(String srcDir) {
        this.mSourceDirectory = srcDir;
    }

    public String getSourceDirectory() {
        return this.mSourceDirectory;
    }

    public void execute() throws BuildException {
        File xsltMapFile = this.getXsltMapFile();
        Document document = null;
        if (xsltMapFile != null && xsltMapFile.exists()) {
            document = XmlUtil.getDocument((File)xsltMapFile);
        }
        if (document != null) {
            NodeList outputNodeList;
            NodeList inputNodeList = document.getElementsByTagName(TransformationDescType.INPUT.getTagName());
            if (inputNodeList != null && inputNodeList.getLength() > 0) {
                this.populateProviderServices(xsltMapFile.getParentFile(), inputNodeList);
            }
            if ((outputNodeList = document.getElementsByTagName(TransformationDescType.OUTPUT.getTagName())) != null && outputNodeList.getLength() > 0) {
                this.populateConsumerServices(xsltMapFile.getParentFile(), outputNodeList);
            }
        }
        try {
            this.generateTransformMap();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTransformMap() throws IOException {
        FileOutputStream fos = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("<transformmap \n");
            sb.append("       xmlns=\"http://xml.netbeans.org/schema/transformmap\"\n");
            int nss = this.mNameSpacePrefix.size();
            int i = 0;
            Set<String> nsUris = this.mNameSpacePrefix.keySet();
            for (String nsUri : nsUris) {
                sb.append("        xmlns:" + this.mNameSpacePrefix.get(nsUri) + "=\"" + nsUri + "\"");
                if (++i >= nss - 1) continue;
                sb.append("\n");
            }
            sb.append(">\n");
            if (this.mProviders != null) {
                List<TMapServiceEntry> uniqueServices = this.getUniqueServices(this.mProviders);
                for (TMapServiceEntry uniqueService : uniqueServices) {
                    sb.append("    <service partnerLinkType=\"").append(OldProjectTransformer.getColonedQName(uniqueService.getPartnerLinkNameQname(), this.mNameSpacePrefix)).append("\"");
                    sb.append(" roleName=\"").append(uniqueService.getRoleName()).append("\" >\n");
                    sb.append(this.getServiceOperations(this.mProviders, uniqueService));
                    sb.append("    </service>\n");
                }
            }
            sb.append("</transformmap>\n");
            String content = sb.toString();
            fos = new FileOutputStream(this.getTransformMapFile());
            OldProjectTransformer.store(content.getBytes("UTF-8"), fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private List<TMapServiceEntry> getUniqueServices(List<TMapServiceEntry> allServices) {
        ArrayList<TMapServiceEntry> uniqueServices = new ArrayList<TMapServiceEntry>();
        if (allServices == null) {
            return uniqueServices;
        }
        for (int j = 0; j < allServices.size(); ++j) {
            TMapServiceEntry tmpService = allServices.get(j);
            boolean isUnique = true;
            for (TMapServiceEntry uniqueServiceEntry : uniqueServices) {
                QName servicePltQname = tmpService.getPartnerLinkNameQname();
                String serviceRoleName = tmpService.getRoleName();
                if (servicePltQname == null || !servicePltQname.equals(uniqueServiceEntry.getPartnerLinkNameQname()) || serviceRoleName == null || !serviceRoleName.equals(uniqueServiceEntry.getRoleName())) continue;
                isUnique = false;
            }
            if (!isUnique) continue;
            uniqueServices.add(tmpService);
        }
        return uniqueServices;
    }

    private String getServiceOperations(List<TMapServiceEntry> allServices, TMapServiceEntry uniqueService) {
        assert (uniqueService != null && allServices != null);
        assert (uniqueService.getPartnerLinkNameQname() != null && uniqueService.getRoleName() != null);
        StringBuffer serviceOperations = new StringBuffer("");
        for (TMapServiceEntry service : allServices) {
            if (!uniqueService.getRoleName().equals(service.getRoleName()) || !uniqueService.getPartnerLinkNameQname().equals(service.getPartnerLinkNameQname())) continue;
            TMapServiceEntry invoke = this.getInvoke(service);
            StringBuffer invokeSb = new StringBuffer();
            if (invoke != null) {
                invokeSb.append("            <invoke partnerLinkType=\"").append(OldProjectTransformer.getColonedQName(invoke.getPartnerLinkNameQname(), this.mNameSpacePrefix));
                invokeSb.append(" opName=\"").append(invoke.getOperation()).append("\" ");
                invokeSb.append(" roleName=\"").append(invoke.getRoleName()).append("\" ");
                invokeSb.append(" file=\"").append(invoke.getFile()).append("\" ");
                invokeSb.append(" transformJBI=\"").append(invoke.getTransformJBI()).append("\" ");
            } else {
                invokeSb.append("/>\n");
            }
            StringBuffer sbOperation = new StringBuffer();
            sbOperation.append("        <operation");
            sbOperation.append(" opName=\"").append(service.getOperation()).append("\" ");
            sbOperation.append(invokeSb);
            serviceOperations.append(sbOperation);
        }
        return serviceOperations.toString();
    }

    private TMapServiceEntry getInvoke(TMapServiceEntry input) {
        if (this.mConsumers == null || this.mConsumers.size() == 0 || input == null || input.getNode() == null) {
            return null;
        }
        TMapServiceEntry invoke = null;
        for (TMapServiceEntry consumer : this.mConsumers) {
            Node tmpNode = consumer.getNode();
            tmpNode = tmpNode == null ? null : tmpNode.getParentNode();
            if (tmpNode == null || !TransformationDescType.INPUT.getTagName().equals(tmpNode.getLocalName()) || !tmpNode.equals(input.getNode().getParentNode())) continue;
            invoke = consumer;
            break;
        }
        return invoke;
    }

    private File getXsltMapFile() throws BuildException {
        String srcDir = this.getSourceDirectory();
        if (srcDir == null || "".equals(srcDir)) {
            throw new BuildException("source directory shouldn't be null or empty");
        }
        File xsltMapFile = new File(srcDir + "/" + "xsltmap.xml");
        return xsltMapFile;
    }

    private File getTransformMapFile() throws BuildException {
        String srcDir = this.getSourceDirectory();
        if (srcDir == null || "".equals(srcDir)) {
            throw new BuildException("source directory shouldn't be null or empty");
        }
        File transformMapFile = new File(srcDir + "/" + "transformmap.xml");
        return transformMapFile;
    }

    private String populateNamespace(String namespaceURI) {
        if (namespaceURI == null || "".equals(namespaceURI)) {
            return null;
        }
        String namespacePrefix = null;
        namespacePrefix = this.mNameSpacePrefix.get(namespaceURI);
        if (namespacePrefix == null) {
            namespacePrefix = NAMESPACE_PREFIX + this.mNameSpacePrefix.size();
            this.mNameSpacePrefix.put(namespaceURI, namespacePrefix);
        }
        return namespacePrefix;
    }

    private void populateServices(File projectSourceRoot, NodeList nodeList, List<TMapServiceEntry> services) {
        if (services == null) {
            return;
        }
        Object service = null;
        assert (nodeList != null);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node tmpNode = nodeList.item(i);
            NamedNodeMap namedNodeMap = tmpNode.getAttributes();
            String partnerLink = XmlUtil.getAttrValue((NamedNodeMap)namedNodeMap, (String)"partnerLink");
            QName partnerLinkQname = OldProjectTransformer.getQName(partnerLink);
            if (partnerLinkQname == null) continue;
            this.populateNamespace(partnerLinkQname.getNamespaceURI());
            String roleName = XmlUtil.getAttrValue((NamedNodeMap)namedNodeMap, (String)"roleName");
            String operation = XmlUtil.getAttrValue((NamedNodeMap)namedNodeMap, (String)"operation");
            String file = XmlUtil.getAttrValue((NamedNodeMap)namedNodeMap, (String)"file");
            String transformJBI = XmlUtil.getAttrValue((NamedNodeMap)namedNodeMap, (String)"transformJBI");
            services.add(new TMapServiceEntry(partnerLinkQname, roleName, operation, file, transformJBI, tmpNode));
        }
    }

    private void populateProviderServices(File projectSourceRoot, NodeList nodeList) {
        if (this.mProviders == null) {
            this.mProviders = new ArrayList<TMapServiceEntry>();
        }
        this.populateServices(projectSourceRoot, nodeList, this.mProviders);
    }

    private void populateConsumerServices(File projectSourceRoot, NodeList nodeList) {
        if (this.mConsumers == null) {
            this.mConsumers = new ArrayList<TMapServiceEntry>();
        }
        this.populateServices(projectSourceRoot, nodeList, this.mConsumers);
    }

    private static String getColonedQName(QName qn, Map nsTable) {
        String ns = qn.getNamespaceURI();
        String prefix = (String)nsTable.get(ns);
        if (prefix == null) {
            return qn.getLocalPart();
        }
        return prefix + COLON_SEPARATOR + qn.getLocalPart();
    }

    private static QName getQName(String qname) {
        return QName.valueOf(qname);
    }

    private static void store(byte[] input, OutputStream output) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        byte[] buf = new byte[4096];
        int n = 0;
        while ((n = in.read(buf)) != -1) {
            output.write(buf, 0, n);
        }
        output.flush();
    }
}

