/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.editors.api.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.bpel.editors.api.Constants;
import org.netbeans.modules.bpel.editors.api.nodes.FactoryAccess;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BooleanExpr;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.CompensatableActivityHolder;
import org.netbeans.modules.bpel.model.api.Compensate;
import org.netbeans.modules.bpel.model.api.CompensateScope;
import org.netbeans.modules.bpel.model.api.CompensationHandler;
import org.netbeans.modules.bpel.model.api.CompletionCondition;
import org.netbeans.modules.bpel.model.api.CompositeActivity;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationSetContainer;
import org.netbeans.modules.bpel.model.api.Else;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.Empty;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.Exit;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.Flow;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromPart;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.MessageExchange;
import org.netbeans.modules.bpel.model.api.MessageExchangeContainer;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.OnAlarmPick;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PatternedCorrelation;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.ReThrow;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.TerminationHandler;
import org.netbeans.modules.bpel.model.api.Throw;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.ToPart;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.SchemaColumnsView;
import org.netbeans.modules.xml.schema.ui.basic.SchemaTreeView;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.highlight.Highlight;
import org.netbeans.modules.xml.xam.ui.highlight.HighlightGroup;
import org.netbeans.modules.xml.xam.ui.highlight.HighlightManager;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private static Map<Class<? extends Component>, NodeType> ENTITY_NODETYPE_MAP = new HashMap<Class<? extends Component>, NodeType>();

    private Util() {
    }

    public static NodeType getBasicNodeType(Class<? extends Component> clazz) {
        NodeType nodeType = ENTITY_NODETYPE_MAP.get(clazz);
        return nodeType == null ? NodeType.UNKNOWN_TYPE : nodeType;
    }

    public static boolean isNavigatorShowableNodeType(NodeType nodeType) {
        if (nodeType == null) {
            return false;
        }
        boolean bl = true;
        switch (nodeType) {
            case UNKNOWN_TYPE: 
            case DEFAULT_BPEL_ENTITY_NODE: 
            case FROM: 
            case TO: 
            case BOOLEAN_EXPR: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public static Node getClosestNavigatorNode(BpelEntity bpelEntity, Lookup lookup) {
        BpelEntity bpelEntity2;
        if (bpelEntity == null || bpelEntity.getElementType() == null) {
            return null;
        }
        Node node = null;
        NodeType nodeType = Util.getBasicNodeType((Component)bpelEntity);
        for (bpelEntity2 = bpelEntity; !Util.isNavigatorShowableNodeType(nodeType) && bpelEntity2 != null; bpelEntity2 = bpelEntity2.getParent()) {
            nodeType = Util.getBasicNodeType((Component)bpelEntity2);
        }
        if (bpelEntity2 != null && !NodeType.UNKNOWN_TYPE.equals((Object)nodeType)) {
            node = FactoryAccess.getPropertyNodeFactory().createNode((Object)nodeType, (Object)bpelEntity2, lookup);
        }
        return node;
    }

    public static Component getRoot(Model model) {
        if (model instanceof BpelModel) {
            return ((BpelModel)model).getProcess();
        }
        if (model instanceof SchemaModel) {
            return ((SchemaModel)model).getSchema();
        }
        if (model instanceof WSDLModel) {
            return ((WSDLModel)model).getDefinitions();
        }
        return null;
    }

    public static NodeType getBasicNodeType(Component component) {
        if (!(component instanceof BpelEntity)) {
            return null;
        }
        BpelEntity bpelEntity = (BpelEntity)component;
        if (bpelEntity == null || bpelEntity.getElementType() == null) {
            return null;
        }
        return Util.getBasicNodeType(bpelEntity.getElementType());
    }

    public static void goToSource(Component component) {
        if (!(component instanceof DocumentComponent)) {
            return;
        }
        DocumentComponent documentComponent = (DocumentComponent)component;
        FileObject fileObject = Util.getFileObjectByModel(component.getModel());
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return;
            }
            int n = Util.getLineNum(documentComponent);
            if (n < 0) {
                return;
            }
            final Line line = lineCookie.getLineSet().getCurrent(n);
            final int n2 = Util.getColumnNum(documentComponent);
            if (n2 < 0) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    line.show(2, n2);
                    Util.openActiveSourceEditor();
                }
            });
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
    }

    public static void goToLoggingAlerting(Component component) {
        assert (component instanceof BpelEntity);
        BpelEntity bpelEntity = (BpelEntity)component;
        FileObject fileObject = Util.getFileObjectByModel((Model)bpelEntity.getBpelModel());
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            Lookup lookup = dataObject.getLookup();
            final EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
            if (editCookie == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    editCookie.edit();
                    Util.openActiveLoggingEditor();
                }
            });
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
    }

    public static void goToBusinessRules(Component component) {
        assert (component instanceof BpelEntity);
        final BpelEntity bpelEntity = (BpelEntity)component;
        FileObject fileObject = Util.getFileObjectByModel((Model)bpelEntity.getBpelModel());
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            final Lookup lookup = dataObject.getLookup();
            final EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
            if (editCookie == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    editCookie.edit();
                    Util.openActiveMapperEditor();
                    if (lookup != null || bpelEntity != null) {
                        NodeType nodeType = Util.getBasicNodeType((Component)bpelEntity);
                        if (nodeType == null || NodeType.UNKNOWN_TYPE.equals((Object)nodeType)) {
                            return;
                        }
                        Node node = FactoryAccess.getPropertyNodeFactory().createNode((Object)nodeType, (Object)bpelEntity, lookup);
                        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
                        if (topComponent != null) {
                            topComponent.setActivatedNodes(new Node[0]);
                            topComponent.setActivatedNodes(new Node[]{node});
                        }
                    }
                }
            });
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
    }

    public static void goToDesign(Component component) {
        Util.goToDesign(component, null, null);
    }

    public static void goToDesign(Component component, Object object, Object object2) {
        if (!(component instanceof BpelEntity)) {
            HighlightGroup highlightGroup2;
            HighlightManager highlightManager = HighlightManager.getDefault();
            List list = highlightManager.getHighlightGroups("search");
            if (list != null) {
                for (HighlightGroup highlightGroup2 : list) {
                    highlightManager.removeHighlightGroup(highlightGroup2);
                }
            }
            HighlightGroup highlightGroup3 = new HighlightGroup("search");
            highlightGroup2 = new Highlight(component, "searchResult");
            highlightGroup3.addHighlight((Highlight)highlightGroup2);
            highlightManager.addHighlightGroup(highlightGroup3);
            if (object2 instanceof SchemaTreeView && component instanceof SchemaComponent) {
                ((SchemaTreeView)object2).showComponent((SchemaComponent)component);
                return;
            }
            if (object2 instanceof SchemaColumnsView && component instanceof SchemaComponent) {
                ((SchemaColumnsView)object2).showComponent((SchemaComponent)component);
                return;
            }
            if (object instanceof ShowCookie) {
                ((ShowCookie)object).show(new Validator.ResultItem(null, null, component, null));
                return;
            }
            return;
        }
        final BpelEntity bpelEntity = (BpelEntity)component;
        FileObject fileObject = Util.getFileObjectByModel((Model)bpelEntity.getBpelModel());
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            final Lookup lookup = dataObject != null ? dataObject.getLookup() : null;
            final EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
            if (editCookie == null) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    editCookie.edit();
                    Util.openActiveDesignEditor();
                    if (lookup != null || bpelEntity != null) {
                        NodeType nodeType = Util.getBasicNodeType((Component)bpelEntity);
                        if (nodeType == null) {
                            return;
                        }
                        if (NodeType.UNKNOWN_TYPE.equals((Object)nodeType)) {
                            nodeType = NodeType.DEFAULT_BPEL_ENTITY_NODE;
                        }
                        Node node = FactoryAccess.getPropertyNodeFactory().createNode((Object)nodeType, (Object)bpelEntity, lookup);
                        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
                        if (topComponent != null) {
                            topComponent.setActivatedNodes(new Node[0]);
                            topComponent.setActivatedNodes(new Node[]{node});
                        }
                    }
                }
            });
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
    }

    public static FileObject getFileObjectByModel(Model model) {
        Lookup lookup;
        ModelSource modelSource;
        if (model != null && (modelSource = model.getModelSource()) != null && (lookup = modelSource.getLookup()) != null) {
            return (FileObject)lookup.lookup(FileObject.class);
        }
        return null;
    }

    public static String getTextForBpelEntity(Component component) {
        BpelEntity bpelEntity = null;
        if (component instanceof BpelEntity) {
            bpelEntity = (BpelEntity)BpelEntity.class.cast(component);
        }
        if (bpelEntity == null) {
            return "";
        }
        FileObject fileObject = Util.getFileObjectByModel((Model)bpelEntity.getBpelModel());
        if (fileObject == null) {
            return "";
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
        int n = Util.getLineNum((DocumentComponent)bpelEntity);
        int n2 = Util.getColumnNum((DocumentComponent)bpelEntity);
        ModelSource modelSource = bpelEntity.getBpelModel().getModelSource();
        assert (modelSource != null);
        Lookup lookup = modelSource.getLookup();
        StyledDocument styledDocument = (StyledDocument)lookup.lookup(StyledDocument.class);
        if (styledDocument == null) {
            return "";
        }
        CloneableEditorSupport cloneableEditorSupport = (CloneableEditorSupport)dataObject.getCookie(EditorCookie.class);
        Line.Set set = cloneableEditorSupport.getLineSet();
        Line line = set.getCurrent(n);
        String string = line.getText().trim();
        Pattern pattern = Pattern.compile("<");
        Matcher matcher = pattern.matcher(string);
        string = matcher.replaceAll("&lt;");
        Pattern pattern2 = Pattern.compile(">");
        Matcher matcher2 = pattern2.matcher(string);
        string = matcher2.replaceAll("&gt;");
        return Util.boldenRefOrType(string);
    }

    private static int getLineNum(DocumentComponent documentComponent) {
        int n = documentComponent.findPosition();
        ModelSource modelSource = documentComponent.getModel().getModelSource();
        assert (modelSource != null);
        Lookup lookup = modelSource.getLookup();
        StyledDocument styledDocument = (StyledDocument)lookup.lookup(StyledDocument.class);
        if (styledDocument == null) {
            return -1;
        }
        return NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
    }

    private static int getColumnNum(DocumentComponent documentComponent) {
        int n = documentComponent.findPosition();
        ModelSource modelSource = documentComponent.getModel().getModelSource();
        assert (modelSource != null);
        Lookup lookup = modelSource.getLookup();
        StyledDocument styledDocument = (StyledDocument)lookup.lookup(StyledDocument.class);
        if (styledDocument == null) {
            return -1;
        }
        return NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
    }

    private static void openActiveDesignEditor() {
        Util.openActiveMVEditor("orch-designer");
    }

    private static void openActiveMapperEditor() {
        Util.openActiveMVEditor("bpel-business-rules");
    }

    private static void openActiveLoggingEditor() {
        Util.openActiveMVEditor("bpel-logging-alerting");
    }

    private static void openActiveSourceEditor() {
        Util.openActiveMVEditor("bpelsource");
    }

    private static void openActiveMVEditor(String string) {
        if (string == null) {
            return;
        }
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler == null) {
            return;
        }
        MultiViewPerspective[] multiViewPerspectiveArray = multiViewHandler.getPerspectives();
        if (multiViewPerspectiveArray != null && multiViewPerspectiveArray.length > 0) {
            for (MultiViewPerspective multiViewPerspective : multiViewPerspectiveArray) {
                if (!multiViewPerspective.preferredID().equals(string)) continue;
                multiViewHandler.requestVisible(multiViewPerspective);
                multiViewHandler.requestActive(multiViewPerspective);
            }
        }
    }

    private static String boldenRefOrType(String string) {
        int n;
        int n2 = string.indexOf(" type");
        if (n2 < 0) {
            n2 = string.indexOf(" ref");
        }
        if (n2 < 0) {
            return string;
        }
        int n3 = string.indexOf(34, n2);
        if (n3 < n2) {
            return string;
        }
        int n4 = string.indexOf(58, n3);
        if (n4 < n3) {
            // empty if block
        }
        if ((n = string.indexOf(34, n3 + 1)) < n3 || n4 > n) {
            return string;
        }
        int n5 = -1;
        n5 = n4 > -1 ? n4 + 1 : n3 + 1;
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(n5, "<b>");
        stringBuffer.insert(n + 3, "</b>");
        return stringBuffer.toString();
    }

    public static void goToReferenceSource(Reference<Referenceable> reference) {
        Referenceable referenceable = reference.get();
        if (referenceable == null) {
            return;
        }
        if (!(referenceable instanceof DocumentComponent)) {
            return;
        }
        Util.goToDocumentComponentSource((DocumentComponent<DocumentComponent>)((DocumentComponent)referenceable));
    }

    public static boolean canGoToDocumentComponentSource(DocumentComponent<DocumentComponent> documentComponent) {
        if (documentComponent == null) {
            return false;
        }
        Model model = documentComponent.getModel();
        if (model == null) {
            return false;
        }
        ModelSource modelSource = model.getModelSource();
        if (modelSource == null) {
            return false;
        }
        Lookup lookup = modelSource.getLookup();
        if (lookup == null) {
            return false;
        }
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject == null) {
            return false;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        if (dataObject == null) {
            return false;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return false;
        }
        Line.Set set = lineCookie.getLineSet();
        if (set == null) {
            return false;
        }
        StyledDocument styledDocument = (StyledDocument)lookup.lookup(StyledDocument.class);
        if (styledDocument == null) {
            return false;
        }
        Line line = null;
        int n = 0;
        try {
            int n2 = documentComponent.findPosition();
            line = set.getCurrent(NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n2));
            n = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (line == null) {
            try {
                line = lineCookie.getLineSet().getCurrent(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return line != null;
    }

    public static void goToDocumentComponentSource(DocumentComponent<DocumentComponent> documentComponent) {
        if (documentComponent == null) {
            return;
        }
        Model model = documentComponent.getModel();
        if (model == null) {
            return;
        }
        ModelSource modelSource = model.getModelSource();
        if (modelSource == null) {
            return;
        }
        Lookup lookup = modelSource.getLookup();
        if (lookup == null) {
            return;
        }
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject == null) {
            return;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        if (dataObject == null) {
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return;
        }
        Line.Set set = lineCookie.getLineSet();
        if (set == null) {
            return;
        }
        StyledDocument styledDocument = (StyledDocument)lookup.lookup(StyledDocument.class);
        if (styledDocument == null) {
            return;
        }
        Line line = null;
        int n = 0;
        try {
            int n2 = documentComponent.findPosition();
            line = set.getCurrent(NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n2));
            n = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (line == null) {
            try {
                line = lineCookie.getLineSet().getCurrent(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        if (line == null) {
            return;
        }
        final Line line2 = line;
        final int n3 = n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                line2.show(2, n3);
            }
        });
    }

    public static int getChildIndex(BpelEntity bpelEntity, CompositeActivity compositeActivity) {
        assert (bpelEntity != null && compositeActivity != null);
        int n = -1;
        for (int i = 0; i < compositeActivity.sizeOfActivities(); ++i) {
            if (!bpelEntity.equals(compositeActivity.getActivity(i))) continue;
            n = i;
            break;
        }
        return n;
    }

    public static final String getCorrectedHtmlRenderedString(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("&amp;", "&");
        string = string.replaceAll("&gt;", ">;");
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("<", "&lt;");
        return string;
    }

    public static String getTagName(DocumentComponent documentComponent) {
        if (documentComponent == null) {
            return null;
        }
        Element element = documentComponent.getPeer();
        return element == null ? null : element.getTagName();
    }

    public static Constants.VariableStereotype getVariableStereotype(AbstractVariableDeclaration abstractVariableDeclaration) {
        GlobalType globalType;
        if (abstractVariableDeclaration == null) {
            return null;
        }
        Constants.VariableStereotype variableStereotype = null;
        SchemaReference schemaReference = abstractVariableDeclaration.getType();
        variableStereotype = schemaReference != null ? ((globalType = (GlobalType)schemaReference.get()) != null ? Constants.VariableStereotype.recognizeStereotype(globalType) : Constants.VariableStereotype.GLOBAL_TYPE) : (abstractVariableDeclaration.getMessageType() != null ? Constants.VariableStereotype.MESSAGE : (abstractVariableDeclaration.getElement() != null ? Constants.VariableStereotype.GLOBAL_ELEMENT : Constants.VariableStereotype.MESSAGE));
        return variableStereotype;
    }

    public static Reference getVariableType(AbstractVariableDeclaration abstractVariableDeclaration) {
        SchemaReference schemaReference = abstractVariableDeclaration.getElement();
        if (schemaReference != null) {
            return schemaReference;
        }
        SchemaReference schemaReference2 = abstractVariableDeclaration.getType();
        if (schemaReference2 != null) {
            return schemaReference2;
        }
        WSDLReference wSDLReference = abstractVariableDeclaration.getMessageType();
        if (wSDLReference != null) {
            return wSDLReference;
        }
        return null;
    }

    public static SchemaComponent getVariableSchemaType(AbstractVariableDeclaration abstractVariableDeclaration) {
        GlobalType globalType;
        SchemaReference schemaReference;
        SchemaReference schemaReference2 = abstractVariableDeclaration.getElement();
        if (schemaReference2 != null && (schemaReference = (GlobalElement)schemaReference2.get()) != null) {
            return schemaReference;
        }
        schemaReference = abstractVariableDeclaration.getType();
        if (schemaReference != null && (globalType = (GlobalType)schemaReference.get()) != null) {
            return globalType;
        }
        return null;
    }

    public static SchemaComponent getPartType(Part part) {
        GlobalType globalType;
        NamedComponentReference namedComponentReference;
        NamedComponentReference namedComponentReference2 = part.getElement();
        if (namedComponentReference2 != null && (namedComponentReference = (GlobalElement)namedComponentReference2.get()) != null) {
            return namedComponentReference;
        }
        namedComponentReference = part.getType();
        if (namedComponentReference != null && (globalType = (GlobalType)namedComponentReference.get()) != null) {
            return globalType;
        }
        return null;
    }

    static {
        ENTITY_NODETYPE_MAP.put(Assign.class, NodeType.ASSIGN);
        ENTITY_NODETYPE_MAP.put(BooleanExpr.class, NodeType.BOOLEAN_EXPR);
        ENTITY_NODETYPE_MAP.put(Catch.class, NodeType.CATCH);
        ENTITY_NODETYPE_MAP.put(CompensatableActivityHolder.class, NodeType.CATCH_ALL);
        ENTITY_NODETYPE_MAP.put(CompensationHandler.class, NodeType.COMPENSATION_HANDLER);
        ENTITY_NODETYPE_MAP.put(Compensate.class, NodeType.COMPENSATE);
        ENTITY_NODETYPE_MAP.put(CompensateScope.class, NodeType.COMPENSATE_SCOPE);
        ENTITY_NODETYPE_MAP.put(CompletionCondition.class, NodeType.COMPLETION_CONDITION);
        ENTITY_NODETYPE_MAP.put(Copy.class, NodeType.COPY);
        ENTITY_NODETYPE_MAP.put(Correlation.class, NodeType.CORRELATION);
        ENTITY_NODETYPE_MAP.put(CorrelationSet.class, NodeType.CORRELATION_SET);
        ENTITY_NODETYPE_MAP.put(CorrelationSetContainer.class, NodeType.CORRELATION_SET_CONTAINER);
        ENTITY_NODETYPE_MAP.put(Else.class, NodeType.ELSE);
        ENTITY_NODETYPE_MAP.put(ElseIf.class, NodeType.ELSE_IF);
        ENTITY_NODETYPE_MAP.put(Empty.class, NodeType.EMPTY);
        ENTITY_NODETYPE_MAP.put(EventHandlers.class, NodeType.EVENT_HANDLERS);
        ENTITY_NODETYPE_MAP.put(Exit.class, NodeType.EXIT);
        ENTITY_NODETYPE_MAP.put(FaultHandlers.class, NodeType.FAULT_HANDLERS);
        ENTITY_NODETYPE_MAP.put(Flow.class, NodeType.FLOW);
        ENTITY_NODETYPE_MAP.put(ForEach.class, NodeType.FOR_EACH);
        ENTITY_NODETYPE_MAP.put(From.class, NodeType.FROM);
        ENTITY_NODETYPE_MAP.put(FromPart.class, NodeType.FROM_PART);
        ENTITY_NODETYPE_MAP.put(If.class, NodeType.IF);
        ENTITY_NODETYPE_MAP.put(Import.class, NodeType.IMPORT);
        ENTITY_NODETYPE_MAP.put(Invoke.class, NodeType.INVOKE);
        ENTITY_NODETYPE_MAP.put(MessageExchange.class, NodeType.MESSAGE_EXCHANGE);
        ENTITY_NODETYPE_MAP.put(MessageExchangeContainer.class, NodeType.MESSAGE_EXCHANGE_CONTAINER);
        ENTITY_NODETYPE_MAP.put(OnAlarmEvent.class, NodeType.ALARM_EVENT_HANDLER);
        ENTITY_NODETYPE_MAP.put(OnAlarmPick.class, NodeType.ALARM_HANDLER);
        ENTITY_NODETYPE_MAP.put(OnEvent.class, NodeType.ON_EVENT);
        ENTITY_NODETYPE_MAP.put(OnMessage.class, NodeType.MESSAGE_HANDLER);
        ENTITY_NODETYPE_MAP.put(PartnerLink.class, NodeType.PARTNER_LINK);
        ENTITY_NODETYPE_MAP.put(PatternedCorrelation.class, NodeType.CORRELATION_P);
        ENTITY_NODETYPE_MAP.put(Pick.class, NodeType.PICK);
        ENTITY_NODETYPE_MAP.put(Process.class, NodeType.PROCESS);
        ENTITY_NODETYPE_MAP.put(Receive.class, NodeType.RECEIVE);
        ENTITY_NODETYPE_MAP.put(RepeatUntil.class, NodeType.REPEAT_UNTIL);
        ENTITY_NODETYPE_MAP.put(Reply.class, NodeType.REPLY);
        ENTITY_NODETYPE_MAP.put(Scope.class, NodeType.SCOPE);
        ENTITY_NODETYPE_MAP.put(Sequence.class, NodeType.SEQUENCE);
        ENTITY_NODETYPE_MAP.put(TerminationHandler.class, NodeType.TERMINATION_HANDLER);
        ENTITY_NODETYPE_MAP.put(Throw.class, NodeType.THROW);
        ENTITY_NODETYPE_MAP.put(ReThrow.class, NodeType.RETHROW);
        ENTITY_NODETYPE_MAP.put(To.class, NodeType.TO);
        ENTITY_NODETYPE_MAP.put(ToPart.class, NodeType.TO_PART);
        ENTITY_NODETYPE_MAP.put(Wait.class, NodeType.WAIT);
        ENTITY_NODETYPE_MAP.put(While.class, NodeType.WHILE);
        ENTITY_NODETYPE_MAP.put(Variable.class, NodeType.VARIABLE);
        ENTITY_NODETYPE_MAP.put(VariableContainer.class, NodeType.VARIABLE_CONTAINER);
    }
}

