/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.security;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.text.DateFormat;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class KeyAliasCellRenderer
extends DefaultListCellRenderer {
    private static final Image key = Utilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/key.gif");
    private static final Icon ICON_OPENED = new ImageIcon(Utilities.mergeImages((Image)key, (Image)Utilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/unlockedBadge.gif"), (int)0, (int)0));
    private static final Icon ICON_CLOSED = new ImageIcon(Utilities.mergeImages((Image)key, (Image)Utilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/lockedBadge.gif"), (int)0, (int)0));
    private static final Icon ICON_INVALID = new ImageIcon(Utilities.mergeImages((Image)key, (Image)Utilities.loadImage((String)"org/netbeans/modules/mobility/project/ui/resources/invalidBadge.gif"), (int)0, (int)0));
    public static final String notAvailableString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_NotAvailable");
    public static final String invalidKeyAliasString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_InvalidKeyAlias");
    public static final String keyAliasNotUnlockString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_KeyAliasNotUnlock");
    public static final String subjectString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_Subject");
    public static final String issuerString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_Issuer");
    public static final String validString = NbBundle.getMessage(KeyAliasCellRenderer.class, (String)"LBL_Valid");
    public static final DateFormat format = DateFormat.getDateInstance(2);
    private boolean showDetails = false;

    public void setShowDetails(boolean bl) {
        this.showDetails = bl;
        this.firePropertyChange("text", null, null);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof KeyStoreRepository.KeyStoreBean.KeyAliasBean) {
            this.setVerticalAlignment(1);
            KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)object;
            super.getListCellRendererComponent((JList<?>)jList, this.showDetails ? KeyAliasCellRenderer.getHtmlFormattedText(keyAliasBean, bl ? jList.getSelectionForeground() : jList.getForeground()) : keyAliasBean.getAlias(), n, bl, bl2);
            this.setIcon(keyAliasBean.isValid() ? (keyAliasBean.isOpened() ? ICON_OPENED : ICON_CLOSED) : ICON_INVALID);
        } else {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setIcon(null);
        }
        return this;
    }

    public static String getHtmlFormattedText(KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean) {
        return KeyAliasCellRenderer.getHtmlFormattedText(keyAliasBean, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHtmlFormattedText(KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean, Color color) {
        String string;
        if (keyAliasBean == null) {
            return notAvailableString;
        }
        String string2 = string = color == null ? "<html><b>" : "<html><font color=\"#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "\"><b>";
        if (!keyAliasBean.isValid()) {
            return string + keyAliasBean.getAlias() + "</b><br>" + invalidKeyAliasString;
        }
        if (!keyAliasBean.isOpened()) {
            return string + keyAliasBean.getAlias() + "</b><br>" + keyAliasNotUnlockString;
        }
        String string3 = null;
        String string4 = null;
        DateFormat dateFormat = format;
        synchronized (dateFormat) {
            string3 = format.format(keyAliasBean.getNotBefore());
            string4 = format.format(keyAliasBean.getNotAfter());
        }
        return string + keyAliasBean.getAlias() + "</b><br>" + "<i>" + subjectString + ":</i> " + keyAliasBean.getSubjectName() + "<br>" + "<i>" + issuerString + ":</i> " + keyAliasBean.getIssuerName() + "<br>" + "<i>" + validString + ":</i> " + string3 + " - " + string4;
    }
}

