/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer.regex;

import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import org.netbeans.modules.mobility.project.ui.customizer.regex.CheckedNodeEditor;
import org.netbeans.modules.mobility.project.ui.customizer.regex.CheckedNodeRenderer;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedTreeBeanView
extends BeanTreeView {
    private FileObject root;
    private Pattern filter;
    private Map<String, Object> data;
    private final CheckedNodeRenderer renderer;
    private final CheckedNodeEditor editor;
    private Map<String, Object> properties;
    private String propertyName;
    static final Object SELECTED = new Object();
    static final Object UNSELECTED = new Object();
    static final Object MIXED = new Object();

    public CheckedTreeBeanView() {
        FocusListener[] focusListenerArray = this.tree.getFocusListeners();
        for (int i = 0; i < focusListenerArray.length; ++i) {
            if (!focusListenerArray[i].getClass().getName().startsWith("org.openide")) continue;
            this.tree.removeFocusListener(focusListenerArray[i]);
        }
        MouseListener[] mouseListenerArray = this.tree.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (!mouseListenerArray[i].getClass().getName().startsWith("org.openide")) continue;
            this.tree.removeMouseListener(mouseListenerArray[i]);
        }
        this.renderer = new CheckedNodeRenderer(this.tree.getCellRenderer());
        this.tree.setCellRenderer(this.renderer);
        this.editor = new CheckedNodeEditor(this.tree);
        this.tree.setCellEditor(this.editor);
        this.tree.setEditable(true);
    }

    public void setEditable(boolean bl) {
        this.tree.setEditable(bl);
        this.tree.setBackground(UIManager.getDefaults().getColor(bl ? "Tree.background" : "TextField.inactiveBackground"));
    }

    public void setSrcRoot(FileObject fileObject) {
        this.root = fileObject;
    }

    private boolean acceptPath(String string) {
        return string != null && (string.length() == 0 || !this.filter.matcher(string).matches());
    }

    private synchronized Object updateState(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        if (!this.acceptPath(string)) {
            return null;
        }
        Object object = this.data.get(string);
        boolean bl = object == SELECTED || object == UNSELECTED;
        Enumeration enumeration = fileObject.getChildren(bl);
        while (enumeration.hasMoreElements()) {
            Object object2;
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (bl) {
                object2 = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject2);
                if (!this.acceptPath((String)object2)) continue;
                this.data.put((String)object2, object);
                continue;
            }
            object2 = this.updateState(fileObject2);
            if (object2 == null) continue;
            if (object == null) {
                object = object2;
                continue;
            }
            if (object == object2) continue;
            object = MIXED;
        }
        if (object == null) {
            object = SELECTED;
        }
        if (string.length() > 0) {
            this.data.put(string, object);
        }
        return object;
    }

    public Object getState(FileObject fileObject) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        if (!this.acceptPath(string)) {
            return null;
        }
        return this.data.get(string);
    }

    public synchronized void setState(FileObject fileObject, boolean bl) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        if (string == null) {
            return;
        }
        this.data.put(string, bl ? SELECTED : UNSELECTED);
        for (fileObject = fileObject.getParent(); fileObject != null && !this.root.equals(fileObject); fileObject = fileObject.getParent()) {
            this.data.remove(FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject));
        }
        this.updateState(this.root);
        if (this.properties != null && this.propertyName != null) {
            this.properties.put(this.propertyName, this.getExcludesRegex());
        }
    }

    public String getExcludesRegex() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addExcludes(this.root, stringBuffer);
        return stringBuffer.toString();
    }

    private void addExcludes(FileObject fileObject, StringBuffer stringBuffer) {
        String string = FileUtil.getRelativePath((FileObject)this.root, (FileObject)fileObject);
        if (!this.acceptPath(string)) {
            return;
        }
        Object object = this.data.get(string);
        if (string.length() > 0 && object == null || object == SELECTED) {
            return;
        }
        if (object == UNSELECTED) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
            if (fileObject.isFolder()) {
                stringBuffer.append(',').append(string).append("/**");
            }
        } else {
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                this.addExcludes((FileObject)enumeration.nextElement(), stringBuffer);
            }
        }
    }

    public synchronized void registerProperty(Map<String, Object> map, String string, Pattern pattern) {
        this.properties = map;
        this.propertyName = string;
        if (map == null || string == null) {
            return;
        }
        this.filter = pattern;
        this.data = new HashMap<String, Object>();
        String string2 = (String)map.get(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.indexOf(42) >= 0) continue;
                this.data.put(string3, UNSELECTED);
            }
        }
        this.updateState(this.root);
        this.renderer.setContentStorage(this);
        this.editor.setContentStorage(this);
    }
}

