/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserConfigurationTemplatesProvider
implements ProjectConfigurationFactory,
ProjectConfigurationFactory.CategoryDescriptor {
    public static final String PRIVATE_PREFIX = "private.";
    public static final String CFG_TEMPLATE_SUFFIX = NbBundle.getMessage(UserConfigurationTemplatesProvider.class, (String)"LBL_Cfg_TemplateSuffix");
    public static final String CFG_EXT = "cfg";
    public static final String CFG_TEMPLATES_PATH = "Templates/J2MEProjectConfigurations";

    public ProjectConfigurationFactory.CategoryDescriptor getRootCategory() {
        return this;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UserConfigurationTemplatesProvider.class, (String)"UserConfigurationTemplatesProvider");
    }

    public List<ProjectConfigurationFactory.Descriptor> getChildren() {
        ArrayList<ProjectConfigurationFactory.Descriptor> arrayList = new ArrayList<ProjectConfigurationFactory.Descriptor>();
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(CFG_TEMPLATES_PATH);
        if (fileObject != null) {
            for (final FileObject fileObject2 : fileObject.getChildren()) {
                if (!CFG_EXT.equals(fileObject2.getExt())) continue;
                arrayList.add((ProjectConfigurationFactory.Descriptor)new ProjectConfigurationFactory.ConfigurationTemplateDescriptor(){
                    Map<String, String> pcp;
                    Map<String, String> pgp;
                    Map<String, String> pp;
                    String name;
                    {
                        this.name = fileObject2.getName();
                        if (this.name.toLowerCase().endsWith(CFG_TEMPLATE_SUFFIX.toLowerCase())) {
                            this.name = this.name.substring(0, this.name.length() - CFG_TEMPLATE_SUFFIX.length());
                        }
                    }

                    public String getCfgName() {
                        return this.name;
                    }

                    public String getDisplayName() {
                        return this.name;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Map<String, String> getProjectConfigurationProperties() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.pcp == null) {
                                this.loadProperties();
                            }
                        }
                        return this.pcp;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Map<String, String> getProjectGlobalProperties() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.pgp == null) {
                                this.loadProperties();
                            }
                        }
                        return this.pgp;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Map<String, String> getPrivateProperties() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.pp == null) {
                                this.loadProperties();
                            }
                        }
                        return this.pp;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void loadProperties() {
                        Properties properties = new Properties();
                        InputStream inputStream = null;
                        this.pcp = new HashMap<String, String>();
                        this.pgp = new HashMap<String, String>();
                        this.pp = new HashMap<String, String>();
                        try {
                            inputStream = fileObject2.getInputStream();
                            properties.load(inputStream);
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify((Throwable)iOException);
                            return;
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        int n = UserConfigurationTemplatesProvider.PRIVATE_PREFIX.length();
                        String string = "configs." + fileObject2.getName() + '.';
                        int n2 = string.length();
                        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                            String string2 = (String)entry.getKey();
                            if (string2.startsWith(UserConfigurationTemplatesProvider.PRIVATE_PREFIX)) {
                                string2 = string2.substring(n);
                                this.pp.put(string2, (String)entry.getValue());
                                continue;
                            }
                            if (string2.startsWith(string)) {
                                string2 = string2.substring(n2);
                                this.pcp.put(string2, (String)entry.getValue());
                                continue;
                            }
                            this.pgp.put(string2, (String)entry.getValue());
                        }
                    }
                });
            }
        }
        return arrayList;
    }
}

