/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalAbilitiesCache
implements Runnable {
    private static GlobalAbilitiesCache instance = null;
    protected final Set<String> globalAbilities = Collections.synchronizedSortedSet(new TreeSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalAbilitiesCache getDefault() {
        Class<GlobalAbilitiesCache> clazz = GlobalAbilitiesCache.class;
        synchronized (GlobalAbilitiesCache.class) {
            if (instance == null) {
                instance = new GlobalAbilitiesCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private GlobalAbilitiesCache() {
        L l = new L();
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)l);
        l.propertyChange(null);
        RequestProcessor.getDefault().post((Runnable)this);
    }

    public Set<String> getAllAbilities() {
        return Collections.unmodifiableSet(this.globalAbilities);
    }

    public void addAbility(String string) {
        this.globalAbilities.add(string);
    }

    @Override
    public void run() {
        for (ProjectConfigurationFactory projectConfigurationFactory : Lookup.getDefault().lookupAll(ProjectConfigurationFactory.class)) {
            LinkedList<ProjectConfigurationFactory.CategoryDescriptor> linkedList = new LinkedList<ProjectConfigurationFactory.CategoryDescriptor>();
            linkedList.add(projectConfigurationFactory.getRootCategory());
            while (!linkedList.isEmpty()) {
                Map map;
                ProjectConfigurationFactory.Descriptor descriptor = (ProjectConfigurationFactory.Descriptor)linkedList.removeFirst();
                if (descriptor instanceof ProjectConfigurationFactory.CategoryDescriptor) {
                    linkedList.addAll(((ProjectConfigurationFactory.CategoryDescriptor)descriptor).getChildren());
                }
                if (!(descriptor instanceof ProjectConfigurationFactory.ConfigurationTemplateDescriptor) || (map = ((ProjectConfigurationFactory.ConfigurationTemplateDescriptor)descriptor).getProjectConfigurationProperties()) == null || (map = CommentingPreProcessor.decodeAbilitiesMap((String)((String)map.get("abilities")))) == null) continue;
                this.globalAbilities.addAll(map.keySet());
            }
        }
    }

    private class L
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private L() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            if (projectArray == null) {
                return;
            }
            for (int i = 0; i < projectArray.length; ++i) {
                ProjectConfigurationsHelper projectConfigurationsHelper = (ProjectConfigurationsHelper)projectArray[i].getLookup().lookup(ProjectConfigurationsHelper.class);
                if (projectConfigurationsHelper == null) continue;
                GlobalAbilitiesCache.this.globalAbilities.addAll(projectConfigurationsHelper.getAllIdentifiers(false));
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            this.loadAbilities(fileObject);
        }

        public void loadAbilities(FileObject fileObject) {
            if (fileObject == null || !fileObject.isData() || !fileObject.getExt().equals("cfg")) {
                return;
            }
            try {
                Properties properties = new Properties();
                properties.load(fileObject.getInputStream());
                Map map = CommentingPreProcessor.decodeAbilitiesMap((String)properties.getProperty("configs." + fileObject.getName() + '.' + "abilities"));
                if (map != null) {
                    GlobalAbilitiesCache.this.globalAbilities.addAll(map.keySet());
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }
}

