/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.IOException;
import java.util.HashMap;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class ApplicationDescriptorHandler {
    private static ApplicationDescriptorHandler handler;

    public static synchronized ApplicationDescriptorHandler getDefault() {
        if (handler == null) {
            handler = new ApplicationDescriptorHandler();
        }
        return handler;
    }

    private ApplicationDescriptorHandler() {
    }

    public void handleRename(FileObject fileObject, String string) {
        if (!this.isJava(fileObject)) {
            return;
        }
        Project project = this.findProject(fileObject);
        String string2 = this.calculateClassName(this.getSrcRoot(project), fileObject);
        if (string2 != null) {
            this.postChangeRequest(project, string2, string2.substring(0, string2.length() - fileObject.getName().length()) + string);
        }
    }

    public void handleMove(FileObject fileObject, FileObject fileObject2) {
        String string;
        if (!this.isJava(fileObject)) {
            return;
        }
        Project project = this.findProject(fileObject);
        FileObject fileObject3 = this.getSrcRoot(project);
        String string2 = this.calculateClassName(this.getSrcRoot(project), fileObject);
        if (string2 == null) {
            return;
        }
        String string3 = string = fileObject2 == null ? null : FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject2);
        if (string != null) {
            if (string.length() > 0) {
                string = string.replace('/', '.') + '.';
            }
            string = string + fileObject.getName();
        }
        this.postChangeRequest(project, string2, string);
    }

    public void handleDelete(FileObject fileObject) {
        if (!this.isJava(fileObject)) {
            return;
        }
        Project project = this.findProject(fileObject);
        String string = this.calculateClassName(this.getSrcRoot(project), fileObject);
        if (string != null) {
            this.postChangeRequest(project, string, null);
        }
    }

    private boolean isJava(FileObject fileObject) {
        return fileObject != null && fileObject.getExt().equals("java");
    }

    private Project findProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return project instanceof J2MEProject ? project : null;
    }

    private FileObject getSrcRoot(Project project) {
        if (project == null) {
            return null;
        }
        AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        if (antProjectHelper == null) {
            return null;
        }
        String string = antProjectHelper.getStandardPropertyEvaluator().getProperty("src.dir");
        return string == null ? null : antProjectHelper.resolveFileObject(string);
    }

    private String calculateClassName(FileObject fileObject, FileObject fileObject2) {
        String string;
        return fileObject == null || fileObject2 == null || (string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2)) == null ? null : string.substring(0, string.length() - 5).replace('/', '.');
    }

    private void postChangeRequest(final Project project, final String string, final String string2) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ApplicationDescriptorHandler.this.handleChangeRequest(project, string, string2);
            }
        });
    }

    protected void handleChangeRequest(Project project, String string, String string2) {
        AntProjectHelper antProjectHelper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        ProjectConfigurationsHelper projectConfigurationsHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        if (antProjectHelper == null || projectConfigurationsHelper == null) {
            return;
        }
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        ProjectConfiguration[] projectConfigurationArray = projectConfigurationsHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
        boolean bl = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < projectConfigurationArray.length; ++i) {
            HashMap hashMap2;
            boolean bl2 = false;
            String string3 = projectConfigurationsHelper.getDefaultConfiguration().equals(projectConfigurationArray[i]) ? "manifest.midlets" : "configs." + projectConfigurationArray[i].getDisplayName() + '.' + "manifest.midlets";
            String string4 = editableProperties.getProperty(string3);
            if (string4 == null || (hashMap2 = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(string4, null, null)) == null) continue;
            int n = 1;
            hashMap.clear();
            for (int j = 1; !hashMap2.isEmpty() && j < 10000; ++j) {
                String string5 = (String)hashMap2.remove("MIDlet-" + String.valueOf(j));
                if (string5 == null) continue;
                String[] stringArray = string5.split(",", -1);
                if (stringArray.length == 3 && stringArray[2].trim().equals(string)) {
                    bl2 = true;
                    if (string2 == null) continue;
                    hashMap.put("MIDlet-" + String.valueOf(n++), stringArray[0] + ',' + stringArray[1] + ',' + string2);
                    continue;
                }
                hashMap.put("MIDlet-" + String.valueOf(n++), string5);
            }
            if (!bl2) continue;
            editableProperties.setProperty(string3, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode(hashMap, null, null));
            bl = true;
        }
        if (bl) {
            try {
                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                ProjectManager.getDefault().saveProject(project);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }
}

