/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBConnectionDefinition;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.util.XMLCharUtil;
import org.netbeans.modules.jdbcwizard.builder.wsdl.GenerateWSDL;
import org.netbeans.modules.jdbcwizard.builder.xsd.XSDGenerator;
import org.netbeans.modules.jdbcwizard.wizards.JDBCWizardContext;
import org.netbeans.modules.jdbcwizard.wizards.JDBCWizardTablePanel;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JNDINamePanel
extends JPanel
implements WizardDescriptor.Panel {
    private static final long serialVersionUID = 1L;
    protected final Set listeners = new HashSet(1);
    private static final String XSD_EXT = ".xsd";
    private static final boolean enableNext = false;
    private static final String JNDI_DEFAULT_NAME = "jdbc/__defaultDS";
    private static final String CONNECTION_INFO_FILE = "config\\ConnectionInfo.xml";
    private JLabel jLabel1;
    private JTextField jTextField1;

    public JNDINamePanel(String string) {
        if (string != null && string.trim().length() != 0) {
            this.setName(string);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField1.setText(JNDI_DEFAULT_NAME);
        this.jLabel1.setText(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LBL_JNDI_NAME"));
        this.jLabel1.setHorizontalAlignment(4);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(55, 55, 55).add((Component)this.jLabel1, -2, 120, -2).add(28, 28, 28).add((Component)this.jTextField1, -2, 179, -2).addContainerGap(68, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(133, 133, 133).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextField1, -2, -1, -2)).addContainerGap(128, Short.MAX_VALUE)));
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(JNDINamePanel.class);
    }

    public void readSettings(Object object) {
        boolean bl;
        Object object2;
        WizardDescriptor wizardDescriptor = null;
        if (object instanceof JDBCWizardContext) {
            object2 = (JDBCWizardContext)object;
            wizardDescriptor = (WizardDescriptor)((JDBCWizardContext)object2).getProperty("wizDesc");
        } else if (object instanceof WizardDescriptor) {
            wizardDescriptor = (WizardDescriptor)object;
        }
        object2 = wizardDescriptor.getValue();
        boolean bl2 = bl = object2 == WizardDescriptor.NEXT_OPTION || object2 == WizardDescriptor.FINISH_OPTION;
        if (bl) {
            // empty if block
        }
    }

    public void storeSettings(Object object) {
        Object object2;
        WizardDescriptor wizardDescriptor = null;
        if (object instanceof JDBCWizardContext) {
            object2 = (JDBCWizardContext)object;
            wizardDescriptor = (WizardDescriptor)((JDBCWizardContext)object2).getProperty("wizDesc");
        } else if (object instanceof WizardDescriptor) {
            wizardDescriptor = (WizardDescriptor)object;
        }
        if (wizardDescriptor != null) {
            boolean bl;
            object2 = wizardDescriptor.getValue();
            if (NotifyDescriptor.CANCEL_OPTION == object2 || NotifyDescriptor.CLOSED_OPTION == object2) {
                return;
            }
            boolean bl2 = bl = object2 == WizardDescriptor.NEXT_OPTION || object2 == WizardDescriptor.FINISH_OPTION;
            if (bl) {
                Object[] objectArray = (Object[])wizardDescriptor.getProperty("selected_tables");
                List<Object> list = Arrays.asList(objectArray);
                String string = this.jTextField1.getText().trim();
                try {
                    Object object32;
                    XSDGenerator xSDGenerator = new XSDGenerator();
                    String string2 = (String)wizardDescriptor.getProperty("targetfolder_path");
                    String string3 = (String)wizardDescriptor.getProperty("collaboration_name");
                    Object object4 = null;
                    for (Object object32 : list) {
                        if (!object32.isSelected()) continue;
                        xSDGenerator.generate(object32.getName(), string2 + File.separator + XMLCharUtil.makeValidNCName(object32.getName()) + XSD_EXT, (DBTable)object32);
                        object4 = object32;
                    }
                    object32 = (String)wizardDescriptor.getProperty("db_type");
                    GenerateWSDL generateWSDL = new GenerateWSDL();
                    generateWSDL.setSrcDirectoryLocation(string2);
                    generateWSDL.setWSDLFileName(string3);
                    generateWSDL.setDBTable((DBTable)object4);
                    generateWSDL.setDBType((String)object32);
                    generateWSDL.setJNDIName(string);
                    generateWSDL.setDBInfo((DBConnectionDefinition)wizardDescriptor.getProperty("connection_info"));
                    generateWSDL.execute();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    public boolean isValid() {
        return super.isValid();
    }
}

