/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder.xsd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DBColumnImpl;
import org.netbeans.modules.jdbcwizard.builder.util.XMLCharUtil;
import org.netbeans.modules.jdbcwizard.builder.xsd.DOMWriter;
import org.netbeans.modules.jdbcwizard.builder.xsd.TypeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSDGenerator {
    private static final Logger mLogger = Logger.getLogger("JDBC" + XSDGenerator.class.getName());
    private static final String INDENT = "  ";
    private static final String XSD_PREFIX = "xsd:";
    private static final String XMLNS = "xmlns";
    private static final String NS_XSD = "xmlns:xsd";
    private static final String TARGET_NS = "targetNamespace";
    private static final String ELEMENT_FORM_DEFAULT = "elementFormDefault";
    private static final String XSD_SEQUENCE = "sequence";
    private static final String XSD_REF = "ref";
    private static final String XSD_ELEMENT = "element";
    private static final String XSD_COMPLEX_TYPE = "complexType";
    private static final String NAME_ATTR = "name";
    private static final String TYPE_ATTR = "type";
    private static final String MAX_OCCURS_ATTR = "maxOccurs";
    private static final String TARGETNAMESPACE = "http://j2ee.netbeans.org/xsd/tableSchema";
    private Document mDoc;
    private Element mRoot;
    private Element mCurrentNode;
    private String mFileName = "";
    private String mRepeatStructFileName = "";
    private DBTable ltbl = null;

    public void generate(String string, String string2, DBTable dBTable) throws Exception {
        this.mFileName = string2;
        if (this.mFileName != null && !this.mFileName.trim().equals("")) {
            File file = new File(this.mFileName);
            if (!file.getName().endsWith(".xsd") && !file.getName().endsWith(".XSD")) {
                throw new Exception("Found invalid XSD file name: " + file.getName() + ". Please make sure that the XSD file name has \".xsd\" suffix.");
            }
            String string3 = file.getName().substring(0, file.getName().lastIndexOf(".xsd")) + "_s.xsd";
            this.mRepeatStructFileName = file.getParent() + File.separator + string3;
        }
        this.ltbl = dBTable;
        this.generateSimpleXsd();
        this.resetElements();
    }

    public void generateSimpleXsd() throws Exception {
        Element element;
        this.generateXSDHeaders();
        this.mCurrentNode = element = this.addElementNode(XMLCharUtil.makeValidNCName(this.ltbl.getName()));
        this.createComplexTypesForTables(this.ltbl);
        this.serialize(this.mFileName);
    }

    public void generateRepeatXsd() throws Exception {
        this.generateXSDHeaders();
        String string = XMLCharUtil.makeValidNCName(this.ltbl.getName());
        String string2 = string + "List";
        Element element = this.addElementNode(string + "_List", string2);
        this.createComplexTypeRepeatElement(string2, string);
        this.createComplexTypesForTables(this.ltbl);
        this.serialize(this.mRepeatStructFileName);
    }

    private void generateXSDHeaders() throws Exception {
        this.createDocuments();
        this.mRoot = this.mDoc.createElement("xsd:schema");
        this.mRoot.setAttribute(NS_XSD, "http://www.w3.org/2001/XMLSchema");
        this.mRoot.setAttribute(TARGET_NS, TARGETNAMESPACE);
        this.mRoot.setAttribute(ELEMENT_FORM_DEFAULT, "qualified");
        this.mRoot.setAttribute(XMLNS, TARGETNAMESPACE);
        this.mDoc.appendChild(this.mRoot);
        this.mCurrentNode = this.mRoot;
    }

    private Element addElementNode(String string) {
        Element element = this.mDoc.createElement("xsd:element");
        element.setAttribute(NAME_ATTR, string);
        element.setAttribute(TYPE_ATTR, string);
        this.mCurrentNode.appendChild(element);
        return element;
    }

    private Element addElementNode(String string, String string2) {
        Element element = this.mDoc.createElement("xsd:element");
        element.setAttribute(NAME_ATTR, string);
        element.setAttribute(TYPE_ATTR, string2);
        this.mCurrentNode.appendChild(element);
        return element;
    }

    private void createComplexTypesForTables(DBTable dBTable) throws Exception {
        List list = dBTable.getColumnList();
        Element element = null;
        Element element2 = null;
        String string = XMLCharUtil.makeValidNCName(dBTable.getName());
        element = this.mDoc.createElement("xsd:complexType");
        element.setAttribute(NAME_ATTR, string);
        this.mRoot.appendChild(element);
        this.mCurrentNode = element;
        element2 = this.mDoc.createElement("xsd:element");
        element2.setAttribute(XSD_REF, "record");
        element2.setAttribute(MAX_OCCURS_ATTR, "unbounded");
        if (list.size() > 0) {
            element = this.mDoc.createElement("xsd:sequence");
            element.appendChild(element2);
            this.mCurrentNode.appendChild(element);
            this.mCurrentNode = element;
        }
        this.createColumnElements(list);
        this.mCurrentNode = this.mRoot;
    }

    private void createColumnElements(List list) throws Exception {
        Element element = null;
        Element element2 = this.mDoc.createElement("xsd:element");
        element2.setAttribute(NAME_ATTR, "record");
        Element element3 = this.mDoc.createElement("xsd:complexType");
        Element element4 = this.mDoc.createElement("xsd:sequence");
        for (int i = 0; i < list.size(); ++i) {
            DBColumn dBColumn = (DBColumn)list.get(i);
            DBColumnImpl dBColumnImpl = dBColumn instanceof DBColumnImpl ? (DBColumnImpl)dBColumn : new DBColumnImpl();
            dBColumnImpl.copyFrom(dBColumn);
            String string = dBColumnImpl.getJavaName();
            int n = dBColumnImpl.getJdbcType();
            String string2 = (String)TypeUtil.SQLTOJAVATYPES.get(TypeUtil.getSQLTypeDescription(n));
            if (!TypeUtil.isBuiltInType(string2)) {
                mLogger.severe("Encountered invalid data type of [" + string2 + "]");
            } else {
                string2 = (String)TypeUtil.builtInTypes.get(string2);
            }
            element = this.mDoc.createElement("xsd:element");
            element.setAttribute(NAME_ATTR, string);
            element.setAttribute(TYPE_ATTR, string2);
            element4.appendChild(element);
        }
        element3.appendChild(element4);
        element2.appendChild(element3);
        this.mRoot.appendChild(element2);
    }

    private void createComplexTypeRepeatElement(String string, String string2) {
        Element element = this.mDoc.createElement("xsd:complexType");
        element.setAttribute(NAME_ATTR, string);
        this.mRoot.appendChild(element);
        this.mCurrentNode = element;
        element = this.mDoc.createElement("xsd:sequence");
        element.setAttribute(MAX_OCCURS_ATTR, "unbounded");
        this.mCurrentNode.appendChild(element);
        this.mCurrentNode = element;
        element = this.mDoc.createElement("xsd:element");
        element.setAttribute(NAME_ATTR, string2);
        element.setAttribute(TYPE_ATTR, string2);
        this.mCurrentNode.appendChild(element);
    }

    private void resetElements() {
        this.mDoc = null;
        this.mRoot = null;
        this.mCurrentNode = null;
    }

    public void serialize(String string) throws Exception {
        try {
            File file = new File(this.mFileName);
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(string)));
            DOMWriter dOMWriter = new DOMWriter(printWriter, false);
            dOMWriter.print(INDENT, this.mDoc, true);
        }
        catch (Exception exception) {
            mLogger.severe("Failed to serialize XSD document: " + exception.getMessage());
            throw new Exception("Failed to serialize XSD document: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDocuments() throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory;
            DocumentBuilderFactory documentBuilderFactory2 = documentBuilderFactory = DocumentBuilderFactory.newInstance();
            synchronized (documentBuilderFactory2) {
                documentBuilderFactory.setNamespaceAware(true);
                this.mDoc = documentBuilderFactory.newDocumentBuilder().newDocument();
                if (this.mDoc == null) {
                    mLogger.severe("Failed to create Document object");
                    throw new Exception("Failed to create Document object.");
                }
            }
        }
        catch (Exception exception) {
            mLogger.severe("Failed to create XSD Document: " + exception.getMessage());
            throw new Exception("Failed to create XSD Document: " + exception.getMessage());
        }
    }
}

