/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.model.DBQueryModel;
import org.netbeans.modules.jdbcwizard.builder.util.XMLCharUtil;

public class OracleQueryGenerator
implements DBQueryModel {
    private String mtabName = null;
    private List mcolumns = null;
    private List mInsertColumns = null;
    private List mUpdateColumns = null;
    private List mChooseColumns = null;
    private List mPollColumns = null;
    private String mSchemaName = null;
    private static final Logger mLog = Logger.getLogger(OracleQueryGenerator.class.getName());
    private static final String INSERT_QUERY = "insertQuery";
    private static final String UPDATE_QUERY = "updateQuery";
    private static final OracleQueryGenerator instance = new OracleQueryGenerator();

    private OracleQueryGenerator() {
    }

    public static final OracleQueryGenerator getInstance() {
        if (instance != null) {
            return instance;
        }
        return new OracleQueryGenerator();
    }

    public void init(DBTable dBTable) {
        this.mtabName = dBTable.getName();
        this.mcolumns = dBTable.getColumnList();
        this.mInsertColumns = new ArrayList();
        this.mUpdateColumns = new ArrayList();
        this.mChooseColumns = new ArrayList();
        this.mPollColumns = new ArrayList();
        for (int i = 0; i < this.mcolumns.size(); ++i) {
            DBColumn dBColumn = (DBColumn)this.mcolumns.get(i);
            if (dBColumn.isInsertSelected()) {
                this.mInsertColumns.add(dBColumn);
            }
            if (dBColumn.isUpdateSelected()) {
                this.mUpdateColumns.add(dBColumn);
            }
            if (dBColumn.isChooseSelected()) {
                this.mChooseColumns.add(dBColumn);
            }
            if (!dBColumn.isPollSelected()) continue;
            this.mPollColumns.add(dBColumn);
        }
        this.mSchemaName = dBTable.getSchema();
    }

    public String createInsertQuery() throws Exception {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("insert into");
        stringBuffer.append(" ");
        stringBuffer.append(this.mtabName);
        stringBuffer.append(" ");
        stringBuffer.append("(");
        for (n = 0; n < this.mInsertColumns.size(); ++n) {
            stringBuffer.append(((DBColumn)this.mInsertColumns.get(n)).getName());
            if (n == this.mInsertColumns.size() - 1) {
                stringBuffer.append(")");
                continue;
            }
            stringBuffer.append(",");
        }
        stringBuffer.append(" ");
        stringBuffer.append("values (");
        for (n = 0; n < this.mInsertColumns.size(); ++n) {
            stringBuffer.append("?");
            if (n == this.mInsertColumns.size() - 1) {
                stringBuffer.append(")");
                continue;
            }
            stringBuffer.append(",");
        }
        mLog.log(Level.INFO, "Generated Insert Query " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public String createUpdateQuery() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("update");
        stringBuffer.append(" ");
        stringBuffer.append(this.mtabName);
        stringBuffer.append(" ");
        stringBuffer.append("set ");
        for (int i = 0; i < this.mUpdateColumns.size(); ++i) {
            stringBuffer.append(((DBColumn)this.mUpdateColumns.get(i)).getName());
            stringBuffer.append("  ");
            stringBuffer.append("=");
            stringBuffer.append(" ?");
            if (i == this.mUpdateColumns.size() - 1) continue;
            stringBuffer.append(",");
        }
        mLog.log(Level.INFO, "Generated Update Query " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public String createDeleteQuery() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete");
        stringBuffer.append(" ");
        stringBuffer.append("from");
        stringBuffer.append(" ");
        stringBuffer.append(this.mtabName);
        mLog.log(Level.INFO, "Generated Delete Query " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public String createFindQuery() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select");
        stringBuffer.append(" ");
        for (int i = 0; i < this.mChooseColumns.size(); ++i) {
            stringBuffer.append(((DBColumn)this.mChooseColumns.get(i)).getName());
            if (i == this.mChooseColumns.size() - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(",");
        }
        stringBuffer.append("from");
        stringBuffer.append(" ");
        stringBuffer.append(this.mtabName);
        mLog.log(Level.INFO, "Generated Find Query " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public String createPoolQuery() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select");
        stringBuffer.append(" ");
        for (int i = 0; i < this.mPollColumns.size(); ++i) {
            stringBuffer.append(((DBColumn)this.mPollColumns.get(i)).getName());
            if (i == this.mPollColumns.size() - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(",");
        }
        stringBuffer.append("from");
        stringBuffer.append(" ");
        stringBuffer.append(this.mtabName);
        mLog.log(Level.INFO, "Generated Pool Query " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public String getParamOrder(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        List list = null;
        if (INSERT_QUERY.equals(string)) {
            list = this.mInsertColumns;
        }
        if (UPDATE_QUERY.equals(string)) {
            list = this.mUpdateColumns;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string2 = XMLCharUtil.makeValidNCName(((DBColumn)list.get(i)).getName());
            stringBuffer.append(string2);
            if (i == list.size() - 1) {
                stringBuffer.append("");
                continue;
            }
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String getPrimaryKey() throws Exception {
        String string = null;
        for (DBColumn dBColumn : this.mcolumns) {
            if (!dBColumn.isPrimaryKey()) continue;
            string = dBColumn.getName();
            break;
        }
        return string;
    }
}

