/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder.dbmodel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.ForeignKey;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.PrimaryKey;
import org.openide.util.NbBundle;

public class PrimaryKeyImpl
implements PrimaryKey,
Cloneable {
    public static final PrimaryKeyImpl NULL = new PrimaryKeyImpl();
    public static final String ELEMENT_TAG = "primaryKey";
    public static final String NAME_ATTR = "name";
    public static final String COLUMNS_ATTR = "columns";
    private String name = null;
    private DBTable parent;
    private List columnNames = new ArrayList();

    private PrimaryKeyImpl() {
    }

    public PrimaryKeyImpl(String string, List list, boolean bl) {
        this();
        this.name = string;
        if (bl) {
            this.columnNames.addAll(list);
        } else {
            Collections.sort(list);
            for (Column column : list) {
                this.columnNames.add(column.getName());
            }
        }
    }

    public PrimaryKeyImpl(PrimaryKey primaryKey) {
        this();
        if (primaryKey == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle(PrimaryKeyImpl.class);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_NULL_PK") + "ERROR_NULL_PK");
        }
        this.copyFrom(primaryKey);
    }

    public String getName() {
        return this.name;
    }

    public List getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    public DBTable getParent() {
        return this.parent;
    }

    void setParent(DBTable dBTable) {
        this.parent = dBTable;
    }

    public boolean contains(String string) {
        return this.columnNames.contains(string);
    }

    public boolean contains(DBColumn dBColumn) {
        return this.contains(dBColumn.getName());
    }

    public Object clone() {
        try {
            PrimaryKeyImpl primaryKeyImpl = (PrimaryKeyImpl)super.clone();
            primaryKeyImpl.columnNames = new ArrayList(this.columnNames);
            return primaryKeyImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrimaryKeyImpl)) {
            return false;
        }
        PrimaryKeyImpl primaryKeyImpl = (PrimaryKeyImpl)object;
        boolean bl2 = this.name != null ? this.name.equals(primaryKeyImpl.name) : (bl = primaryKeyImpl.name == null);
        return bl &= this.columnNames != null ? ((Object)this.columnNames).equals(primaryKeyImpl.columnNames) : primaryKeyImpl.columnNames != null;
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        return n += this.columnNames != null ? ((Object)this.columnNames).hashCode() : 0;
    }

    public int getSequence(DBColumn dBColumn) {
        if (dBColumn == null || dBColumn.getName() == null) {
            return -1;
        }
        return this.getSequence(dBColumn.getName().trim());
    }

    public int getSequence(String string) {
        return this.columnNames.indexOf(string);
    }

    public void setColumnNames(String[] stringArray) {
        if (stringArray == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle(PrimaryKeyImpl.class);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_COL_NAMES") + "ERROR_COL_NAMES");
        }
        this.columnNames.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnNames.add(stringArray[i]);
        }
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public String getDBColumnName(int n) {
        return (String)this.columnNames.get(n);
    }

    public boolean isReferencedBy(ForeignKey foreignKey) {
        return foreignKey != null ? foreignKey.references(this) : false;
    }

    private void copyFrom(PrimaryKey primaryKey) {
        this.name = primaryKey.getName();
        this.parent = primaryKey.getParent();
        this.columnNames.clear();
        this.columnNames.addAll(primaryKey.getColumnNames());
    }

    public static class Column
    implements Comparable {
        private String name;
        private int sequence;

        public Column(String string, int n) {
            ResourceBundle resourceBundle = NbBundle.getBundle(PrimaryKeyImpl.class);
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_COL_NAME") + "ERROR_COL_NAME");
            }
            if (n <= 0) {
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_COL_SEQ") + "ERROR_COL_SEQ");
            }
            this.name = string;
            this.sequence = n;
        }

        public Column(DBColumn dBColumn, int n) {
            this(dBColumn.getName(), n);
        }

        public String getName() {
            return this.name;
        }

        public int getSequence() {
            return this.sequence;
        }

        public int compareTo(Object object) {
            return this.sequence - ((Column)object).sequence;
        }
    }
}

