/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder.dbmodel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBConnectionDefinition;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DatabaseModel;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DBConnectionDefinitionImpl;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DBTableImpl;
import org.openide.util.NbBundle;

public class DatabaseModelImpl
implements DatabaseModel,
Cloneable {
    private static final String LOG_CATEGORY = DatabaseModelImpl.class.getName();
    private static final String FQ_TBL_NAME_SEPARATOR = ".";
    protected volatile String name;
    protected volatile String description;
    protected SortedMap tables = new TreeMap();
    protected volatile String connectionName;
    protected DBConnectionDefinition connectionDefinition;

    private DatabaseModelImpl() {
    }

    public DatabaseModelImpl(String string, DBConnectionDefinition dBConnectionDefinition) {
        this();
        ResourceBundle resourceBundle = NbBundle.getBundle(DatabaseModelImpl.class);
        if (dBConnectionDefinition == null) {
            throw new IllegalArgumentException("connDef must be non-null");
        }
        String string2 = dBConnectionDefinition.getName();
        if (string2 == null || string2.trim().length() == 0) {
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_NAME_CONNDEF") + "(ERROR_NAME_CONNDEF)");
        }
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_NAME_MODEL") + "(ERROR_NAME_MODEL)");
        }
        this.name = string;
        this.connectionDefinition = dBConnectionDefinition;
    }

    public String getModelDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean addTable(DBTable dBTable) {
        if (dBTable != null) {
            this.tables.put(this.getFullyQualifiedTableName(dBTable), dBTable);
            return true;
        }
        return false;
    }

    public void copyFrom(DatabaseModel databaseModel) {
        if (databaseModel != null) {
            this.name = databaseModel.getModelName();
            this.description = databaseModel.getModelDescription();
            DBConnectionDefinition dBConnectionDefinition = databaseModel.getConnectionDefinition();
            this.connectionDefinition = dBConnectionDefinition instanceof DBConnectionDefinitionImpl ? dBConnectionDefinition : new DBConnectionDefinitionImpl(dBConnectionDefinition);
            this.tables.clear();
            List list = databaseModel.getTables();
            if (list != null) {
                for (DBTable dBTable : list) {
                    this.addTable(new DBTableImpl(dBTable));
                }
            }
        }
    }

    public DBTable createTable(String string, String string2, String string3) {
        DBTableImpl dBTableImpl = null;
        ResourceBundle resourceBundle = NbBundle.getBundle(DatabaseModelImpl.class);
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_TABLE_NAME") + "(ERROR_TABLE_NAME)");
        }
        dBTableImpl = new DBTableImpl(string, string2, string3);
        this.addTable(dBTableImpl);
        return dBTableImpl;
    }

    public boolean deleteAllTables() {
        this.tables.clear();
        return true;
    }

    public boolean deleteTable(String string) {
        if (string != null && string.trim().length() != 0) {
            this.tables.remove(string);
            return true;
        }
        return false;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getModelName() {
        return this.name;
    }

    public DBTable getTable(String string, String string2, String string3) {
        return this.getTable(this.getFullyQualifiedTableName(string, string2, string3));
    }

    public DBTable getTable(String string) {
        return (DBTable)this.tables.get(string);
    }

    public List getTables() {
        ArrayList arrayList = Collections.EMPTY_LIST;
        Collection collection = this.tables.values();
        if (collection.size() != 0) {
            arrayList = new ArrayList(collection.size());
            arrayList.addAll(collection);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Map getTableMap() {
        return Collections.unmodifiableMap(this.tables);
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object instanceof DatabaseModelImpl) {
            DatabaseModelImpl databaseModelImpl = (DatabaseModelImpl)object;
            boolean bl2 = databaseModelImpl.name != null ? databaseModelImpl.name.equals(this.name) : (bl = this.name == null);
            boolean bl3 = databaseModelImpl.connectionName != null ? databaseModelImpl.connectionName.equals(this.connectionName) : this.connectionName == null;
            bl &= bl3;
            bl3 = databaseModelImpl.connectionDefinition != null ? databaseModelImpl.connectionDefinition.equals(this.connectionDefinition) : this.connectionDefinition == null;
            bl &= bl3;
            if (this.tables != null && databaseModelImpl.tables != null) {
                Set set = databaseModelImpl.tables.keySet();
                Set set2 = this.tables.keySet();
                boolean bl4 = set2.containsAll(set) && set.containsAll(set2);
                bl &= bl4;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n += this.connectionName != null ? this.connectionName.hashCode() : 0;
        n += this.connectionDefinition != null ? this.connectionDefinition.hashCode() : 0;
        if (this.tables != null) {
            n += ((Object)this.tables.keySet()).hashCode();
        }
        return n;
    }

    public String toString() {
        return this.getModelName();
    }

    public Object clone() {
        try {
            DatabaseModelImpl databaseModelImpl = (DatabaseModelImpl)super.clone();
            databaseModelImpl.name = this.name;
            databaseModelImpl.description = this.description;
            databaseModelImpl.connectionName = databaseModelImpl.connectionName;
            databaseModelImpl.tables = new TreeMap();
            this.tables.putAll(this.tables);
            databaseModelImpl.connectionDefinition = new DBConnectionDefinitionImpl(this.connectionDefinition);
            return databaseModelImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public DBConnectionDefinition getConnectionDefinition() {
        return this.connectionDefinition;
    }

    public String getFullyQualifiedTableName(DBTable dBTable) {
        return dBTable != null ? this.getFullyQualifiedTableName(dBTable.getName(), dBTable.getSchema(), dBTable.getCatalog()) : "";
    }

    public String getFullyQualifiedTableName(String string, String string2, String string3) {
        if (string == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle(DatabaseModelImpl.class);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_NULL_TABLE_NAME") + "ERROR_NULL_TABLE_NAME");
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        if (string2 != null && string2.trim().length() != 0) {
            stringBuffer.append(string2.trim());
            stringBuffer.append(FQ_TBL_NAME_SEPARATOR);
        }
        stringBuffer.append(string.trim());
        return stringBuffer.toString();
    }
}

