/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder.dbmodel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DatabaseModel;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.ForeignKey;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.Index;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.PrimaryKey;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DBColumnImpl;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DatabaseModelImpl;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.ForeignKeyImpl;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.IndexImpl;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.PrimaryKeyImpl;
import org.openide.util.NbBundle;

public class DBTableImpl
implements DBTable,
Cloneable,
Comparable {
    private static final String LOG_CATEGORY = DBTableImpl.class.getName();
    protected String name;
    protected String description;
    protected String schema;
    protected String catalog;
    protected String type = null;
    protected DatabaseModel parent;
    protected Map columns;
    protected ArrayList columnsInTableOrder;
    protected PrimaryKeyImpl primaryKey;
    protected Map foreignKeys;
    protected Map indexes;
    protected String javaName;
    private final HashMap jdbcTypeMap = new HashMap();
    private final HashMap sqlTypeMap = new HashMap();
    protected boolean editable = true;
    protected boolean selected = false;

    private DBTableImpl() {
        this.columns = new HashMap();
        this.foreignKeys = new HashMap();
        this.indexes = new HashMap();
        this.columnsInTableOrder = new ArrayList();
        this.initJDBCTypeMap();
    }

    public DBTableImpl(String string, String string2, String string3) {
        this();
        this.name = string != null ? string.trim() : null;
        this.schema = string2 != null ? string2.trim() : null;
        this.catalog = string3 != null ? string3.trim() : null;
    }

    public DBTableImpl(String string, String string2, String string3, String string4) {
        this();
        this.name = string != null ? string.trim() : null;
        this.schema = string2 != null ? string2.trim() : null;
        this.catalog = string3 != null ? string3.trim() : null;
        this.type = string4 != null ? string4.trim() : null;
    }

    public DBTableImpl(DBTable dBTable) {
        this();
        if (dBTable == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle(DBTableImpl.class);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_NULL_DBTABLE") + "ERROR_NULL_DBTABLE");
        }
        this.copyFrom(dBTable);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getType() {
        return this.type;
    }

    public Map getColumns() {
        return this.columns;
    }

    public List getColumnList() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.columns.values());
        return arrayList;
    }

    public List getColumnListInTablelOrder() {
        return this.columnsInTableOrder;
    }

    public DatabaseModel getParent() {
        return this.parent;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public List getForeignKeys() {
        return new ArrayList(this.foreignKeys.values());
    }

    public ForeignKey getForeignKey(String string) {
        return (ForeignKey)this.foreignKeys.get(string);
    }

    public Set getReferencedTables() {
        Set<DBTable> set = Collections.EMPTY_SET;
        List list = this.getForeignKeys();
        if (list.size() != 0) {
            set = new HashSet(list.size());
            for (ForeignKeyImpl foreignKeyImpl : list) {
                DBTable dBTable = this.parent.getTable(foreignKeyImpl.getPKTable(), foreignKeyImpl.getPKSchema(), foreignKeyImpl.getPKCatalog());
                if (dBTable == null || !foreignKeyImpl.references(dBTable.getPrimaryKey())) continue;
                set.add(dBTable);
            }
            if (set.size() == 0) {
                set.clear();
                set = Collections.EMPTY_SET;
            }
        }
        return set;
    }

    public List getIndexes() {
        return new ArrayList(this.indexes.values());
    }

    public Index getIndex(String string) {
        return (Index)this.indexes.get(string);
    }

    public boolean references(DBTable dBTable) {
        return this.getReferenceFor(dBTable) != null;
    }

    public ForeignKey getReferenceFor(DBTable dBTable) {
        if (dBTable == null) {
            return null;
        }
        PrimaryKey primaryKey = dBTable.getPrimaryKey();
        if (primaryKey == null) {
            return null;
        }
        for (ForeignKey foreignKey : this.foreignKeys.values()) {
            if (!foreignKey.references(primaryKey)) continue;
            return foreignKey;
        }
        return null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean setPrimaryKey(PrimaryKeyImpl primaryKeyImpl) {
        if (primaryKeyImpl != null) {
            primaryKeyImpl.setParent(this);
        }
        this.primaryKey = primaryKeyImpl;
        return true;
    }

    public boolean addForeignKey(ForeignKeyImpl foreignKeyImpl) {
        if (foreignKeyImpl != null) {
            foreignKeyImpl.setParent(this);
            this.foreignKeys.put(foreignKeyImpl.getName(), foreignKeyImpl);
            return true;
        }
        return false;
    }

    public boolean removeForeignKey(ForeignKeyImpl foreignKeyImpl) {
        if (foreignKeyImpl != null) {
            return this.foreignKeys.remove(foreignKeyImpl.getName()) != null;
        }
        return false;
    }

    public void clearForeignKeys() {
        this.foreignKeys.clear();
    }

    public boolean addIndex(IndexImpl indexImpl) {
        if (indexImpl != null) {
            indexImpl.setParent(this);
            this.indexes.put(indexImpl.getName(), indexImpl);
            return true;
        }
        return false;
    }

    public void clearIndexes() {
        this.indexes.clear();
    }

    public int compareTo(Object object) {
        String string;
        if (object == null) {
            return -1;
        }
        if (object == this) {
            return 0;
        }
        String string2 = this.parent != null ? this.parent.getFullyQualifiedTableName((DBTable)object) : ((DBTable)object).getName();
        String string3 = string = this.parent != null ? this.parent.getFullyQualifiedTableName(this) : this.name;
        return string != null ? string.compareTo(string2) : (string2 != null ? 1 : -1);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            return true;
        }
        if (object instanceof DBTable) {
            Collection<Object> collection;
            DBTable dBTable = (DBTable)object;
            String string = dBTable.getName();
            DatabaseModel databaseModel = dBTable.getParent();
            Map map = dBTable.getColumns();
            PrimaryKey primaryKey = dBTable.getPrimaryKey();
            List list = dBTable.getForeignKeys();
            List list2 = dBTable.getForeignKeys();
            boolean bl2 = bl = string != null && this.name != null && this.name.equals(string) && this.parent != null && databaseModel != null && this.parent.equals(databaseModel);
            if (this.columns != null && map != null) {
                collection = map.keySet();
                Set set = this.columns.keySet();
                bl &= set.containsAll(collection) && collection.containsAll(set);
            } else if (this.columns != null || map != null) {
                bl = false;
            }
            bl &= this.primaryKey != null ? this.primaryKey.equals(primaryKey) : primaryKey == null;
            if (this.foreignKeys != null && list != null) {
                collection = this.foreignKeys.values();
                bl &= collection.containsAll(list) && list.containsAll(collection);
            } else if (this.foreignKeys != null || list != null) {
                bl = false;
            }
            if (this.indexes != null && list2 != null) {
                collection = this.indexes.values();
                bl &= collection.containsAll(list2) && list2.containsAll(collection);
            } else if (this.indexes != null || list2 != null) {
                bl = false;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n += this.parent != null ? this.parent.hashCode() : 0;
        n += this.schema != null ? this.schema.hashCode() : 0;
        n += this.catalog != null ? this.catalog.hashCode() : 0;
        if (this.columns != null) {
            n += ((Object)this.columns.keySet()).hashCode();
        }
        if (this.primaryKey != null) {
            n += this.primaryKey.hashCode();
        }
        if (this.foreignKeys != null) {
            n += ((Object)this.foreignKeys.keySet()).hashCode();
        }
        if (this.indexes != null) {
            n += ((Object)this.indexes.keySet()).hashCode();
        }
        return n;
    }

    public Object clone() {
        try {
            DBTableImpl dBTableImpl = (DBTableImpl)super.clone();
            dBTableImpl.columns = new HashMap();
            dBTableImpl.deepCopyReferences(this);
            return dBTableImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void copyFrom(DBTable dBTable) {
        if (dBTable == null) {
            throw new IllegalArgumentException("Must supply non-null ref for source");
        }
        if (dBTable == this) {
            return;
        }
        this.name = dBTable.getName();
        this.description = dBTable.getDescription();
        this.schema = dBTable.getSchema();
        this.catalog = dBTable.getCatalog();
        this.parent = dBTable.getParent();
        this.deepCopyReferences(dBTable);
    }

    private void deepCopyReferences(DBTable dBTable) {
        if (dBTable != null && dBTable != this) {
            Cloneable cloneable;
            this.primaryKey = null;
            PrimaryKey primaryKey = dBTable.getPrimaryKey();
            if (primaryKey != null) {
                this.primaryKey = new PrimaryKeyImpl(dBTable.getPrimaryKey());
            }
            this.foreignKeys.clear();
            Iterator iterator = dBTable.getForeignKeys().iterator();
            while (iterator.hasNext()) {
                cloneable = new ForeignKeyImpl((ForeignKey)iterator.next());
                ((ForeignKeyImpl)cloneable).setParent(this);
                this.foreignKeys.put(((ForeignKeyImpl)cloneable).getName(), cloneable);
            }
            this.indexes.clear();
            iterator = dBTable.getIndexes().iterator();
            while (iterator.hasNext()) {
                cloneable = new IndexImpl((Index)iterator.next());
                ((IndexImpl)cloneable).setParent(this);
                this.indexes.put(((IndexImpl)cloneable).getName(), cloneable);
            }
            this.columns.clear();
            iterator = dBTable.getColumnList().iterator();
            while (iterator.hasNext()) {
                cloneable = new DBColumnImpl();
                ((DBColumnImpl)cloneable).copyFrom((DBColumn)iterator.next());
                ((DBColumnImpl)cloneable).setParent(this);
                this.columns.put(((DBColumnImpl)cloneable).getName(), cloneable);
            }
        }
    }

    public boolean addColumn(DBColumn dBColumn) {
        if (dBColumn != null) {
            this.columns.put(dBColumn.getName(), dBColumn);
            return true;
        }
        return false;
    }

    public DBColumnImpl createColumn(String string, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        DBColumnImpl dBColumnImpl = new DBColumnImpl(string, n, n2, n3, bl, bl2, bl3, bl4);
        this.columns.put(string, dBColumnImpl);
        this.columnsInTableOrder.add(dBColumnImpl);
        return dBColumnImpl;
    }

    public boolean deleteAllColumns() {
        this.columns.clear();
        return false;
    }

    public boolean deleteColumn(String string) {
        if (string != null && string.trim().length() != 0) {
            return this.columns.remove(string) != null;
        }
        return false;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public DBColumn getColumn(String string) {
        return (DBColumn)this.columns.get(string);
    }

    public boolean setAllColumns(Map map) {
        this.columns.clear();
        if (map != null) {
            this.columns.putAll(map);
        }
        return true;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setParent(DatabaseModelImpl databaseModelImpl) {
        this.parent = databaseModelImpl;
    }

    public String getJavaName() {
        return this.javaName != null ? this.javaName : this.name;
    }

    public void setJavaName(String string) {
        this.javaName = string;
    }

    private void initJDBCTypeMap() {
        this.jdbcTypeMap.put("array", new Integer(2003));
        this.jdbcTypeMap.put("bigint", new Integer(-5));
        this.jdbcTypeMap.put("binary", new Integer(-2));
        this.jdbcTypeMap.put("bit", new Integer(-7));
        this.jdbcTypeMap.put("blob", new Integer(2004));
        this.jdbcTypeMap.put("char", new Integer(1));
        this.jdbcTypeMap.put("clob", new Integer(2005));
        this.jdbcTypeMap.put("date", new Integer(91));
        this.jdbcTypeMap.put("decimal", new Integer(3));
        this.jdbcTypeMap.put("distinct", new Integer(2001));
        this.jdbcTypeMap.put("double", new Integer(8));
        this.jdbcTypeMap.put("float", new Integer(6));
        this.jdbcTypeMap.put("integer", new Integer(4));
        this.jdbcTypeMap.put("longvarbinary", new Integer(-4));
        this.jdbcTypeMap.put("longvarchar", new Integer(-1));
        this.jdbcTypeMap.put("numeric", new Integer(2));
        this.jdbcTypeMap.put("real", new Integer(7));
        this.jdbcTypeMap.put("smallint", new Integer(5));
        this.jdbcTypeMap.put("time", new Integer(92));
        this.jdbcTypeMap.put("timestamp", new Integer(93));
        this.jdbcTypeMap.put("tinyint", new Integer(-6));
        this.jdbcTypeMap.put("varchar", new Integer(12));
        this.jdbcTypeMap.put("varbinary", new Integer(-3));
        this.sqlTypeMap.put(new Integer(2003), "array");
        this.sqlTypeMap.put(new Integer(-5), "bigint");
        this.sqlTypeMap.put(new Integer(-2), "binary");
        this.sqlTypeMap.put(new Integer(-7), "bit");
        this.sqlTypeMap.put(new Integer(2004), "blob");
        this.sqlTypeMap.put(new Integer(1), "char");
        this.sqlTypeMap.put(new Integer(2005), "clob");
        this.sqlTypeMap.put(new Integer(91), "date");
        this.sqlTypeMap.put(new Integer(3), "decimal");
        this.sqlTypeMap.put(new Integer(2001), "distinct");
        this.sqlTypeMap.put(new Integer(8), "double");
        this.sqlTypeMap.put(new Integer(6), "float");
        this.sqlTypeMap.put(new Integer(4), "integer");
        this.sqlTypeMap.put(new Integer(-4), "longvarbinary");
        this.sqlTypeMap.put(new Integer(-1), "longvarchar");
        this.sqlTypeMap.put(new Integer(2), "numeric");
        this.sqlTypeMap.put(new Integer(7), "real");
        this.sqlTypeMap.put(new Integer(5), "smallint");
        this.sqlTypeMap.put(new Integer(92), "time");
        this.sqlTypeMap.put(new Integer(93), "timestamp");
        this.sqlTypeMap.put(new Integer(-6), "tinyint");
        this.sqlTypeMap.put(new Integer(12), "varchar");
        this.sqlTypeMap.put(new Integer(-3), "varbinary");
    }

    public int getJDBCType(String string) {
        Integer n = (Integer)this.jdbcTypeMap.get(string);
        if (n != null) {
            return n;
        }
        return Integer.MIN_VALUE;
    }

    public String getSQLType(int n) {
        Integer n2 = new Integer(n);
        return (String)this.sqlTypeMap.get(n2);
    }

    public boolean isSelectedforAnOperation() {
        return false;
    }

    public void setSelectedforAllOperations(boolean bl) {
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                return ((String)object).compareTo((String)object2);
            }
            ResourceBundle resourceBundle = NbBundle.getBundle(DBTableImpl.class);
            throw new ClassCastException(resourceBundle.getString("ERROR_STRING_COMPARATOR") + "ERROR_STRING_COMPARATOR");
        }
    }
}

