/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.jdbcwizard.builder.ForeignKeyColumn;
import org.netbeans.modules.jdbcwizard.builder.IndexColumn;
import org.netbeans.modules.jdbcwizard.builder.KeyColumn;
import org.netbeans.modules.jdbcwizard.builder.TableColumn;
import org.openide.util.NbBundle;

public class Table {
    private String name = "";
    private String javaName = "";
    private String catalog = "";
    private String schema = "";
    private int numColumns = 0;
    private int numColumnsSelected = 0;
    private TableColumn[] columns;
    private String type = "TABLE";
    private List indexList;
    private List fkColumnList;
    private List pkColumnList;
    private boolean selected;

    public Table(String string, String string2, String string3, String string4) {
        this.name = string;
        this.catalog = string2;
        this.schema = string3;
        this.type = string4;
        this.indexList = Collections.EMPTY_LIST;
        this.fkColumnList = Collections.EMPTY_LIST;
        this.pkColumnList = Collections.EMPTY_LIST;
    }

    public Table(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.javaName = string2;
        this.catalog = string3;
        this.schema = string4;
        this.type = string5;
        this.indexList = Collections.EMPTY_LIST;
        this.fkColumnList = Collections.EMPTY_LIST;
        this.pkColumnList = Collections.EMPTY_LIST;
    }

    public Table(Table table) {
        this.name = table.getName();
        this.javaName = table.getJavaName();
        this.catalog = table.getCatalog();
        this.schema = table.getSchema();
        this.numColumns = table.getNumColumns();
        this.numColumnsSelected = table.getNumColumnsSelected();
        this.cloneColumns(table.getColumns());
        this.type = table.getType();
        this.cloneIndexList(table.getIndexList());
        this.cloneForeignKeyColumnList(table.getForeignKeyColumnList());
        this.clonePrimaryKeyColumnList(table.getPrimaryKeyColumnList());
        this.selected = table.isSelected();
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumColumnsSelected() {
        return this.numColumnsSelected;
    }

    public TableColumn[] getColumns() {
        return this.columns;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setJavaName(String string) {
        this.javaName = string;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public void setColumns(TableColumn[] tableColumnArray) {
        this.columns = tableColumnArray;
        if (this.columns != null) {
            this.numColumns = this.columns.length;
            int n = 0;
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columns[i].getIsSelected()) continue;
                ++n;
            }
            this.numColumnsSelected = n;
        } else {
            this.numColumns = 0;
            this.numColumnsSelected = 0;
        }
    }

    public void cloneColumns(TableColumn[] tableColumnArray) {
        this.numColumns = 0;
        this.numColumnsSelected = 0;
        int n = 0;
        if (tableColumnArray != null) {
            this.numColumns = tableColumnArray.length;
            if (this.numColumns > 0) {
                this.columns = new TableColumn[this.numColumns];
                for (int i = 0; i < this.numColumns; ++i) {
                    this.columns[i] = new TableColumn(tableColumnArray[i]);
                    if (!this.columns[i].getIsSelected()) continue;
                    ++n;
                }
            }
            this.numColumnsSelected = n;
        }
    }

    public void addColumn(TableColumn tableColumn) {
        if (null == tableColumn) {
            return;
        }
        int n = 0;
        if (null != this.columns) {
            n = this.columns.length;
        }
        TableColumn[] tableColumnArray = new TableColumn[n + 1];
        for (int i = 0; i < n; ++i) {
            tableColumnArray[i] = this.columns[i];
        }
        tableColumnArray[n] = tableColumn;
        this.setColumns(tableColumnArray);
    }

    public void removeColumn(int n) {
        if (null == this.columns || n > this.columns.length) {
            return;
        }
        int n2 = this.columns.length;
        TableColumn[] tableColumnArray = new TableColumn[n2 - 1];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            if (n3 == n) {
                --n4;
            } else {
                tableColumnArray[n4] = this.columns[n3];
            }
            ++n3;
            ++n4;
        }
        this.setColumns(tableColumnArray);
    }

    public void setType(String string) {
        this.type = string;
    }

    public List getIndexList() {
        return this.indexList;
    }

    public void setIndexList(List list) {
        if (list != null && list.size() != 0) {
            try {
                IndexColumn[] indexColumnArray = list.toArray(new IndexColumn[list.size()]);
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new IllegalArgumentException("newList does not contain Index objects!");
            }
            this.indexList = list;
        }
    }

    public void cloneIndexList(List list) {
        this.indexList = Collections.EMPTY_LIST;
        if (list != null && list.size() != 0) {
            this.indexList = new ArrayList();
            try {
                IndexColumn[] indexColumnArray = list.toArray(new IndexColumn[list.size()]);
                for (int i = 0; i < list.size(); ++i) {
                    IndexColumn indexColumn = (IndexColumn)list.get(i);
                    this.indexList.add(new IndexColumn(indexColumn));
                }
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new IllegalArgumentException("newList does not contain Index objects!");
            }
        }
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public List getPrimaryKeyColumnList() {
        return this.pkColumnList;
    }

    public void setPrimaryKeyColumnList(List list) {
        if (list != null && list.size() != 0) {
            try {
                KeyColumn[] keyColumnArray = list.toArray(new KeyColumn[list.size()]);
            }
            catch (ArrayStoreException arrayStoreException) {
                ResourceBundle resourceBundle = NbBundle.getBundle(Table.class);
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_KEY") + "(ERROR_KEY)");
            }
            this.pkColumnList = list;
        }
    }

    public void clonePrimaryKeyColumnList(List list) {
        this.pkColumnList = Collections.EMPTY_LIST;
        if (list != null && list.size() != 0) {
            this.pkColumnList = new ArrayList();
            try {
                KeyColumn[] keyColumnArray = list.toArray(new KeyColumn[list.size()]);
                for (int i = 0; i < list.size(); ++i) {
                    KeyColumn keyColumn = (KeyColumn)list.get(i);
                    this.pkColumnList.add(new KeyColumn(keyColumn.getName(), keyColumn.getColumnName(), keyColumn.getColumnSequence()));
                }
            }
            catch (ArrayStoreException arrayStoreException) {
                ResourceBundle resourceBundle = NbBundle.getBundle(Table.class);
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_KEY") + "(ERROR_KEY)");
            }
        }
    }

    public List getForeignKeyColumnList() {
        return this.fkColumnList;
    }

    public void setForeignKeyColumnList(List list) {
        if (list != null && list.size() != 0) {
            try {
                ForeignKeyColumn[] foreignKeyColumnArray = list.toArray(new ForeignKeyColumn[list.size()]);
            }
            catch (ArrayStoreException arrayStoreException) {
                ResourceBundle resourceBundle = NbBundle.getBundle(Table.class);
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_FK_KEY") + "(ERROR_FK_KEY)");
            }
            this.fkColumnList = list;
        }
    }

    public void cloneForeignKeyColumnList(List list) {
        this.fkColumnList = Collections.EMPTY_LIST;
        if (list != null && list.size() != 0) {
            this.fkColumnList = new ArrayList();
            try {
                ForeignKeyColumn[] foreignKeyColumnArray = list.toArray(new ForeignKeyColumn[list.size()]);
                for (int i = 0; i < list.size(); ++i) {
                    ForeignKeyColumn foreignKeyColumn = (ForeignKeyColumn)list.get(i);
                    this.fkColumnList.add(new ForeignKeyColumn(foreignKeyColumn));
                }
            }
            catch (ArrayStoreException arrayStoreException) {
                ResourceBundle resourceBundle = NbBundle.getBundle(Table.class);
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_FK_KEY") + "(ERROR_FK_KEY)");
            }
        }
    }
}

