/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SignalFacade;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SunSignalFacade
implements SignalFacade {
    public IRubyObject trap(final IRubyObject recv, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        SignalHandler oldHandler;
        final JRubySignalHandler handler = new JRubySignalHandler();
        handler.runtime = recv.getRuntime();
        handler.block = arg1;
        handler.signal_object = arg2;
        handler.signal = arg3.toString();
        try {
            oldHandler = Signal.handle(new Signal(handler.signal), handler);
        }
        catch (Exception e) {
            throw recv.getRuntime().newArgumentError(e.getMessage());
        }
        if (oldHandler instanceof JRubySignalHandler) {
            return ((JRubySignalHandler)oldHandler).block;
        }
        return RubyProc.newProc(recv.getRuntime(), CallBlock.newCallClosure(recv, (RubyModule)recv, Arity.noArguments(), new BlockCallback(){

            public IRubyObject call(ThreadContext context, IRubyObject[] args, Block block) {
                oldHandler.handle(new Signal(handler.signal));
                return recv.getRuntime().getNil();
            }
        }, recv.getRuntime().getCurrentContext()), Block.Type.NORMAL);
    }

    private static final class JRubySignalHandler
    implements SignalHandler {
        public Ruby runtime;
        public IRubyObject block;
        public IRubyObject signal_object;
        public String signal;

        private JRubySignalHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handle(Signal signal) {
            try {
                try {
                    this.block.callMethod(this.runtime.getCurrentContext(), "call", new IRubyObject[0]);
                }
                catch (RaiseException e) {
                    try {
                        this.runtime.getThread().callMethod(this.runtime.getCurrentContext(), "main", new IRubyObject[0]).callMethod(this.runtime.getCurrentContext(), "raise", new IRubyObject[]{e.getException()});
                    }
                    catch (Exception exception) {
                    }
                    Object var5_3 = null;
                    Signal.handle(new Signal(this.signal), this);
                    return;
                }
                Object var5_2 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                Signal.handle(new Signal(this.signal), this);
                throw throwable;
            }
            Signal.handle(new Signal(this.signal), this);
        }
    }
}

