/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class MethodBlock
extends BlockBody {
    private final RubyMethod method;
    private final Callback callback;
    private final Arity arity;
    private final StaticScope staticScope;

    public static Block createMethodBlock(ThreadContext context, DynamicScope dynamicScope, Callback callback, RubyMethod method, IRubyObject self) {
        Binding binding = new Binding(self, context.getCurrentFrame().duplicate(), context.getCurrentFrame().getVisibility(), context.getRubyClass(), dynamicScope);
        MethodBlock body = new MethodBlock(callback, method, dynamicScope.getStaticScope());
        return new Block(body, binding);
    }

    public MethodBlock(Callback callback, RubyMethod method, StaticScope staticScope) {
        super(3);
        this.callback = callback;
        this.method = method;
        this.arity = Arity.createArity((int)method.arity().getLongValue());
        this.staticScope = staticScope;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args, Binding binding, Block.Type type) {
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true, binding, type);
    }

    protected void pre(ThreadContext context, RubyModule klass, Binding binding) {
        context.preYieldNoScope(binding, klass);
    }

    protected void post(ThreadContext context, Binding binding) {
        context.postYieldNoScope();
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value, Binding binding, Block.Type type) {
        return this.yield(context, value, null, null, false, binding, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue, Binding binding, Block.Type type) {
        if (klass == null) {
            self = binding.getSelf();
            binding.getFrame().setSelf(self);
        }
        this.pre(context, klass, binding);
        try {
            try {
                IRubyObject iRubyObject;
                while (true) {
                    try {
                        iRubyObject = this.callback.execute(value, new IRubyObject[]{this.method, self}, Block.NULL_BLOCK);
                    }
                    catch (JumpException.RedoJump rj) {
                        context.pollThreadEvents();
                        continue;
                    }
                    catch (JumpException.BreakJump bj) {
                        if (bj.getTarget() != null) throw bj;
                        bj.setTarget(this);
                        throw bj;
                    }
                    break;
                }
                Object var11_12 = null;
                this.post(context, binding);
                return iRubyObject;
            }
            catch (JumpException.NextJump nj) {
                IRubyObject iRubyObject = (IRubyObject)nj.getValue();
                Object var11_13 = null;
                this.post(context, binding);
                return iRubyObject;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.post(context, binding);
            throw throwable;
        }
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope().cloneScope());
        return new Block(this, binding);
    }

    public Arity arity() {
        return this.arity;
    }
}

