/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.executable.RubiniusCMethod;
import org.jruby.ast.executable.RubiniusMachine;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubiniusMethod
extends DynamicMethod
implements JumpTarget {
    private RubiniusCMethod cmethod;
    private StaticScope staticScope;
    private Arity arity;

    public RubiniusMethod(RubyModule implementationClass, RubiniusCMethod cmethod, StaticScope staticScope, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.staticScope = staticScope;
        this.cmethod = cmethod;
        this.arity = Arity.optional();
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, Block block) {
        IRubyObject iRubyObject;
        assert (args != null);
        Ruby runtime = context.getRuntime();
        this.callConfig.pre(context, self, klazz, this.getArity(), name, args, block, this.staticScope, this);
        try {
            if (runtime.hasEventHooks()) {
                this.traceCall(context, runtime, name);
            }
            iRubyObject = RubiniusMachine.INSTANCE.exec(context, self, this.cmethod.code, this.cmethod.literals, args);
            Object var11_10 = null;
        }
        catch (JumpException.ReturnJump rj) {
            block10: {
                try {
                    if (rj.getTarget() != this) break block10;
                    IRubyObject iRubyObject2 = (IRubyObject)rj.getValue();
                    Object var11_11 = null;
                    if (runtime.hasEventHooks()) {
                        this.traceReturn(context, runtime, name);
                    }
                    this.callConfig.post(context);
                    return iRubyObject2;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (runtime.hasEventHooks()) {
                        this.traceReturn(context, runtime, name);
                    }
                    this.callConfig.post(context);
                    throw throwable;
                }
            }
            throw rj;
        }
        if (runtime.hasEventHooks()) {
            this.traceReturn(context, runtime, name);
        }
        this.callConfig.post(context);
        return iRubyObject;
    }

    private void traceReturn(ThreadContext context, Ruby runtime, String name) {
        if (!runtime.hasEventHooks()) {
            return;
        }
        Frame frame = context.getPreviousFrame();
        runtime.callEventHooks(context, 4, frame.getFile(), frame.getLine(), name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, String name) {
        if (!runtime.hasEventHooks()) {
            return;
        }
        runtime.callEventHooks(context, 3, context.getFile(), context.getLine(), name, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.arity;
    }

    public DynamicMethod dup() {
        return new RubiniusMethod(this.getImplementationClass(), this.cmethod, this.staticScope, this.getVisibility());
    }
}

