/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import jruby.objectweb.asm.Label;
import org.jruby.RubyModule;
import org.jruby.compiler.ArgumentsCallback;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class StandardInvocationCompiler
implements InvocationCompiler {
    private StandardASMCompiler.AbstractMethodCompiler methodCompiler;
    private SkinnyMethodAdapter method;
    private static final int THIS = 0;

    public StandardInvocationCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method) {
        this.methodCompiler = methodCompiler;
        this.method = method;
    }

    public SkinnyMethodAdapter getMethodAdapter() {
        return this.method;
    }

    public void setMethodAdapter(SkinnyMethodAdapter sma) {
        this.method = sma;
    }

    public void invokeAttrAssign(String name) {
        this.method.dup();
        this.method.dup();
        this.method.arraylength();
        this.method.iconst_1();
        this.method.isub();
        this.method.arrayload();
        this.method.dup_x2();
        this.method.pop();
        this.invokeDynamic(name, true, true, CallType.NORMAL, null, true);
        this.method.pop();
    }

    public void invokeAttrAssign(String name, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        Label variableCallType = new Label();
        Label readyForCall = new Label();
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadSelf();
        this.method.if_acmpeq(variableCallType);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, name, CallType.NORMAL);
        this.method.go_to(readyForCall);
        this.method.label(variableCallType);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, name, CallType.VARIABLE);
        this.method.label(readyForCall);
        this.method.swap();
        this.methodCompiler.loadThreadContext();
        this.method.swap();
        String signature = null;
        switch (argsCallback.getArity()) {
            case 1: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 2: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        argsCallback.call(this.methodCompiler);
        int tempLocal = this.methodCompiler.variableCompiler.grabTempLocal();
        switch (argsCallback.getArity()) {
            case 1: 
            case 2: 
            case 3: {
                this.method.dup();
                break;
            }
            default: {
                this.method.dup();
                this.method.dup();
                this.method.arraylength();
                this.method.iconst_1();
                this.method.isub();
                this.method.arrayload();
            }
        }
        this.methodCompiler.variableCompiler.setTempLocal(tempLocal);
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", signature);
        this.method.pop();
        this.methodCompiler.variableCompiler.getTempLocal(tempLocal);
        this.methodCompiler.variableCompiler.releaseTempLocal();
    }

    public void opElementAsgn(CompilerCallback valueCallback, String operator) {
        this.methodCompiler.method.dup2();
        this.invokeDynamic("[]", true, true, CallType.FUNCTIONAL, null, false);
        this.methodCompiler.method.dup();
        Label end = new Label();
        if (operator == "||") {
            Label falseResult = new Label();
            this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE));
            this.methodCompiler.method.ifeq(falseResult);
            this.methodCompiler.method.dup_x2();
            this.methodCompiler.method.pop();
            this.methodCompiler.method.pop2();
            this.methodCompiler.method.go_to(end);
            this.methodCompiler.method.label(falseResult);
            this.methodCompiler.method.pop();
            valueCallback.call(this.methodCompiler);
            this.methodCompiler.method.dup_x2();
            this.methodCompiler.appendToObjectArray();
            this.invokeDynamic("[]=", true, true, CallType.FUNCTIONAL, null, false);
            this.methodCompiler.method.pop();
            this.methodCompiler.method.label(end);
        } else if (operator == "&&") {
            Label falseResult = new Label();
            this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE));
            this.methodCompiler.method.ifeq(falseResult);
            this.methodCompiler.method.pop();
            valueCallback.call(this.methodCompiler);
            this.methodCompiler.appendToObjectArray();
            this.invokeDynamic("[]=", true, true, CallType.FUNCTIONAL, null, false);
            this.methodCompiler.method.go_to(end);
            this.methodCompiler.method.label(falseResult);
            this.methodCompiler.method.dup_x2();
            this.methodCompiler.method.pop();
            this.methodCompiler.method.pop2();
            this.methodCompiler.method.label(end);
        } else {
            this.methodCompiler.method.pop();
            valueCallback.call(this.methodCompiler);
            this.methodCompiler.createObjectArray(1);
            this.invokeDynamic(operator, true, true, CallType.FUNCTIONAL, null, false);
            this.methodCompiler.appendToObjectArray();
            this.invokeDynamic("[]=", true, true, CallType.FUNCTIONAL, null, false);
        }
    }

    public void opElementAsgnWithOr(CompilerCallback receiver, ArgumentsCallback args, CompilerCallback valueCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.loadThreadContext();
        receiver.call(this.methodCompiler);
        args.call(this.methodCompiler);
        this.method.dup2();
        int argsLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(argsLocal);
        int receiverLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(receiverLocal);
        switch (args.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE));
        Label done = new Label();
        this.method.ifne(done);
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getVariableCompiler().getTempLocal(receiverLocal);
        this.methodCompiler.getVariableCompiler().getTempLocal(argsLocal);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, "[]=", CallType.FUNCTIONAL);
        switch (args.getArity()) {
            case 0: {
                throw new NotCompilableException("Op Element Asgn with zero-arity args");
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoOneArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoTwoArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoThreeArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoNArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
            }
        }
        this.method.label(done);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void opElementAsgnWithAnd(CompilerCallback receiver, ArgumentsCallback args, CompilerCallback valueCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.loadThreadContext();
        receiver.call(this.methodCompiler);
        args.call(this.methodCompiler);
        this.method.dup2();
        int argsLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(argsLocal);
        int receiverLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(receiverLocal);
        switch (args.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE));
        Label done = new Label();
        this.method.ifeq(done);
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getVariableCompiler().getTempLocal(receiverLocal);
        this.methodCompiler.getVariableCompiler().getTempLocal(argsLocal);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, "[]=", CallType.FUNCTIONAL);
        switch (args.getArity()) {
            case 0: {
                throw new NotCompilableException("Op Element Asgn with zero-arity args");
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoOneArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoTwoArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoThreeArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoNArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
            }
        }
        this.method.label(done);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void opElementAsgnWithMethod(CompilerCallback receiver, ArgumentsCallback args, CompilerCallback valueCallback, String operator) {
        this.methodCompiler.loadThreadContext();
        receiver.call(this.methodCompiler);
        args.call(this.methodCompiler);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, operator, CallType.NORMAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, "[]=", CallType.FUNCTIONAL);
        switch (args.getArity()) {
            case 0: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
            }
        }
    }

    public void invokeSuper(CompilerCallback argsCallback, CompilerCallback closureArg) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeUtilityMethod("checkSuperDisabled", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
        this.methodCompiler.loadSelf();
        this.methodCompiler.loadThreadContext();
        if (argsCallback == null) {
            this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            if (closureArg == null) {
                this.methodCompiler.loadBlock();
            } else {
                closureArg.call(this.methodCompiler);
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                this.methodCompiler.loadBlock();
            } else {
                closureArg.call(this.methodCompiler);
            }
        }
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "callSuper", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Block.class));
    }

    public void invokeDynamic(String name, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg) {
        String signature;
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, name, callType);
        this.methodCompiler.loadThreadContext();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        if (argsCallback == null) {
            if (closureArg == null) {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class));
            } else {
                closureArg.call(this.methodCompiler);
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Block.class));
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class));
                        break;
                    }
                }
            } else {
                closureArg.call(this.methodCompiler);
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
                    }
                }
            }
        }
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", signature);
    }

    public void invokeOpAsgnWithOr(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.invokeUtilityMethod("preOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class));
        Label done = new Label();
        Label isTrue = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE));
        this.method.ifne(isTrue);
        this.method.pop();
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("postOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class));
        this.method.go_to(done);
        this.method.label(isTrue);
        this.method.swap();
        this.method.pop();
        this.method.label(done);
    }

    public void invokeOpAsgnWithAnd(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.invokeUtilityMethod("preOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class));
        Label done = new Label();
        Label isFalse = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE));
        this.method.ifeq(isFalse);
        this.method.pop();
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("postOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, CallSite.class));
        this.method.go_to(done);
        this.method.label(isFalse);
        this.method.swap();
        this.method.pop();
        this.method.label(done);
    }

    public void invokeOpAsgnWithMethod(String operatorName, String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        this.methodCompiler.loadThreadContext();
        receiverCallback.call(this.methodCompiler);
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, operatorName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("opAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
    }

    public void invokeOpElementAsgnWithMethod(String operatorName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        this.methodCompiler.loadThreadContext();
        receiverCallback.call(this.methodCompiler);
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, operatorName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, "[]=", CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
    }

    private void invokeDynamic(String name, boolean hasReceiver, boolean hasArgs, CallType callType, CompilerCallback closureArg, boolean attrAssign) {
        String callSig = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class, IRubyObject[].class, ThreadContext.class, String.class, IRubyObject.class, CallType.class, Block.class));
        String callSigIndexed = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class, IRubyObject[].class, ThreadContext.class, Byte.TYPE, String.class, IRubyObject.class, CallType.class, Block.class));
        int index = MethodIndex.getIndex(name);
        if (hasArgs) {
            if (!hasReceiver) {
                this.methodCompiler.loadSelf();
                this.method.swap();
            }
        } else if (hasReceiver) {
            this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        } else {
            this.methodCompiler.loadSelf();
            this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
        }
        this.methodCompiler.loadThreadContext();
        if (index != 0) {
            this.method.ldc(new Integer(index));
        }
        this.method.ldc(name);
        this.methodCompiler.loadSelf();
        this.method.getstatic(CodegenUtils.p(CallType.class), callType.toString(), CodegenUtils.ci(CallType.class));
        if (closureArg == null) {
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        } else {
            closureArg.call(this.methodCompiler);
        }
        Label tryBegin = new Label();
        Label tryEnd = new Label();
        Label tryCatch = new Label();
        if (closureArg != null) {
            this.method.label(tryBegin);
        }
        if (attrAssign) {
            if (index != 0) {
                this.methodCompiler.invokeUtilityMethod("doAttrAssignIndexed", callSigIndexed);
            } else {
                this.methodCompiler.invokeUtilityMethod("doAttrAssign", callSig);
            }
        } else if (index != 0) {
            this.methodCompiler.invokeUtilityMethod("doInvokeDynamicIndexed", callSigIndexed);
        } else {
            this.methodCompiler.invokeUtilityMethod("doInvokeDynamic", callSig);
        }
        if (closureArg != null) {
            this.method.label(tryEnd);
            Label normalEnd = new Label();
            this.method.go_to(normalEnd);
            this.method.label(tryCatch);
            this.methodCompiler.loadBlock();
            this.methodCompiler.invokeUtilityMethod("handleJumpException", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(JumpException.class, Block.class)));
            this.method.label(normalEnd);
        }
    }

    public void yield(boolean hasArgs, boolean unwrap) {
        this.methodCompiler.loadBlock();
        if (hasArgs) {
            this.method.swap();
            this.methodCompiler.loadThreadContext();
            this.method.swap();
        } else {
            this.methodCompiler.loadThreadContext();
            this.method.aconst_null();
        }
        this.method.aconst_null();
        this.method.aconst_null();
        this.method.ldc(new Boolean(unwrap));
        this.method.invokevirtual(CodegenUtils.p(Block.class), "yield", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyModule.class, Boolean.TYPE)));
    }

    public void invokeEqq() {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.method, "===", CallType.NORMAL);
        this.method.dup_x2();
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.method.dup_x2();
        this.method.pop();
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", signature);
    }
}

