/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLFileSystem
extends AbstractFileSystem {
    private static final long serialVersionUID = 28974107313702326L;
    private static final Map<String, String> DTD_MAP = new HashMap<String, String>();
    private URL[] urlsToXml = new URL[0];
    private transient FileObjRef<? extends FileObject> rootRef;

    public XMLFileSystem() {
        Impl impl = new Impl(this);
        this.list = impl;
        this.info = impl;
        this.change = impl;
        this.attr = impl;
    }

    public XMLFileSystem(String string) throws SAXException {
        this();
        if (string == null) {
            throw new NullPointerException("Null uri");
        }
        try {
            this.setXmlUrl(new URL(string));
        }
        catch (Exception exception) {
            throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(exception.getMessage()), exception);
        }
    }

    public XMLFileSystem(URL uRL) throws SAXException {
        this();
        if (uRL == null) {
            throw new NullPointerException("Null url");
        }
        try {
            this.setXmlUrl(uRL);
        }
        catch (Exception exception) {
            throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(exception.getMessage()), exception);
        }
    }

    @Deprecated
    public XMLFileSystem(FileSystemCapability fileSystemCapability) {
        this();
        this.setCapability(fileSystemCapability);
    }

    public URL getXmlUrl() {
        return this.urlsToXml.length > 0 ? this.urlsToXml[0] : null;
    }

    public synchronized void setXmlUrl(URL uRL) throws IOException, PropertyVetoException {
        this.setXmlUrl(uRL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXmlUrl(URL uRL, boolean bl) throws IOException, PropertyVetoException {
        try {
            this.beginAtomicAction();
            XMLFileSystem xMLFileSystem = this;
            synchronized (xMLFileSystem) {
                this.setXmlUrls(new URL[]{uRL}, bl);
            }
        }
        finally {
            this.finishAtomicAction();
        }
    }

    public URL[] getXmlUrls() {
        return this.urlsToXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXmlUrls(URL[] uRLArray) throws IOException, PropertyVetoException {
        try {
            this.beginAtomicAction();
            XMLFileSystem xMLFileSystem = this;
            synchronized (xMLFileSystem) {
                this.setXmlUrls(uRLArray, false);
            }
        }
        finally {
            this.finishAtomicAction();
        }
    }

    private void _setSystemName(String string) throws PropertyVetoException {
        this.setSystemName(string);
    }

    private synchronized void setXmlUrls(URL[] uRLArray, boolean bl) throws IOException, PropertyVetoException {
        if (uRLArray == null || Arrays.asList(uRLArray).contains(null)) {
            throw new NullPointerException("Null URL list or member");
        }
        String string = this.getDisplayName();
        if (uRLArray.length == 0) {
            this.urlsToXml = new URL[0];
            ResourceElem resourceElem = new ResourceElem(true, uRLArray, null);
            this.refreshChildrenInAtomicAction((AbstractFolder)this.getRoot(), resourceElem);
            resourceElem = null;
            return;
        }
        ResourceElem resourceElem = new ResourceElem(true, uRLArray, null);
        Handler handler = new Handler(DTD_MAP, resourceElem, bl);
        URL[] uRLArray2 = this.urlsToXml;
        this.urlsToXml = new URL[uRLArray.length];
        try {
            this._setSystemName("XML_" + uRLArray[0].toExternalForm().replace('/', '-'));
        }
        catch (PropertyVetoException propertyVetoException) {
            this.urlsToXml = uRLArray2;
            resourceElem = null;
            throw propertyVetoException;
        }
        URL uRL = null;
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)bl, (boolean)false);
            xMLReader.setEntityResolver(handler);
            xMLReader.setContentHandler(handler);
            xMLReader.setErrorHandler(handler);
            for (int i = 0; i < uRLArray.length; ++i) {
                this.urlsToXml[i] = uRL = uRLArray[i];
                handler.urlContext = uRL;
                String string2 = uRL.toExternalForm();
                xMLReader.parse(string2);
            }
            this.refreshChildrenInAtomicAction((AbstractFolder)this.getRoot(), resourceElem);
        }
        catch (IOException iOException) {
            this.urlsToXml = uRLArray2;
            Exceptions.attachMessage((Throwable)iOException, (String)Arrays.toString(uRLArray));
            throw iOException;
        }
        catch (Exception exception) {
            throw (IOException)new IOException(uRL + ": " + exception.toString()).initCause(exception);
        }
        finally {
            resourceElem = null;
        }
        this.firePropertyChange("displayName", string, this.getDisplayName());
    }

    @Override
    boolean isLastModifiedCacheEnabled() {
        return false;
    }

    private boolean isFolder(String string) {
        Reference<? extends FileObject> reference = this.findReference(string);
        if (reference != null && reference instanceof FileObjRef) {
            return ((FileObjRef)reference).isFolder();
        }
        return false;
    }

    private InputStream getInputStream(String string) throws FileNotFoundException {
        Reference<? extends FileObject> reference = this.findReference(string);
        if (reference != null && reference instanceof FileObjRef) {
            return ((FileObjRef)reference).getInputStream(string);
        }
        throw new FileNotFoundException(NbBundle.getMessage(XMLFileSystem.class, (String)"EXC_CanntRead", (Object)string));
    }

    URL getURL(String string) throws FileNotFoundException {
        Reference<? extends FileObject> reference = this.findReference(string);
        if (reference != null && reference instanceof FileObjRef) {
            return ((FileObjRef)reference).createAbsoluteUrl(string);
        }
        throw new FileNotFoundException(NbBundle.getMessage(XMLFileSystem.class, (String)"EXC_CanntRead", (Object)string));
    }

    private long getSize(String string) {
        Reference<? extends FileObject> reference = this.findReference(string);
        if (reference != null && reference instanceof FileObjRef) {
            return ((FileObjRef)reference).getSize(string);
        }
        return 0L;
    }

    private Date lastModified(String string) {
        Reference<? extends FileObject> reference = this.findReference(string);
        if (reference != null && reference instanceof FileObjRef) {
            return ((FileObjRef)reference).lastModified(string);
        }
        return new Date(0L);
    }

    @Override
    public String getDisplayName() {
        if (this.urlsToXml.length == 0 || this.urlsToXml[0] == null || this.urlsToXml[0].toExternalForm().length() == 0) {
            return NbBundle.getMessage(XMLFileSystem.class, (String)"XML_NotValidXMLFileSystem");
        }
        return "XML:" + this.urlsToXml[0].toExternalForm().trim();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        URL[] uRLArray = (URL[])getField.get("urlsToXml", null);
        if (uRLArray == null) {
            uRLArray = new URL[]{(URL)getField.get("uriId", null)};
        }
        try {
            if (this.urlsToXml.length != 1) {
                this.setXmlUrls(this.urlsToXml);
            } else {
                this.setXmlUrl(this.urlsToXml[0]);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            IOException iOException = new IOException(propertyVetoException.getMessage());
            ExternalUtil.copyAnnotation(iOException, propertyVetoException);
            throw iOException;
        }
    }

    @Override
    public void addNotify() {
    }

    @Override
    public void removeNotify() {
    }

    @Override
    protected <T extends FileObject> Reference<T> createReference(T t) {
        return new FileObjRef<T>(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshChildrenInAtomicAction(AbstractFolder abstractFolder, ResourceElem resourceElem) {
        try {
            this.beginAtomicAction();
            HashSet<AbstractFolder> hashSet = new HashSet<AbstractFolder>(Collections.list(abstractFolder.existingSubFiles(true)));
            this.refreshChildren(abstractFolder, resourceElem);
            ArrayList<AbstractFolder> arrayList = Collections.list(abstractFolder.existingSubFiles(true));
            hashSet.removeAll(arrayList);
            for (AbstractFileObject abstractFileObject : hashSet) {
                if (!abstractFileObject.validFlag) continue;
                abstractFileObject.validFlag = false;
                abstractFileObject.fileDeleted0(new FileEvent(abstractFileObject));
            }
        }
        finally {
            this.finishAtomicAction();
        }
    }

    private void refreshChildren(AbstractFolder abstractFolder, ResourceElem resourceElem) {
        int n;
        if (abstractFolder.isRoot()) {
            this.rootRef = new FileObjRef<AbstractFolder>(abstractFolder);
            this.initializeReference(this.rootRef, resourceElem);
        }
        List<String> list = resourceElem.getChildren();
        String[] stringArray = new String[list.size()];
        ResourceElem[] resourceElemArray = new ResourceElem[stringArray.length];
        list.toArray(stringArray);
        for (n = 0; n < stringArray.length; ++n) {
            resourceElemArray[n] = resourceElem.getChild(stringArray[n]);
        }
        abstractFolder.refresh(null, null, true, true, stringArray);
        for (n = 0; n < resourceElemArray.length; ++n) {
            AbstractFolder abstractFolder2 = (AbstractFolder)abstractFolder.getFileObject(stringArray[n]);
            FileObjRef fileObjRef = (FileObjRef)this.findReference(abstractFolder2.getPath());
            int n2 = this.initializeReference(fileObjRef, resourceElemArray[n]);
            abstractFolder2.lastModified();
            if (abstractFolder2.isFolder()) {
                this.refreshChildren(abstractFolder2, resourceElemArray[n]);
                continue;
            }
            if ((n2 & 1) != 0) {
                abstractFolder2.fileChanged0(new FileEvent(abstractFolder2));
                continue;
            }
            if ((n2 & 2) == 0) continue;
            abstractFolder2.fileAttributeChanged0(new FileAttributeEvent(abstractFolder2, null, null, null));
        }
    }

    private int initializeReference(FileObjRef fileObjRef, ResourceElem resourceElem) {
        if (!fileObjRef.isInitialized()) {
            fileObjRef.initialize(resourceElem);
            return 0;
        }
        boolean bl = fileObjRef.attacheAttrs(resourceElem.getAttr(false));
        fileObjRef.setUrlContext(resourceElem.getUrlContext());
        boolean bl2 = false;
        if (resourceElem.getContent() != null) {
            bl2 = !(fileObjRef.content instanceof byte[]) || !Arrays.equals((byte[])fileObjRef.content, resourceElem.getContent());
            fileObjRef.content = resourceElem.getContent();
        } else if (resourceElem.getURI() != null) {
            bl2 = !resourceElem.getURI().equals(fileObjRef.content);
            fileObjRef.content = resourceElem.getURI();
        }
        return (bl2 ? 1 : 0) + (bl ? 2 : 0);
    }

    static {
        DTD_MAP.put("-//NetBeans//DTD Filesystem 1.0//EN", "org/openide/filesystems/filesystem.dtd");
        DTD_MAP.put("-//NetBeans//DTD Filesystem 1.1//EN", "org/openide/filesystems/filesystem1_1.dtd");
    }

    static class Handler
    extends DefaultHandler {
        private static final int FOLDER_CODE = "folder".hashCode();
        private static final int FILE_CODE = "file".hashCode();
        private static final int ATTR_CODE = "attr".hashCode();
        private ResourceElem rootElem;
        private boolean validate = false;
        Stack<ResourceElem> resElemStack = new Stack();
        Stack<String> elementStack = new Stack();
        URL urlContext;
        private Map dtdMap;
        private ResourceElem topRE;
        private StringBuffer pcdata = new StringBuffer();

        Handler(Map map, ResourceElem resourceElem, boolean bl) {
            this.dtdMap = map;
            this.rootElem = resourceElem;
            this.validate = bl;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            int n = string3.hashCode();
            this.elementStack.push(string3);
            String string4 = attributes.getValue("name");
            if (n == FOLDER_CODE) {
                if (string4 == null) {
                    throw new SAXException(NbBundle.getMessage(XMLFileSystem.class, (String)"XML_MisssingAttr"));
                }
                ResourceElem resourceElem = new ResourceElem(true, this.urlContext, null);
                this.topRE = this.topRE.addChild(string4, resourceElem);
                this.resElemStack.push(this.topRE);
                return;
            }
            if (n == FILE_CODE) {
                if (string4 == null) {
                    throw new SAXException(NbBundle.getMessage(XMLFileSystem.class, (String)"XML_MisssingAttr"));
                }
                string4 = string4.intern();
                String string5 = null;
                if (attributes.getLength() > 1) {
                    string5 = attributes.getValue("url");
                }
                ResourceElem resourceElem = new ResourceElem(false, this.urlContext, string5);
                this.topRE = this.topRE.addChild(string4, resourceElem);
                this.resElemStack.push(this.topRE);
                this.pcdata.setLength(0);
                return;
            }
            if (n == ATTR_CODE) {
                if (string4 == null) {
                    throw new SAXException(NbBundle.getMessage(XMLFileSystem.class, (String)"XML_MisssingAttr"));
                }
                int n2 = attributes.getLength();
                for (int i = 0; i < n2; ++i) {
                    String string6 = attributes.getQName(i);
                    String string7 = attributes.getValue(i);
                    if (XMLMapAttr.Attr.isValid(string6) == -1) continue;
                    XMLMapAttr.Attr attr = XMLMapAttr.createAttributeAndDecode(string6, string7);
                    XMLMapAttr xMLMapAttr = this.topRE.getAttr(true);
                    Object object = xMLMapAttr.put(string4, attr);
                    if (object == null) continue;
                    xMLMapAttr.put(string4, object);
                }
                return;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.elementStack.peek().hashCode() == FILE_CODE && !this.topRE.isFolder()) {
                String string4 = this.pcdata.toString().trim();
                if (string4.length() > 0) {
                    this.topRE.setContent(string4.getBytes());
                }
                this.pcdata.setLength(0);
            }
            int n = string3.hashCode();
            this.elementStack.pop();
            if (n == FOLDER_CODE || n == FILE_CODE) {
                this.resElemStack.pop();
                this.topRE = this.resElemStack.peek();
                return;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.elementStack.peek().hashCode() != FILE_CODE) {
                return;
            }
            if (this.topRE.isFolder()) {
                return;
            }
            this.pcdata.append(new String(cArray, n, n2));
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            String string3 = (String)this.dtdMap.get(string);
            if (string3 != null) {
                if (this.validate) {
                    string3 = this.getClass().getClassLoader().getResource(string3).toExternalForm();
                    return new InputSource(string3);
                }
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return new InputSource(string2);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.resElemStack = new Stack();
            this.resElemStack.push(this.rootElem);
            this.topRE = this.rootElem;
            this.elementStack = new Stack();
            this.elementStack.push("<root>");
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            this.resElemStack.pop();
            this.elementStack.pop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileObjRef<T extends FileObject>
    extends WeakReference<T> {
        private T fo;
        private Object content;
        private XMLMapAttr foAttrs;
        byte isFolder = (byte)-1;
        Object urlContext = null;
        private static final Set<String> NETWORK_PROTOCOLS = new HashSet<String>(Arrays.asList("http", "https", "ftp"));

        public FileObjRef(T t) {
            super(t);
            this.fo = t;
        }

        public boolean isInitialized() {
            return this.isFolder != -1;
        }

        public void initialize(ResourceElem resourceElem) {
            this.content = resourceElem.getContent();
            XMLMapAttr xMLMapAttr = resourceElem.getAttr(false);
            if (xMLMapAttr != null && !xMLMapAttr.isEmpty()) {
                this.foAttrs = xMLMapAttr;
            }
            this.isFolder = (byte)(resourceElem.isFolder() ? 1 : 0);
            if (this.content == null) {
                this.content = resourceElem.getURI();
            }
            this.setUrlContext(resourceElem.getUrlContext());
        }

        public boolean isFolder() {
            return this.isFolder == 1;
        }

        public boolean attacheAttrs(XMLMapAttr xMLMapAttr) {
            if (xMLMapAttr == null || xMLMapAttr.isEmpty()) {
                return false;
            }
            if (this.foAttrs == null) {
                this.foAttrs = new XMLMapAttr();
            }
            Iterator iterator = xMLMapAttr.entrySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object object = this.foAttrs.put(entry.getKey(), entry.getValue());
                bl |= object == null && entry.getValue() != null || !object.equals(entry.getValue());
            }
            return bl;
        }

        public void setUrlContext(URL[] uRLArray) {
            if (uRLArray.length > 0) {
                this.urlContext = uRLArray.length > 1 ? uRLArray : uRLArray[0];
            }
        }

        public Enumeration<String> attributes() {
            if (this.foAttrs == null) {
                return Enumerations.empty();
            }
            HashSet<String> hashSet = new HashSet<String>(this.foAttrs.keySet());
            return Collections.enumeration(hashSet);
        }

        private URL[] getLayers() {
            if (this.urlContext == null) {
                return null;
            }
            if (this.urlContext instanceof URL[]) {
                return (URL[])this.urlContext;
            }
            return new URL[]{(URL)this.urlContext};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object readAttribute(String string) {
            if (string.equals("layers")) {
                return this.getLayers();
            }
            if (this.foAttrs == null) {
                return null;
            }
            FileObject fileObject = MultiFileObject.attrAskedFileObject.get();
            FileObject fileObject2 = fileObject == null ? this.fo : fileObject;
            MultiFileObject.attrAskedFileObject.set(null);
            try {
                Object[] objectArray = new Object[]{fileObject2, string};
                Object object = this.foAttrs.get(string, objectArray);
                return object;
            }
            finally {
                MultiFileObject.attrAskedFileObject.set(fileObject);
            }
        }

        public InputStream getInputStream(String string) throws FileNotFoundException {
            InputStream inputStream = null;
            if (this.content == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (this.content instanceof String) {
                URL uRL = this.createAbsoluteUrl(string);
                try {
                    inputStream = uRL.openStream();
                }
                catch (IOException iOException) {
                    FileNotFoundException fileNotFoundException = new FileNotFoundException(string);
                    ExternalUtil.copyAnnotation(fileNotFoundException, iOException);
                    throw fileNotFoundException;
                }
            }
            if (this.content instanceof byte[]) {
                inputStream = new ByteArrayInputStream((byte[])this.content);
            }
            if (inputStream == null) {
                throw new FileNotFoundException(string);
            }
            return inputStream;
        }

        private URL createAbsoluteUrl(String string) throws FileNotFoundException {
            if (!(this.content instanceof String)) {
                return null;
            }
            String string2 = (String)this.content;
            try {
                URL[] uRLArray = this.getLayers();
                URL uRL = uRLArray == null || uRLArray.length == 0 ? new URL(string2) : new URL(uRLArray[0], string2);
                return uRL;
            }
            catch (IOException iOException) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException(string);
                ExternalUtil.copyAnnotation(fileNotFoundException, iOException);
                throw fileNotFoundException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getSize(String string) {
            if (this.content == null) {
                return 0L;
            }
            if (this.content instanceof byte[]) {
                return ((byte[])this.content).length;
            }
            if (this.content instanceof String) {
                long l;
                URL uRL = this.createAbsoluteUrl(string);
                URLConnection uRLConnection = uRL.openConnection();
                try {
                    l = uRLConnection.getContentLength();
                }
                catch (Throwable throwable) {
                    try {
                        uRLConnection.getInputStream().close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                uRLConnection.getInputStream().close();
                return l;
            }
            return 0L;
        }

        public Date lastModified(String string) {
            Object object;
            URL uRL = null;
            Date date = null;
            if (this.content == null || !(this.content instanceof String)) {
                object = this.getLayers();
                uRL = object != null && ((URL[])object).length > 0 ? object[0] : null;
            } else {
                try {
                    uRL = this.createAbsoluteUrl(string);
                }
                catch (IOException iOException) {
                    uRL = null;
                }
            }
            if (uRL != null) {
                Serializable serializable;
                object = uRL.getProtocol();
                if ("jar".equals(object)) {
                    serializable = FileUtil.getArchiveFile(uRL);
                    uRL = serializable != null ? serializable : uRL;
                    object = uRL.getProtocol();
                }
                if ("file".equals(object)) {
                    try {
                        serializable = new File(URI.create(uRL.toExternalForm()));
                        date = ((File)serializable).exists() ? new Date(((File)serializable).lastModified()) : null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logger.getLogger(XMLFileSystem.class.getName()).log(Level.FINE, "#121777: " + uRL, illegalArgumentException);
                    }
                } else if (!NETWORK_PROTOCOLS.contains(object)) {
                    date = this.timeFromDateHeaderField(uRL);
                }
            }
            if (date == null) {
                date = new Date(0L);
            }
            return date;
        }

        private static String getLocalResource(URL uRL) {
            if (uRL == null) {
                return null;
            }
            if (uRL.getProtocol().equals("jar")) {
                URL uRL2 = null;
                try {
                    uRL2 = new URL(uRL.getFile());
                    if (uRL2.getProtocol().equals("file")) {
                        return uRL2.getFile();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            if (uRL.getProtocol().equals("file")) {
                return uRL.getFile();
            }
            return null;
        }

        private static File getFileFromResourceString(String string) {
            if (string == null) {
                return null;
            }
            int n = string.indexOf(33);
            String string2 = n != -1 ? string.substring(0, n) : string;
            File file = new File(string2);
            if (file.exists()) {
                return file;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Date timeFromDateHeaderField(URL uRL) {
            Date date;
            URLConnection uRLConnection = uRL.openConnection();
            try {
                date = new Date(uRLConnection.getLastModified());
            }
            catch (Throwable throwable) {
                try {
                    uRLConnection.getInputStream().close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    return new Date(0L);
                }
            }
            uRLConnection.getInputStream().close();
            return date;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change,
    AbstractFileSystem.Attr {
        private static final long serialVersionUID = -67233358102597232L;
        private XMLFileSystem fs;

        public Impl(XMLFileSystem xMLFileSystem) {
            this.fs = xMLFileSystem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] children(String string) {
            FileObject fileObject = this.fs.findResource(string);
            if (fileObject == null) {
                return new String[0];
            }
            FileObject fileObject2 = fileObject;
            synchronized (fileObject2) {
                return ((AbstractFolder)fileObject).getChildrenArray();
            }
        }

        @Override
        public void createFolder(String string) throws IOException {
            throw new IOException();
        }

        @Override
        public void createData(String string) throws IOException {
            throw new IOException();
        }

        @Override
        public void rename(String string, String string2) throws IOException {
            throw new IOException();
        }

        @Override
        public void delete(String string) throws IOException {
            throw new IOException();
        }

        @Override
        public Date lastModified(String string) {
            return this.fs.lastModified(string);
        }

        @Override
        public boolean folder(String string) {
            return this.fs.isFolder(string);
        }

        @Override
        public boolean readOnly(String string) {
            return true;
        }

        @Override
        public String mimeType(String string) {
            return null;
        }

        @Override
        public long size(String string) {
            if (this.fs.isFolder(string)) {
                return 0L;
            }
            return this.fs.getSize(string);
        }

        @Override
        public InputStream inputStream(String string) throws FileNotFoundException {
            InputStream inputStream = this.fs.getInputStream(string);
            if (inputStream == null) {
                throw new FileNotFoundException(string);
            }
            return inputStream;
        }

        @Override
        public OutputStream outputStream(String string) throws IOException {
            throw new IOException();
        }

        @Override
        public void lock(String string) throws IOException {
            FSException.io("EXC_CannotLock", string, this.fs.getDisplayName(), string);
        }

        @Override
        public void unlock(String string) {
        }

        @Override
        public void markUnimportant(String string) {
        }

        @Override
        public Object readAttribute(String string, String string2) {
            FileObjRef fileObjRef = (FileObjRef)this.fs.findReference(string);
            if (fileObjRef == null && string.length() == 0 && this.fs.rootRef != null) {
                fileObjRef = this.fs.rootRef;
            }
            if (fileObjRef == null) {
                return null;
            }
            return fileObjRef.readAttribute(string2);
        }

        @Override
        public void writeAttribute(String string, String string2, Object object) throws IOException {
            throw new IOException();
        }

        @Override
        public Enumeration<String> attributes(String string) {
            FileObjRef fileObjRef = (FileObjRef)this.fs.findReference(string);
            if (fileObjRef == null && string.length() == 0 && this.fs.rootRef != null) {
                fileObjRef = this.fs.rootRef;
            }
            if (fileObjRef == null) {
                return Enumerations.empty();
            }
            return fileObjRef.attributes();
        }

        @Override
        public void renameAttributes(String string, String string2) {
        }

        @Override
        public void deleteAttributes(String string) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceElem {
        private List<ResourceElem> children;
        private List<String> names;
        private byte[] content;
        private List<URL> urlContext = new ArrayList<URL>();
        private XMLMapAttr foAttrs;
        private boolean isFolder;
        private String uri;

        public ResourceElem(boolean bl, URL[] uRLArray, String string) {
            this.isFolder = bl;
            this.uri = string;
            this.urlContext.addAll(Arrays.asList(uRLArray));
            if (bl) {
                this.children = new ArrayList<ResourceElem>();
                this.names = new ArrayList<String>();
            }
        }

        public ResourceElem(boolean bl, URL uRL, String string) {
            this.isFolder = bl;
            this.uri = string;
            this.urlContext.add(uRL);
            if (bl) {
                this.children = new ArrayList<ResourceElem>();
                this.names = new ArrayList<String>();
            }
        }

        ResourceElem addChild(String string, ResourceElem resourceElem) {
            if (!this.isFolder) {
                throw new IllegalArgumentException("not a folder");
            }
            assert (string != null && string.indexOf("/") == -1) : (resourceElem.isFolder ? "<folder name=" : "<file name=") + string + " ...";
            ResourceElem resourceElem2 = resourceElem;
            int n = this.names.indexOf(string);
            if (n == -1) {
                this.names.add(string);
                this.children.add(resourceElem);
            } else {
                resourceElem2 = this.children.get(n);
            }
            return resourceElem2;
        }

        List<String> getChildren() {
            return this.names;
        }

        ResourceElem getChild(String string) {
            return this.children.get(this.names.indexOf(string));
        }

        XMLMapAttr getAttr(boolean bl) {
            if (bl && this.foAttrs == null) {
                this.foAttrs = new XMLMapAttr();
            }
            return this.foAttrs;
        }

        byte[] getContent() {
            return this.content;
        }

        URL[] getUrlContext() {
            URL[] uRLArray = new URL[this.urlContext.size()];
            this.urlContext.toArray(uRLArray);
            return uRLArray;
        }

        String getURI() {
            return this.uri;
        }

        void setContent(byte[] byArray) {
            if (this.content == null) {
                byte[] byArray2 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                this.content = byArray2;
            }
        }

        boolean isFolder() {
            return this.isFolder;
        }
    }
}

