/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public class JWSProjectProperties {
    public static final String JNLP_ENABLED = "jnlp.enabled";
    public static final String JNLP_ICON = "jnlp.icon";
    public static final String JNLP_OFFLINE = "jnlp.offline-allowed";
    public static final String JNLP_CBASE_TYPE = "jnlp.codebase.type";
    public static final String JNLP_CBASE_USER = "jnlp.codebase.user";
    public static final String JNLP_CBASE_URL = "jnlp.codebase.url";
    public static final String JNLP_SPEC = "jnlp.spec";
    public static final String JNLP_INIT_HEAP = "jnlp.initial-heap-size";
    public static final String JNLP_MAX_HEAP = "jnlp.max-heap-size";
    public static final String JNLP_SIGNED = "jnlp.signed";
    public static final String CB_TYPE_LOCAL = "local";
    public static final String CB_TYPE_WEB = "web";
    public static final String CB_TYPE_USER = "user";
    public static final String CB_URL_WEB = "$$codebase";
    public static final String CB_URL_WEB_PROP_VALUE = "$$$$codebase";
    private StoreGroup jnlpPropGroup = new StoreGroup();
    private J2SEPropertyEvaluator j2sePropEval;
    private PropertyEvaluator evaluator;
    private Project j2seProject;
    JToggleButton.ToggleButtonModel enabledModel;
    JToggleButton.ToggleButtonModel allowOfflineModel;
    JToggleButton.ToggleButtonModel signedModel;
    ComboBoxModel codebaseModel;
    Document iconDocument;
    Document codebaseURLDocument;

    public JWSProjectProperties(Lookup lookup) {
        this.j2seProject = (Project)lookup.lookup(Project.class);
        if (this.j2seProject != null) {
            this.j2sePropEval = (J2SEPropertyEvaluator)this.j2seProject.getLookup().lookup(J2SEPropertyEvaluator.class);
        }
        this.evaluator = this.j2sePropEval.evaluator();
        this.enabledModel = this.jnlpPropGroup.createToggleButtonModel(this.evaluator, JNLP_ENABLED);
        this.allowOfflineModel = this.jnlpPropGroup.createToggleButtonModel(this.evaluator, JNLP_OFFLINE);
        this.signedModel = this.jnlpPropGroup.createToggleButtonModel(this.evaluator, JNLP_SIGNED);
        this.iconDocument = this.jnlpPropGroup.createStringDocument(this.evaluator, JNLP_ICON);
        this.codebaseModel = new CodebaseComboBoxModel();
        this.codebaseURLDocument = this.createCBTextFieldDocument();
    }

    boolean isJWSEnabled() {
        return this.enabledModel.isSelected();
    }

    private void storeRest(EditableProperties editableProperties) {
        String string = ((CodebaseComboBoxModel)this.codebaseModel).getSelectedCodebaseItem();
        String string2 = null;
        String string3 = null;
        if (CB_TYPE_USER.equals(string)) {
            string2 = JNLP_CBASE_USER;
            try {
                string3 = this.codebaseURLDocument.getText(0, this.codebaseURLDocument.getLength());
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        } else if (CB_TYPE_LOCAL.equals(string)) {
            string2 = JNLP_CBASE_URL;
            string3 = this.getProjectDistDir();
        } else if (CB_TYPE_WEB.equals(string)) {
            string2 = JNLP_CBASE_URL;
            string3 = CB_URL_WEB_PROP_VALUE;
        }
        if (string2 == null || string3 == null) {
            return;
        }
        editableProperties.setProperty(JNLP_CBASE_TYPE, string);
        editableProperties.setProperty(string2, string3);
    }

    public void store() throws IOException {
        final EditableProperties editableProperties = new EditableProperties(true);
        final FileObject fileObject = this.j2seProject.getProjectDirectory().getFileObject("nbproject/project.properties");
        try {
            final InputStream inputStream = fileObject.getInputStream();
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    try {
                        editableProperties.load(inputStream);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    JWSProjectProperties.this.jnlpPropGroup.store(editableProperties);
                    JWSProjectProperties.this.storeRest(editableProperties);
                    OutputStream outputStream = null;
                    FileLock fileLock = null;
                    try {
                        fileLock = fileObject.lock();
                        outputStream = fileObject.getOutputStream(fileLock);
                        editableProperties.store(outputStream);
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private Document createCBTextFieldDocument() {
        PlainDocument plainDocument = new PlainDocument();
        String string = this.evaluator.getProperty(JNLP_CBASE_USER);
        String string2 = this.evaluator.getProperty(JNLP_CBASE_TYPE);
        String string3 = "";
        if (CB_TYPE_LOCAL.equals(string2)) {
            string3 = this.getProjectDistDir();
        } else if (CB_TYPE_WEB.equals(string2)) {
            string3 = CB_URL_WEB;
        } else if (CB_TYPE_USER.equals(string2)) {
            string3 = this.getCodebaseLocation();
        }
        try {
            plainDocument.insertString(0, string3, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return plainDocument;
    }

    public String getCodebaseLocation() {
        return this.evaluator.getProperty(JNLP_CBASE_USER);
    }

    public String getProjectDistDir() {
        File file = new File(FileUtil.toFile((FileObject)this.j2seProject.getProjectDirectory()), this.evaluator.getProperty("dist.dir"));
        return file.toURI().toString();
    }

    public String getProperty(String string) {
        return this.evaluator.getProperty(string);
    }

    public class CodebaseComboBoxModel
    extends DefaultComboBoxModel {
        String localLabel = NbBundle.getBundle(JWSProjectProperties.class).getString("LBL_CB_Combo_Local");
        String webLabel = NbBundle.getBundle(JWSProjectProperties.class).getString("LBL_CB_Combo_Web");
        String userLabel = NbBundle.getBundle(JWSProjectProperties.class).getString("LBL_CB_Combo_User");
        Object[] visItems = new Object[]{this.localLabel, this.webLabel, this.userLabel};
        String[] cbItems = new String[]{"local", "web", "user"};

        public CodebaseComboBoxModel() {
            this.addElement(this.visItems[0]);
            this.addElement(this.visItems[1]);
            this.addElement(this.visItems[2]);
            String string = JWSProjectProperties.this.evaluator.getProperty(JWSProjectProperties.JNLP_CBASE_TYPE);
            if (this.cbItems[2].equals(string)) {
                this.setSelectedItem(this.visItems[2]);
            } else if (this.cbItems[1].equals(string)) {
                this.setSelectedItem(this.visItems[1]);
            } else {
                this.setSelectedItem(this.visItems[0]);
            }
        }

        public String getSelectedCodebaseItem() {
            return this.cbItems[this.getIndexOf(this.getSelectedItem())];
        }
    }
}

