/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer;

import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.NameGenerator;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.SchemaReferenceDecorator;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.ui.ModelCookie;
import org.netbeans.modules.xml.xam.ui.customizer.AbstractReferenceCustomizer;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceCustomizer;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDecorator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportCustomizer
extends ExternalReferenceCustomizer<Import> {
    private static final long serialVersionUID = 1L;
    private ExternalReferenceDecorator decorator;

    public ImportCustomizer(Import import_) {
        super((Component)import_, null);
    }

    public void applyChanges() throws IOException {
        super.applyChanges();
        Import import_ = (Import)this.getModelComponent();
        if (this.isLocationChanged()) {
            import_.setSchemaLocation(this.getEditedLocation());
        }
        String string = this.getEditedNamespace();
        if (this.mustNamespaceDiffer() && this.isNamespaceChanged()) {
            import_.setNamespace(string);
        }
        if (this.mustNamespaceDiffer()) {
            SchemaModel schemaModel = ((Import)this.getModelComponent()).getModel();
            String string2 = this.getEditedPrefix();
            if (string2.length() > 0) {
                schemaModel.getSchema().addPrefix(string2, string);
            }
        }
    }

    protected String getReferenceLocation() {
        Import import_ = (Import)this.getModelComponent();
        return import_.getSchemaLocation();
    }

    protected String getNamespace() {
        Import import_ = (Import)this.getModelComponent();
        return import_.getNamespace();
    }

    private static String findPrefix(SchemaModel schemaModel, String string) {
        Map map = schemaModel.getSchema().getPrefixes();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getValue()).equals(string)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private static String findPrefix(WSDLModel wSDLModel, String string) {
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)wSDLModel.getDefinitions();
        Map map = abstractDocumentComponent.getPrefixes();
        for (Map.Entry entry : map.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey().toString();
        }
        return null;
    }

    protected String getPrefix() {
        Import import_ = (Import)this.getModelComponent();
        String string = import_.getNamespace();
        SchemaModel schemaModel = ((Import)this.getModelComponent()).getModel();
        String string2 = ImportCustomizer.findPrefix(schemaModel, string);
        if (string2 != null) {
            return string2;
        }
        FileObject fileObject = (FileObject)schemaModel.getModelSource().getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            try {
                Model model;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                ModelCookie modelCookie = (ModelCookie)dataObject.getCookie(ModelCookie.class);
                if (modelCookie != null && (model = modelCookie.getModel()) != null && !schemaModel.equals(model)) {
                    if (model instanceof SchemaModel) {
                        return ImportCustomizer.findPrefix((SchemaModel)model, string);
                    }
                    if (model instanceof WSDLModel) {
                        return ImportCustomizer.findPrefix((WSDLModel)model, string);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ImportCustomizer.class);
    }

    protected String getTargetNamespace(Model model) {
        SchemaModel schemaModel;
        Schema schema;
        if (model instanceof SchemaModel && (schema = (schemaModel = (SchemaModel)model).getSchema()) != null) {
            return schema.getTargetNamespace();
        }
        return null;
    }

    protected Map<String, String> getPrefixes(Model model) {
        SchemaModel schemaModel;
        Schema schema;
        if (model instanceof SchemaModel && (schema = (schemaModel = (SchemaModel)model).getSchema()) != null) {
            return schema.getPrefixes();
        }
        return null;
    }

    protected ExternalReferenceDecorator getNodeDecorator() {
        if (this.decorator == null) {
            this.decorator = new SchemaReferenceDecorator((AbstractReferenceCustomizer)this);
        }
        return this.decorator;
    }

    protected String generatePrefix() {
        SchemaModel schemaModel = ((Import)this.getModelComponent()).getModel();
        return NameGenerator.getInstance().generateNamespacePrefix(null, schemaModel);
    }

    public boolean mustNamespaceDiffer() {
        return true;
    }
}

