/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.LocalSimpleType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentFactory;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.schema.model.SimpleTypeDefinition;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.schema.ui.basic.editors.SchemaComponentSelectionPanel;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.AbstractSchemaComponentCustomizer;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.ElementCustomizer;
import org.netbeans.modules.xml.xam.ui.customizer.MessageDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AttributeCustomizer<T extends Attribute>
extends AbstractSchemaComponentCustomizer<T>
implements PropertyChangeListener {
    static final long serialVersionUID = 1L;
    public JRadioButton anonymousSimpleRadioButton;
    public ButtonGroup elementTypeButtonGroup;
    public JRadioButton existingRadioButton;
    public JScrollPane jScrollPane1;
    public JPanel mPanel;
    public JLabel nameLabel;
    public JPanel namePanel;
    public JTextField nameTextField;
    public JLabel previewLabel;
    public JEditorPane previewPane;
    public JLabel typeLabel;
    public JPanel typePanel;
    private DocumentListener nameListener;
    private ItemListener typeButtonsListener;
    private transient AttributeTypeStyle currentStyle;
    private transient GlobalSimpleType currentGlobalSimpleType;
    private transient SchemaComponentSelectionPanel<GlobalSimpleType> componentSelectionPanel;

    public AttributeCustomizer(SchemaComponentReference<T> schemaComponentReference, SchemaComponent schemaComponent, GlobalSimpleType globalSimpleType) {
        super(schemaComponentReference, schemaComponent);
        this.currentGlobalSimpleType = globalSimpleType;
        this.initComponents();
        this.reset();
    }

    public void applyChanges() throws IOException {
        this.saveName();
        if (this._getType() != this.getUIType() || this._getStyle() != this.getUIStyle()) {
            this.setModelType();
        }
    }

    public void reset() {
        this.removeListeners();
        this.initializeModel();
        this.initializeUISelection();
        this.addListeners();
        if (this.hasParent()) {
            this.setSaveEnabled(false);
        } else {
            this.setSaveEnabled(true);
        }
        this.setResetEnabled(false);
    }

    @Override
    protected String _getName() {
        String string = super._getName();
        return string == null ? "" : string;
    }

    protected GlobalSimpleType _getType() {
        return this.currentGlobalSimpleType;
    }

    private AttributeTypeStyle _getStyle() {
        return this.currentStyle;
    }

    protected void _setType(SimpleType simpleType) {
        if (simpleType instanceof GlobalSimpleType) {
            this.currentGlobalSimpleType = (GlobalSimpleType)simpleType;
            this.currentStyle = AttributeTypeStyle.EXISTING;
        } else if (simpleType instanceof LocalSimpleType) {
            this.currentStyle = AttributeTypeStyle.ANONYMOUS;
        }
    }

    protected abstract void initializeModel();

    protected abstract void setModelType();

    private void selectModelNode() {
        this.componentSelectionPanel.setInitialSelection(this._getType());
    }

    private void initializeTypeView() {
        this.componentSelectionPanel = new SchemaComponentSelectionPanel<Object>(((Attribute)this.getReference().get()).getModel(), GlobalSimpleType.class, null, null, true);
        this.componentSelectionPanel.addPropertyChangeListener(this);
        this.typePanel.add((Component)this.componentSelectionPanel.getTypeSelectionPanel(), "Center");
        this.componentSelectionPanel.getTypeSelectionPanel().getAccessibleContext().setAccessibleParent(this.typePanel);
    }

    private void initializeUISelection() {
        this.getMessageDisplayer().clear();
        this.nameTextField.getDocument().removeDocumentListener(this.nameListener);
        this.nameTextField.setText(this._getName());
        if (!this.hasParent()) {
            this.nameTextField.setSelectionStart(0);
        }
        this.nameTextField.getDocument().addDocumentListener(this.nameListener);
        AttributeTypeStyle attributeTypeStyle = this._getStyle();
        if (attributeTypeStyle == AttributeTypeStyle.ANONYMOUS) {
            this.anonymousSimpleRadioButton.setSelected(true);
        } else if (attributeTypeStyle == AttributeTypeStyle.EXISTING) {
            this.existingRadioButton.setSelected(true);
        }
        this.enableDisableListView();
        if (attributeTypeStyle != AttributeTypeStyle.ANONYMOUS) {
            this.selectModelNode();
        }
        this.setPreviewText();
    }

    protected LocalSimpleType createLocalType() {
        SchemaComponentFactory schemaComponentFactory = ((Attribute)this.getReference().get()).getModel().getFactory();
        GlobalSimpleType globalSimpleType = this.getUIType();
        LocalSimpleType localSimpleType = schemaComponentFactory.createLocalSimpleType();
        SimpleTypeRestriction simpleTypeRestriction = schemaComponentFactory.createSimpleTypeRestriction();
        simpleTypeRestriction.setBase(ElementCustomizer.createStringTypeReference(schemaComponentFactory, (SchemaComponent)simpleTypeRestriction));
        localSimpleType.setDefinition((SimpleTypeDefinition)simpleTypeRestriction);
        return localSimpleType;
    }

    @Override
    protected String getUIName() {
        return this.nameTextField.getText();
    }

    protected GlobalSimpleType getUIType() {
        AttributeTypeStyle attributeTypeStyle = this.getUIStyle();
        if (attributeTypeStyle == AttributeTypeStyle.ANONYMOUS) {
            return null;
        }
        return this.componentSelectionPanel.getCurrentSelection();
    }

    protected AttributeTypeStyle getUIStyle() {
        if (this.anonymousSimpleRadioButton.isSelected()) {
            return AttributeTypeStyle.ANONYMOUS;
        }
        if (this.existingRadioButton.isSelected()) {
            return AttributeTypeStyle.EXISTING;
        }
        return null;
    }

    private void initComponents() {
        this.elementTypeButtonGroup = new ButtonGroup();
        this.previewLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.previewPane = new JEditorPane(){
            static final long serialVersionUID = 1L;

            protected void processMouseEvent(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }

            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        };
        this.typeLabel = new JLabel();
        this.anonymousSimpleRadioButton = new JRadioButton();
        this.existingRadioButton = new JRadioButton();
        this.typePanel = new JPanel();
        this.mPanel = new JPanel();
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.previewLabel.setLabelFor(this.previewPane);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(AttributeCustomizer.class, (String)"TITLE_CustomizerForm_Preview"));
        this.previewLabel.setToolTipText(NbBundle.getMessage(AttributeCustomizer.class, (String)"HINT_AttributeForm_Preview"));
        this.previewPane.setEditable(false);
        this.previewPane.setContentType("text/xml");
        this.previewPane.setEnabled(false);
        this.jScrollPane1.setViewportView(this.previewPane);
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(AttributeCustomizer.class, (String)"LBL_CustomizerForm_Type", (Object[])new Object[0]));
        this.typeLabel.setToolTipText(NbBundle.getMessage(AttributeCustomizer.class, (String)"HINT_AttributeForm_Type"));
        this.elementTypeButtonGroup.add(this.anonymousSimpleRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.anonymousSimpleRadioButton, (String)NbBundle.getMessage(AttributeCustomizer.class, (String)"LBL_AttributeForm_AnonType"));
        this.anonymousSimpleRadioButton.setToolTipText(NbBundle.getMessage(AttributeCustomizer.class, (String)"HINT_AttributeForm_AnonType"));
        this.anonymousSimpleRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anonymousSimpleRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.elementTypeButtonGroup.add(this.existingRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.existingRadioButton, (String)NbBundle.getMessage(AttributeCustomizer.class, (String)"LBL_AttributeForm_ExistingType"));
        this.existingRadioButton.setToolTipText(NbBundle.getMessage(AttributeCustomizer.class, (String)"HINT_AttributeForm_ExistingType"));
        this.existingRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.existingRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.typePanel.setLayout(new BorderLayout());
        this.initializeTypeView();
        this.mPanel.setLayout(new BorderLayout());
        this.mPanel.add((Component)this.getMessageDisplayer().getComponent(), "Center");
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(AttributeCustomizer.class, (String)"LBL_CustomizerForm_Name"));
        this.nameLabel.setToolTipText(NbBundle.getMessage(AttributeCustomizer.class, (String)"HINT_AttributeForm_Name"));
        this.nameTextField.setEditable(!this.hasParent());
        GroupLayout groupLayout = new GroupLayout((Container)this.namePanel);
        this.namePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.nameLabel).addPreferredGap(0).add((Component)this.nameTextField, -1, 445, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameTextField, -2, -1, -2))));
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.typeLabel).addContainerGap(462, Short.MAX_VALUE)).add((Component)this.namePanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.mPanel, -1, 500, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 480, Short.MAX_VALUE).add((Component)this.previewLabel).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.existingRadioButton).add((Component)this.anonymousSimpleRadioButton)))).addContainerGap()).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(38, 38, 38).add((Component)this.typePanel, -1, 452, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.namePanel, -2, -1, -2).add(11, 11, 11).add((Component)this.typeLabel).addPreferredGap(0).add((Component)this.anonymousSimpleRadioButton).addPreferredGap(0).add((Component)this.existingRadioButton).addPreferredGap(0).add((Component)this.typePanel, -1, 256, Short.MAX_VALUE).add(11, 11, 11).add((Component)this.previewLabel).add(5, 5, 5).add((Component)this.jScrollPane1, -1, 100, Short.MAX_VALUE).add(0, 0, 0).add((Component)this.mPanel, -1, 60, Short.MAX_VALUE)));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectionChanged")) {
            this.setPreviewText();
            this.determineValidity();
        }
    }

    private void enableDisableListView() {
        if (this.getUIStyle() == AttributeTypeStyle.EXISTING) {
            this.componentSelectionPanel.setEnabled(true);
        } else {
            this.componentSelectionPanel.setEnabled(false);
        }
    }

    private void determineValidity() {
        this.getMessageDisplayer().clear();
        if (!this.isNameChanged() && this._getStyle() == this.getUIStyle() && this._getType() == this.getUIType()) {
            if (this.hasParent()) {
                this.setSaveEnabled(false);
            } else {
                this.setSaveEnabled(true);
            }
            this.setResetEnabled(false);
        } else {
            this.setResetEnabled(true);
            boolean bl = false;
            AttributeTypeStyle attributeTypeStyle = this.getUIStyle();
            if (attributeTypeStyle == AttributeTypeStyle.ANONYMOUS) {
                bl = true;
            } else if (this.getUIType() != null) {
                bl = true;
            }
            this.setSaveEnabled(bl && (!this.isNameChanged() || this.isNameValid()));
            if (!bl) {
                this.getMessageDisplayer().annotate(NbBundle.getMessage(AttributeCustomizer.class, (String)"MSG_Type_Error"), MessageDisplayer.Type.ERROR);
            }
        }
    }

    private void addListeners() {
        if (this.nameListener == null) {
            this.nameListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    AttributeCustomizer.this.setPreviewText();
                    AttributeCustomizer.this.determineValidity();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    AttributeCustomizer.this.setPreviewText();
                    AttributeCustomizer.this.determineValidity();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    AttributeCustomizer.this.setPreviewText();
                    AttributeCustomizer.this.determineValidity();
                }
            };
        }
        this.nameTextField.getDocument().addDocumentListener(this.nameListener);
        if (this.typeButtonsListener == null) {
            this.typeButtonsListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        AttributeCustomizer.this.enableDisableListView();
                        AttributeCustomizer.this.setPreviewText();
                        AttributeCustomizer.this.determineValidity();
                    }
                }
            };
        }
        this.anonymousSimpleRadioButton.addItemListener(this.typeButtonsListener);
        this.existingRadioButton.addItemListener(this.typeButtonsListener);
    }

    private void removeListeners() {
        this.nameTextField.getDocument().removeDocumentListener(this.nameListener);
        this.anonymousSimpleRadioButton.removeItemListener(this.typeButtonsListener);
        this.existingRadioButton.removeItemListener(this.typeButtonsListener);
    }

    private void setPreviewText() {
        StringBuffer stringBuffer = new StringBuffer("<");
        String string = ((Attribute)this.getReference().get()).getPeer().getPrefix();
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("attribute name=\"");
        stringBuffer.append(this.getUIName());
        stringBuffer.append("\"");
        AttributeTypeStyle attributeTypeStyle = this.getUIStyle();
        if (attributeTypeStyle == AttributeTypeStyle.EXISTING) {
            stringBuffer.append(" type=\"");
            GlobalSimpleType globalSimpleType = this.getUIType();
            if (globalSimpleType != null) {
                stringBuffer.append(globalSimpleType.getName());
            }
            stringBuffer.append("\">");
        } else if (attributeTypeStyle == AttributeTypeStyle.ANONYMOUS) {
            stringBuffer.append(">");
            stringBuffer.append("\n    <");
            if (string != null) {
                stringBuffer.append(string + ":");
            }
            stringBuffer.append("simpleType>");
            stringBuffer.append("\n        <");
            if (string != null) {
                stringBuffer.append(string + ":");
            }
            stringBuffer.append("restriction base=\"");
            if (string != null) {
                stringBuffer.append(string + ":");
            }
            stringBuffer.append("string\"/>");
            stringBuffer.append("\n    </");
            if (string != null) {
                stringBuffer.append(string + ":");
            }
            stringBuffer.append("simpleType>");
        }
        stringBuffer.append("\n</");
        if (string != null) {
            stringBuffer.append(string + ":");
        }
        stringBuffer.append("attribute>\n");
        this.previewPane.setText(stringBuffer.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AttributeTypeStyle {
        ANONYMOUS,
        EXISTING;

    }
}

