/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic.editors;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import org.openide.util.NbBundle;

public class StringEditor
extends PropertyEditorSupport {
    public static final String EMPTY = "";

    public String getAsText() {
        Object object = super.getValue();
        return object == null ? EMPTY : super.getAsText();
    }

    public void setAsText(String string) {
        if (EMPTY.equals(string) && this.getValue() == null) {
            return;
        }
        this.setValue(string);
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = this.getPaintableString();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, rectangle.x, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
    }

    protected String getPaintableString() {
        String string = (String)this.getValue();
        return string == null ? NbBundle.getMessage(StringEditor.class, (String)"LBL_Null") : string;
    }
}

