/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic.editors;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Date;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.ui.basic.editors.SchemaComponentSelDialogDesc;
import org.netbeans.modules.xml.schema.ui.basic.editors.SchemaComponentSelectionPanel;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalReferenceEditor<T extends ReferenceableSchemaComponent>
extends PropertyEditorSupport
implements ExPropertyEditor {
    private SchemaComponentSelectionPanel panel;
    private DialogDescriptor descriptor;
    private SchemaComponent component;
    private Class<T> referenceType;
    private String typeDisplayName;
    private String propertyDisplayName;

    public GlobalReferenceEditor(SchemaComponent schemaComponent, String string, String string2, Class<T> clazz) {
        this.typeDisplayName = string;
        this.propertyDisplayName = string2;
        this.referenceType = clazz;
        this.component = schemaComponent;
    }

    @Override
    public String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        if (object instanceof NamedComponentReference && this.component.getModel() != null) {
            Referenceable referenceable = ((NamedComponentReference)object).get();
            if (referenceable == null) {
                return null;
            }
            if (referenceable instanceof Named) {
                return ((Named)referenceable).getName();
            }
        }
        return object.toString();
    }

    @Override
    public Component getCustomEditor() {
        NamedComponentReference namedComponentReference = (NamedComponentReference)this.getValue();
        ArrayList<SchemaComponent> arrayList = null;
        if (this.referenceType.isInstance(this.component)) {
            arrayList = new ArrayList<SchemaComponent>();
            arrayList.add(this.component);
        } else {
            for (SchemaComponent schemaComponent = (SchemaComponent)this.component.getParent(); schemaComponent != null; schemaComponent = (SchemaComponent)schemaComponent.getParent()) {
                if (!this.referenceType.isInstance(schemaComponent)) continue;
                arrayList = new ArrayList();
                arrayList.add(schemaComponent);
                break;
            }
        }
        boolean bl = GlobalSimpleType.class.isAssignableFrom(this.referenceType);
        this.panel = new SchemaComponentSelectionPanel<ReferenceableSchemaComponent>(this.component.getModel(), this.referenceType, namedComponentReference == null ? null : (ReferenceableSchemaComponent)namedComponentReference.get(), arrayList, bl);
        this.descriptor = new SchemaComponentSelDialogDesc(this.panel, NbBundle.getMessage(GlobalReferenceEditor.class, (String)"LBL_Custom_Property_Editor_Title", (Object[])new Object[]{this.typeDisplayName, this.propertyDisplayName}), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    try {
                        GlobalReferenceEditor.this.setValue(GlobalReferenceEditor.this.getCurrentSelection(GlobalReferenceEditor.this.panel.getCurrentSelection()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), illegalArgumentException.getLocalizedMessage(), null, new Date());
                        throw illegalArgumentException;
                    }
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        return dialog;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    private NamedComponentReference getCurrentSelection(SchemaComponent schemaComponent) {
        return schemaComponent == null ? null : schemaComponent.getModel().getFactory().createGlobalReference((ReferenceableSchemaComponent)this.referenceType.cast(schemaComponent), this.referenceType, this.component);
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        FeatureDescriptor featureDescriptor = propertyEnv.getFeatureDescriptor();
        featureDescriptor.setValue("canEditAsText", Boolean.FALSE);
    }
}

