/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic;

import java.io.IOException;
import java.io.ObjectInput;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SchemaSettings {
    private static SchemaSettings INSTANCE = new SchemaSettings();
    public static final String PROP_VIEW_MODE = "viewMode";
    public static final String PROP_LANGUAGE = "language";

    private SchemaSettings() {
        this.setDefaults();
    }

    public String displayName() {
        return NbBundle.getMessage(SchemaSettings.class, (String)"CTL_SchemaSettings_name");
    }

    public static SchemaSettings getDefault() {
        return INSTANCE;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public ViewMode getViewMode() {
        String string = this.getProperty(PROP_VIEW_MODE);
        if (string == null) {
            return ViewMode.COLUMN;
        }
        return ViewMode.valueOf(string);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setDefaults();
    }

    private void setDefaults() {
        if (this.getProperty(PROP_VIEW_MODE) == null) {
            this.putProperty(PROP_VIEW_MODE, ViewMode.COLUMN.toString());
        }
    }

    public void setViewMode(ViewMode viewMode) {
        this.putProperty(PROP_VIEW_MODE, viewMode.toString());
    }

    public String getLanguage() {
        return this.getProperty(PROP_LANGUAGE);
    }

    public void setLanguage(String string) {
        this.putProperty(PROP_LANGUAGE, string);
    }

    protected final String putProperty(String string, String string2) {
        String string3 = NbPreferences.forModule(SchemaSettings.class).get(string, null);
        if (string2 != null) {
            NbPreferences.forModule(SchemaSettings.class).put(string, string2);
        } else {
            NbPreferences.forModule(SchemaSettings.class).remove(string);
        }
        return string3;
    }

    protected final String getProperty(String string) {
        return NbPreferences.forModule(SchemaSettings.class).get(string, ViewMode.COLUMN.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewMode {
        TREE,
        COLUMN;

    }
}

