/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JPanel;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.SchemaColumn;
import org.netbeans.modules.xml.schema.ui.basic.UIUtilities;
import org.netbeans.modules.xml.schema.ui.nodes.SchemaNodeFactory;
import org.netbeans.modules.xml.schema.ui.nodes.StructuralSchemaNodeFactory;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedSchemaNodeFactory;
import org.netbeans.modules.xml.schema.ui.nodes.schema.SchemaNode;
import org.netbeans.modules.xml.xam.ui.column.BasicColumnView;
import org.netbeans.modules.xml.xam.ui.column.Column;
import org.netbeans.modules.xml.xam.ui.column.ColumnView;
import org.netbeans.modules.xml.xam.ui.column.LinkPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaColumnsView
extends JPanel
implements ColumnView,
PropertyChangeListener {
    static final long serialVersionUID = 1L;
    private transient BasicColumnView columnView;
    private transient LinkPanel breadCrumbs = new LinkPanel((ColumnView)this);
    private transient SchemaModel schemaModel;
    private transient SchemaNodeFactory factory;
    private ViewType viewType;
    private transient Lookup lookup;
    private Class<? extends EventListener> columnListenerClass;
    private transient EventListener columnListener;
    public static final String PROP_COLUMN_ADDED = "column_added";

    public SchemaColumnsView(SchemaModel schemaModel, ViewType viewType, Lookup lookup) {
        super(new BorderLayout());
        this.add((Component)this.breadCrumbs, "North");
        this.columnView = new BasicColumnView();
        this.add((Component)this.columnView, "Center");
        this.schemaModel = schemaModel;
        this.lookup = lookup;
        this._setViewType(viewType);
    }

    public void setNodeFactory(SchemaNodeFactory schemaNodeFactory) {
        this._setNodeFactory(schemaNodeFactory);
    }

    private void _setNodeFactory(SchemaNodeFactory schemaNodeFactory) {
        this.factory = schemaNodeFactory;
        this.clearColumns();
        SchemaNode schemaNode = schemaNodeFactory.createRootNode();
        SchemaColumn schemaColumn = this.createColumnComponent((Node)schemaNode, true);
        this.appendColumn(schemaColumn);
    }

    protected SchemaColumn createColumnComponent(Node node, boolean bl) {
        SchemaColumn schemaColumn = new SchemaColumn(this, node, bl);
        this.addColumnListener(schemaColumn);
        return schemaColumn;
    }

    public void addColumnListener(SchemaColumn schemaColumn) {
        if (this.columnListener != null || this.columnListenerClass != null) {
            try {
                Method method = SchemaColumn.class.getMethod("add" + this.columnListenerClass.getSimpleName(), this.columnListenerClass);
                method.invoke((Object)schemaColumn, this.columnListener);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
            }
        }
    }

    public <L extends EventListener> void setColumnListener(Class<L> clazz, L l) {
        this.columnListenerClass = clazz;
        this.columnListener = l;
    }

    public EventListener getColumnListener() {
        return this.columnListener;
    }

    private void _setViewType(ViewType viewType) {
        if (this.viewType != viewType) {
            this.viewType = viewType;
            SchemaNodeFactory schemaNodeFactory = this.createNodeFactory(viewType);
            if (schemaNodeFactory != null) {
                this._setNodeFactory(schemaNodeFactory);
            }
        }
    }

    private SchemaNodeFactory createNodeFactory(ViewType viewType) {
        SchemaNodeFactory schemaNodeFactory;
        switch (viewType) {
            case CATEGORIZED: {
                schemaNodeFactory = new CategorizedSchemaNodeFactory(this.schemaModel, this.lookup);
                break;
            }
            case STRUCTURAL: {
                schemaNodeFactory = new StructuralSchemaNodeFactory(this.schemaModel, this.lookup);
                break;
            }
            default: {
                schemaNodeFactory = null;
            }
        }
        return schemaNodeFactory;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (propertyChangeEvent.getPropertyName().equals("title") && object instanceof Column) {
            this.breadCrumbs.updateLink((Column)object);
        }
    }

    public void showComponent(SchemaComponent schemaComponent) {
        Object object = null;
        Column column = this.getFirstColumn();
        ExplorerManager explorerManager = null;
        if (column instanceof ExplorerManager.Provider) {
            explorerManager = ((ExplorerManager.Provider)column).getExplorerManager();
        }
        if (explorerManager != null) {
            object = explorerManager.getRootContext();
        } else {
            object = this.factory.createRootNode();
            this.clearColumns();
            column = this.createColumnComponent((Node)object, false);
            this.appendColumn(column);
            explorerManager = ExplorerManager.find((Component)column.getComponent());
        }
        List<Node> list = UIUtilities.findPathFromRoot(object, schemaComponent);
        if (list.isEmpty()) {
            return;
        }
        int n = 0;
        Column column2 = column;
        ExplorerManager explorerManager2 = explorerManager;
        for (Node object2 : list.subList(0, list.size() - 1)) {
            boolean node = false;
            while (explorerManager2 != null && explorerManager2.getRootContext() == object2) {
                node = true;
                column = column2;
                explorerManager = explorerManager2;
                if (!((column2 = this.getNextColumn(column2)) instanceof ExplorerManager.Provider)) break;
                explorerManager2 = ((ExplorerManager.Provider)column2).getExplorerManager();
            }
            if (node) {
                ++n;
                continue;
            }
            this.removeColumnsAfter(column);
            try {
                explorerManager.setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {}
            break;
        }
        if (n < list.size() - 1) {
            ArrayList arrayList = new ArrayList();
            for (Node node : list.subList(n, list.size() - 1)) {
                column = this.createColumnComponent(node, true);
                arrayList.add(column);
            }
            Column[] columnArray = arrayList.toArray(new Column[arrayList.size()]);
            this.appendColumns(columnArray);
        }
        if (column instanceof ExplorerManager.Provider) {
            explorerManager = ((ExplorerManager.Provider)column).getExplorerManager();
        }
        try {
            if (explorerManager != null) {
                explorerManager.setSelectedNodes(new Node[]{list.get(list.size() - 1)});
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void removeListeners(Column column) {
        while (column != null) {
            column.removePropertyChangeListener((PropertyChangeListener)this);
            column = this.getNextColumn(column);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.columnView.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.columnView.requestFocusInWindow();
    }

    public void appendColumn(Column column) {
        column.addPropertyChangeListener((PropertyChangeListener)this);
        this.columnView.appendColumn(column);
        this.breadCrumbs.appendLink(column);
        this.firePropertyChange(PROP_COLUMN_ADDED, null, column);
    }

    public void appendColumns(Column[] columnArray) {
        for (Column column : columnArray) {
            column.addPropertyChangeListener((PropertyChangeListener)this);
            this.breadCrumbs.appendLink(column);
            this.firePropertyChange(PROP_COLUMN_ADDED, null, column);
        }
        this.columnView.appendColumns(columnArray);
    }

    public void clearColumns() {
        this.removeListeners(this.getFirstColumn());
        this.columnView.clearColumns();
        this.breadCrumbs.clearLinks();
    }

    public int getColumnCount() {
        return this.columnView.getColumnCount();
    }

    public int getColumnIndex(Column column) {
        return this.columnView.getColumnIndex(column);
    }

    public Column getFirstColumn() {
        return this.columnView.getFirstColumn();
    }

    public Column getNextColumn(Column column) {
        return this.columnView.getNextColumn(column);
    }

    public void removeColumnsAfter(Column column) {
        this.removeListeners(this.getNextColumn(column));
        int n = this.columnView.getColumnIndex(column);
        this.columnView.removeColumnsAfter(column);
        this.breadCrumbs.truncateLinks(n + 1);
    }

    public void scrollToColumn(Column column, boolean bl) {
        this.columnView.scrollToColumn(column, bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewType {
        CUSTOM,
        CATEGORIZED,
        STRUCTURAL;

    }
}

