/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.xml.schema.ui.basic.SchemaColumnsView;
import org.netbeans.modules.xml.schema.ui.nodes.SchemaComponentNode;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategoryNode;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.DummySchemaNode;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.ReadOnlySchemaComponentNode;
import org.netbeans.modules.xml.schema.ui.nodes.schema.SchemaNode;
import org.netbeans.modules.xml.xam.ui.column.Column;
import org.netbeans.modules.xml.xam.ui.column.ColumnListCellRenderer;
import org.netbeans.modules.xml.xam.ui.column.ColumnListView;
import org.netbeans.modules.xml.xam.ui.column.ColumnProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SchemaColumn
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider,
NodeListener,
Column,
FocusListener {
    private static final long serialVersionUID = 1L;
    private SchemaColumnsView columnView;
    private ExplorerManager explorerManager;
    private transient Lookup lookup;
    private ListView nodeView;
    private JLabel noChildrenLabel;
    public static final String SCHEMA_COLUMN_NODE_SELECTED = "schema-column-node-selected";

    public SchemaColumn(SchemaColumnsView schemaColumnsView, Node object, boolean bl) {
        this.columnView = schemaColumnsView;
        this.explorerManager = new ExplorerManager();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        Color color = UIManager.getColor("window");
        this.setBackground(color != null ? color : Color.white);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(200, 200));
        this.nodeView = new ColumnListView(this.explorerManager);
        this.nodeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaColumn.class, (String)"LBL_SchemaCategory_Categorized"));
        this.nodeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaColumn.class, (String)"HINT_SchemaCategory_Categorized"));
        this.nodeView.setSelectionMode(2);
        this.nodeView.setTraversalAllowed(false);
        this.nodeView.setVerticalScrollBarPolicy(22);
        this.add((Component)this.nodeView, "Center");
        JList jList = (JList)this.nodeView.getViewport().getView();
        jList.addFocusListener(this);
        jList.setCellRenderer(new ColumnListCellRenderer());
        if (object != null) {
            if (object.getCookie(DummySchemaNode.class) == null && object.getCookie(SchemaNode.class) != null) {
                object = new DummySchemaNode((Node)object);
            }
            this.getExplorerManager().setRootContext(object);
            object.addNodeListener((NodeListener)this);
            this.noChildrenLabel = new JLabel(NbBundle.getMessage(SchemaColumn.class, (String)"LBL_NoChildren"));
            this.noChildrenLabel.setBackground(this.getBackground());
            this.noChildrenLabel.setHorizontalTextPosition(0);
            this.noChildrenLabel.setHorizontalAlignment(0);
            this.noChildrenLabel.setVisible(false);
            this.noChildrenLabel.setEnabled(false);
            if (object.getCookie(CategoryNode.class) != null) {
                this.noChildrenLabel.setText(NbBundle.getMessage(SchemaColumn.class, (String)"LBL_NoCateroryChildren", (Object)object.getDisplayName()));
            }
        }
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)false));
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)actionMap);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void requestFocus() {
        super.requestFocus();
        this.nodeView.requestFocus();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.nodeView.requestFocusInWindow();
    }

    protected TopComponent findParentTopComponent() {
        return (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
    }

    public JComponent getComponent() {
        return this;
    }

    public String getTitle() {
        Node node = this.getExplorerManager().getRootContext();
        Column column = this.columnView.getFirstColumn();
        if (column == this && (node.getCookie(DummySchemaNode.class) != null || node.getCookie(SchemaNode.class) != null)) {
            return NbBundle.getMessage(SchemaColumn.class, (String)"LBL_SchemaNode_Title");
        }
        return this.getDefaultDisplayName(node);
    }

    private String getDefaultDisplayName(Node node) {
        SchemaComponentNode schemaComponentNode;
        String string = null;
        ReadOnlySchemaComponentNode readOnlySchemaComponentNode = (ReadOnlySchemaComponentNode)((Object)node.getLookup().lookup(ReadOnlySchemaComponentNode.class));
        string = readOnlySchemaComponentNode != null ? readOnlySchemaComponentNode.getDefaultDisplayName() : ((schemaComponentNode = (SchemaComponentNode)node.getLookup().lookup(SchemaComponentNode.class)) != null ? schemaComponentNode.getDefaultDisplayName() : node.getDisplayName());
        return string;
    }

    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        Node node = this.getExplorerManager().getRootContext();
        stringBuilder.append(this.getDefaultDisplayName(node));
        for (node = node.getParentNode(); node != null; node = node.getParentNode()) {
            stringBuilder.insert(0, '/');
            stringBuilder.insert(0, this.getDefaultDisplayName(node));
        }
        return stringBuilder.toString();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if ("selectedNodes".equals(string)) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray != null && nodeArray.length >= 1) {
                TopComponent topComponent = this.findParentTopComponent();
                if (topComponent != null) {
                    topComponent.setActivatedNodes(nodeArray);
                }
                this.addDetailColumn(nodeArray[0]);
                EventListener eventListener = this.getColumnView().getColumnListener();
                if (eventListener != null) {
                    this.firePropertyChange(SCHEMA_COLUMN_NODE_SELECTED, null, nodeArray[0]);
                }
            }
        } else if ("displayName".equals(string) && object instanceof Node) {
            this.firePropertyChange("title", null, null);
        }
    }

    protected void addDetailColumn(Node node) {
        SchemaColumn schemaColumn;
        Column column = null;
        ColumnProvider columnProvider = (ColumnProvider)node.getLookup().lookup(ColumnProvider.class);
        SchemaColumnsView schemaColumnsView = this.getColumnView();
        if (columnProvider != null && (column = columnProvider.getColumn()) instanceof SchemaColumn && (schemaColumn = (SchemaColumn)column).getColumnView() == null) {
            schemaColumn.setColumnView(schemaColumnsView);
        }
        if (column == null && node != this.getExplorerManager().getRootContext() && node.getChildren() != Children.LEAF) {
            column = this.getColumnView().createColumnComponent(node, false);
        }
        if (schemaColumnsView.getColumnIndex(this) != -1) {
            schemaColumnsView.removeColumnsAfter(this);
        }
        if (column != null) {
            schemaColumnsView.appendColumn(column);
        }
        this.requestFocusInWindow();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        TopComponent topComponent = this.findParentTopComponent();
        if (topComponent != null) {
            JList jList = (JList)this.nodeView.getViewport().getView();
            Object[] objectArray = jList.getSelectedValues();
            if (objectArray != null && objectArray.length > 0) {
                Node[] nodeArray = new Node[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Node node = Visualizer.findNode((Object)objectArray[i]);
                    if (node == null) continue;
                    nodeArray[i] = node;
                }
                topComponent.setActivatedNodes(nodeArray);
            }
            this.getColumnView().scrollToColumn(this, true);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.getColumnView().addColumnListener(this);
        Node node = this.getExplorerManager().getRootContext();
        if (node != null && node.getChildren().getNodesCount() == 0) {
            this.remove((Component)this.nodeView);
            this.noChildrenLabel.setVisible(true);
            this.add((Component)this.noChildrenLabel, "Center");
        }
    }

    protected SchemaColumnsView getColumnView() {
        return this.columnView;
    }

    protected void setColumnView(SchemaColumnsView schemaColumnsView) {
        this.columnView = schemaColumnsView;
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        final Node node = nodeMemberEvent.getNode();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (SchemaColumn.this.noChildrenLabel.isVisible() && node != null && node == SchemaColumn.this.getExplorerManager().getRootContext()) {
                    SchemaColumn.this.noChildrenLabel.setVisible(false);
                    SchemaColumn.this.remove(SchemaColumn.this.noChildrenLabel);
                    SchemaColumn.this.add((Component)SchemaColumn.this.nodeView, "Center");
                }
            }
        });
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        final Node node = nodeMemberEvent.getNode();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!SchemaColumn.this.noChildrenLabel.isVisible() && node != null && node == SchemaColumn.this.getExplorerManager().getRootContext() && node.getChildren().getNodesCount() == 0) {
                    SchemaColumn.this.noChildrenLabel.setVisible(true);
                    SchemaColumn.this.remove((Component)SchemaColumn.this.nodeView);
                    SchemaColumn.this.add((Component)SchemaColumn.this.noChildrenLabel, "Center");
                    SchemaColumn.this.repaint();
                }
            }
        });
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
    }

    public void nodeDestroyed(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        if (node != null && node == this.getExplorerManager().getRootContext()) {
            final SchemaColumnsView schemaColumnsView = this.getColumnView();
            int n = schemaColumnsView.getColumnIndex(this);
            if (n <= 0) {
                return;
            }
            Column column = schemaColumnsView.getFirstColumn();
            for (int i = 1; i < n; ++i) {
                column = schemaColumnsView.getNextColumn(column);
            }
            final Column column2 = column;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    schemaColumnsView.removeColumnsAfter(column2);
                }
            });
        }
    }
}

