/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display.property;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class ScreenChildStringPropertyEditor
implements ScreenPropertyEditor {
    private String propertyName;
    private int alignment;

    public ScreenChildStringPropertyEditor(String string) {
        this(string, 2);
    }

    public ScreenChildStringPropertyEditor(String string, int n) {
        this.alignment = n;
        assert (string != null);
        this.propertyName = string;
    }

    public JComponent createEditorComponent(ScreenPropertyDescriptor screenPropertyDescriptor) {
        StringTextField stringTextField = new StringTextField(screenPropertyDescriptor);
        stringTextField.setMinimumSize(new Dimension(128, 21));
        PropertyValue propertyValue = screenPropertyDescriptor.getRelatedComponent().readProperty(this.propertyName);
        String string = MidpTypes.getString(propertyValue);
        stringTextField.setText(string != null ? string : "");
        stringTextField.selectAll();
        return stringTextField;
    }

    public Insets getEditorComponentInsets(JComponent jComponent) {
        return jComponent.getBorder().getBorderInsets(jComponent);
    }

    private class StringTextField
    extends JTextField
    implements KeyListener {
        private ScreenPropertyDescriptor property;

        public StringTextField(ScreenPropertyDescriptor screenPropertyDescriptor) {
            this.property = screenPropertyDescriptor;
            this.addKeyListener(this);
            this.setHorizontalAlignment(ScreenChildStringPropertyEditor.this.alignment);
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() != '\n') {
                return;
            }
            final DesignComponent designComponent = this.property.getRelatedComponent();
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = MidpTypes.createStringValue(StringTextField.this.getText());
                    designComponent.writeProperty(ScreenChildStringPropertyEditor.this.propertyName, propertyValue);
                }
            });
            PopupUtil.hidePopup();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

