/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.resource.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.resources.FontCD;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.screen.display.ScreenSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontEditorElement
extends PropertyEditorResourceElement {
    private FontStub currentStub;
    private Font defaultFont;
    private JCheckBox boldCheckBox;
    private JRadioButton customRadioButton;
    private JRadioButton defaultRadioButton;
    private ButtonGroup faceButtonGroup;
    private JLabel faceLabel;
    private JRadioButton inputRadioButton;
    private JCheckBox italicCheckBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private ButtonGroup kindButtonGroup;
    private JLabel kindLabel;
    private JRadioButton largeRadioButton;
    private JRadioButton mediumRadioButton;
    private JRadioButton monospaceRadioButton;
    private JCheckBox plainCheckBox;
    private JRadioButton proportionalRadioButton;
    private JLabel sampleLabel;
    private ButtonGroup sizeButtonGroup;
    private JLabel sizeLabel;
    private JRadioButton smallRadioButton;
    private JRadioButton staticRadioButton;
    private JLabel styleLabel;
    private JRadioButton systemRadioButton;
    private JCheckBox underlinedCheckBox;

    public FontEditorElement() {
        this.initComponents();
        this.attachListeners();
        this.defaultFont = this.sampleLabel.getFont();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public TypeID getTypeID() {
        return FontCD.TYPEID;
    }

    @Override
    public List<String> getPropertyValueNames() {
        return Arrays.asList("fontKind", "face", "style", "bold");
    }

    private void attachListeners() {
        KindActionListener kindActionListener = new KindActionListener();
        this.defaultRadioButton.addActionListener(kindActionListener);
        this.staticRadioButton.addActionListener(kindActionListener);
        this.inputRadioButton.addActionListener(kindActionListener);
        this.customRadioButton.addActionListener(kindActionListener);
        FaceActionListener faceActionListener = new FaceActionListener();
        this.systemRadioButton.addActionListener(faceActionListener);
        this.monospaceRadioButton.addActionListener(faceActionListener);
        this.proportionalRadioButton.addActionListener(faceActionListener);
        StyleActionListener styleActionListener = new StyleActionListener();
        this.plainCheckBox.addActionListener(styleActionListener);
        this.boldCheckBox.addActionListener(styleActionListener);
        this.italicCheckBox.addActionListener(styleActionListener);
        this.underlinedCheckBox.addActionListener(styleActionListener);
        SizeActionListener sizeActionListener = new SizeActionListener();
        this.smallRadioButton.addActionListener(sizeActionListener);
        this.mediumRadioButton.addActionListener(sizeActionListener);
        this.largeRadioButton.addActionListener(sizeActionListener);
    }

    private void setKindUnselected() {
        this.defaultRadioButton.setSelected(false);
        this.staticRadioButton.setSelected(false);
        this.inputRadioButton.setSelected(false);
        this.customRadioButton.setSelected(false);
    }

    private void setDefaultFont() {
        this.systemRadioButton.setSelected(false);
        this.monospaceRadioButton.setSelected(false);
        this.proportionalRadioButton.setSelected(false);
        this.plainCheckBox.setSelected(false);
        this.boldCheckBox.setSelected(false);
        this.italicCheckBox.setSelected(false);
        this.underlinedCheckBox.setSelected(false);
        this.smallRadioButton.setSelected(false);
        this.mediumRadioButton.setSelected(false);
        this.largeRadioButton.setSelected(false);
        this.setSampleFont(true);
    }

    private void setFaceSizeStyleEnabled(boolean bl) {
        this.faceLabel.setEnabled(bl);
        this.systemRadioButton.setEnabled(bl);
        this.monospaceRadioButton.setEnabled(bl);
        this.proportionalRadioButton.setEnabled(bl);
        this.styleLabel.setEnabled(bl);
        this.plainCheckBox.setEnabled(bl);
        this.boldCheckBox.setEnabled(bl);
        this.italicCheckBox.setEnabled(bl);
        this.underlinedCheckBox.setEnabled(bl);
        this.sizeLabel.setEnabled(bl);
        this.smallRadioButton.setEnabled(bl);
        this.mediumRadioButton.setEnabled(bl);
        this.largeRadioButton.setEnabled(bl);
    }

    private void setKindEnabled(boolean bl) {
        this.kindLabel.setEnabled(bl);
        this.defaultRadioButton.setEnabled(bl);
        this.staticRadioButton.setEnabled(bl);
        this.inputRadioButton.setEnabled(bl);
        this.customRadioButton.setEnabled(bl);
    }

    private void setAllEnabled(boolean bl) {
        this.setKindEnabled(bl);
        this.setFaceSizeStyleEnabled(bl);
    }

    private void setKindSelected(int n) {
        switch (n) {
            case 0: {
                this.defaultRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.customRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.staticRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.inputRadioButton.setSelected(true);
            }
        }
    }

    private void setFaceSelected(int n) {
        switch (n) {
            case 0: {
                this.systemRadioButton.setSelected(true);
                break;
            }
            case 32: {
                this.monospaceRadioButton.setSelected(true);
                break;
            }
            case 64: {
                this.proportionalRadioButton.setSelected(true);
            }
        }
    }

    private void setSizeSelected(int n) {
        switch (n) {
            case 8: {
                this.smallRadioButton.setSelected(true);
                break;
            }
            case 0: {
                this.mediumRadioButton.setSelected(true);
                break;
            }
            case 16: {
                this.largeRadioButton.setSelected(true);
            }
        }
    }

    private void setStyleSelected(int n) {
        if (n == 0) {
            this.plainCheckBox.setSelected(true);
        } else {
            this.boldCheckBox.setSelected((n & 1) != 0);
            this.italicCheckBox.setSelected((n & 2) != 0);
            this.underlinedCheckBox.setSelected((n & 4) != 0);
        }
    }

    private void setStateOfButtons() {
        int n = this.currentStub.getKind();
        this.setKindSelected(n);
        if (n == 1) {
            int n2 = this.currentStub.getFace();
            int n3 = this.currentStub.getStyle();
            int n4 = this.currentStub.getSize();
            this.setFaceSelected(n2);
            this.setStyleSelected(n3);
            this.setSizeSelected(n4);
        } else {
            this.setFaceSizeStyleEnabled(false);
        }
    }

    private void setSampleFont(boolean bl) {
        if (bl) {
            this.sampleLabel.setFont(this.defaultFont);
            return;
        }
        DesignDocument designDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (designDocument != null) {
            int n = this.currentStub.getKind();
            int n2 = this.currentStub.getFace();
            int n3 = this.currentStub.getStyle();
            int n4 = this.currentStub.getSize();
            this.sampleLabel.setFont(ScreenSupport.getFont(designDocument, n, n2, n3, n4));
        }
    }

    @Override
    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper) {
        if (designComponentWrapper == null) {
            this.setKindUnselected();
            this.setDefaultFont();
            this.setAllEnabled(false);
            return;
        }
        long l = designComponentWrapper.getComponentID();
        final int[] nArray = new int[]{0};
        final int[] nArray2 = new int[]{0};
        final int[] nArray3 = new int[]{0};
        final int[] nArray4 = new int[]{0};
        final DesignComponent designComponent = designComponentWrapper.getComponent();
        if (designComponent != null) {
            if (!designComponent.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + designComponent.getType());
            }
            l = designComponent.getComponentID();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = designComponent.readProperty("fontKind");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue)) {
                        nArray[0] = MidpTypes.getInteger(propertyValue);
                    }
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue = designComponent.readProperty("face"))) {
                        nArray2[0] = MidpTypes.getInteger(propertyValue);
                    }
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue = designComponent.readProperty("style"))) {
                        nArray3[0] = MidpTypes.getInteger(propertyValue);
                    }
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue = designComponent.readProperty("bold"))) {
                        nArray4[0] = MidpTypes.getInteger(propertyValue);
                    }
                }
            });
        }
        if (designComponentWrapper.hasChanges()) {
            Map<String, PropertyValue> map = designComponentWrapper.getChanges();
            for (String string : map.keySet()) {
                PropertyValue propertyValue = map.get(string);
                if ("fontKind".equals(string)) {
                    nArray[0] = MidpTypes.getInteger(propertyValue);
                    continue;
                }
                if ("face".equals(string)) {
                    nArray2[0] = MidpTypes.getInteger(propertyValue);
                    continue;
                }
                if ("style".equals(string)) {
                    nArray3[0] = MidpTypes.getInteger(propertyValue);
                    continue;
                }
                if (!"bold".equals(string)) continue;
                nArray4[0] = MidpTypes.getInteger(propertyValue);
            }
        }
        this.currentStub = new FontStub(l, nArray[0], nArray2[0], nArray3[0], nArray4[0]);
        this.setStateOfButtons();
        this.setKindEnabled(true);
        this.setFaceSizeStyleEnabled(nArray[0] == 1);
        this.setSampleFont(false);
    }

    private void initComponents() {
        this.kindButtonGroup = new ButtonGroup();
        this.faceButtonGroup = new ButtonGroup();
        this.sizeButtonGroup = new ButtonGroup();
        this.defaultRadioButton = new JRadioButton();
        this.staticRadioButton = new JRadioButton();
        this.inputRadioButton = new JRadioButton();
        this.customRadioButton = new JRadioButton();
        this.kindLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.sampleLabel = new JLabel();
        this.faceLabel = new JLabel();
        this.systemRadioButton = new JRadioButton();
        this.monospaceRadioButton = new JRadioButton();
        this.proportionalRadioButton = new JRadioButton();
        this.sizeLabel = new JLabel();
        this.smallRadioButton = new JRadioButton();
        this.mediumRadioButton = new JRadioButton();
        this.largeRadioButton = new JRadioButton();
        this.styleLabel = new JLabel();
        this.plainCheckBox = new JCheckBox();
        this.boldCheckBox = new JCheckBox();
        this.italicCheckBox = new JCheckBox();
        this.underlinedCheckBox = new JCheckBox();
        this.kindButtonGroup.add(this.defaultRadioButton);
        this.defaultRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.defaultRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.defaultRadioButton.text"));
        this.defaultRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.kindButtonGroup.add(this.staticRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.staticRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.staticRadioButton.text"));
        this.staticRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.staticRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.kindButtonGroup.add(this.inputRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.inputRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.inputRadioButton.text"));
        this.inputRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.inputRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.kindButtonGroup.add(this.customRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.customRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.customRadioButton.text"));
        this.customRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.customRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.kindLabel.setText(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.kindLabel.text"));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.jPanel2.border.title")));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setLayout(null);
        this.sampleLabel.setFont(new Font("Dialog", 0, 12));
        this.sampleLabel.setText(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.sampleLabel.text"));
        this.jPanel1.add(this.sampleLabel);
        this.sampleLabel.setBounds(0, 0, 310, 16);
        this.jPanel2.add((Component)this.jPanel1, "Center");
        this.faceLabel.setText(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.faceLabel.text"));
        this.faceLabel.setEnabled(false);
        this.faceButtonGroup.add(this.systemRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.systemRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.systemRadioButton.text"));
        this.systemRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.systemRadioButton.setEnabled(false);
        this.systemRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.faceButtonGroup.add(this.monospaceRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.monospaceRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.monospaceRadioButton.text"));
        this.monospaceRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.monospaceRadioButton.setEnabled(false);
        this.monospaceRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.faceButtonGroup.add(this.proportionalRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.proportionalRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.proportionalRadioButton.text"));
        this.proportionalRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.proportionalRadioButton.setEnabled(false);
        this.proportionalRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.sizeLabel.setText(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.sizeLabel.text"));
        this.sizeLabel.setEnabled(false);
        this.sizeButtonGroup.add(this.smallRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.smallRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.smallRadioButton.text"));
        this.smallRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.smallRadioButton.setEnabled(false);
        this.smallRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.sizeButtonGroup.add(this.mediumRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.mediumRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.mediumRadioButton.text"));
        this.mediumRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mediumRadioButton.setEnabled(false);
        this.mediumRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.sizeButtonGroup.add(this.largeRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.largeRadioButton, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.largeRadioButton.text"));
        this.largeRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.largeRadioButton.setEnabled(false);
        this.largeRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.styleLabel.setText(NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.styleLabel.text"));
        this.styleLabel.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.plainCheckBox, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.plainCheckBox.text"));
        this.plainCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.plainCheckBox.setEnabled(false);
        this.plainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.boldCheckBox, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.boldCheckBox.text"));
        this.boldCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.boldCheckBox.setEnabled(false);
        this.boldCheckBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.italicCheckBox, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.italicCheckBox.text"));
        this.italicCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.italicCheckBox.setEnabled(false);
        this.italicCheckBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.underlinedCheckBox, (String)NbBundle.getMessage(FontEditorElement.class, (String)"FontEditorElement.underlinedCheckBox.text"));
        this.underlinedCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.underlinedCheckBox.setEnabled(false);
        this.underlinedCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.defaultRadioButton).add((Component)this.staticRadioButton).add((Component)this.inputRadioButton).add((Component)this.customRadioButton).add((Component)this.kindLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.faceLabel).add((Component)this.systemRadioButton).add((Component)this.monospaceRadioButton).add((Component)this.proportionalRadioButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.largeRadioButton).add((Component)this.sizeLabel).add((Component)this.mediumRadioButton).add((Component)this.smallRadioButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.styleLabel).add((Component)this.underlinedCheckBox).add((Component)this.boldCheckBox).add((Component)this.plainCheckBox).add((Component)this.italicCheckBox)).addContainerGap()).add(2, (Component)this.jPanel2, -1, 328, Short.MAX_VALUE));
        groupLayout.linkSize(new Component[]{this.boldCheckBox, this.customRadioButton, this.defaultRadioButton, this.faceLabel, this.inputRadioButton, this.italicCheckBox, this.kindLabel, this.largeRadioButton, this.mediumRadioButton, this.monospaceRadioButton, this.plainCheckBox, this.proportionalRadioButton, this.sizeLabel, this.smallRadioButton, this.staticRadioButton, this.styleLabel, this.systemRadioButton, this.underlinedCheckBox}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.kindLabel).addPreferredGap(0).add((Component)this.defaultRadioButton).addPreferredGap(0).add((Component)this.staticRadioButton).addPreferredGap(0).add((Component)this.inputRadioButton).addPreferredGap(0).add((Component)this.customRadioButton)).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.faceLabel).addPreferredGap(0).add((Component)this.systemRadioButton).addPreferredGap(0).add((Component)this.monospaceRadioButton).addPreferredGap(0).add((Component)this.proportionalRadioButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sizeLabel).add((Component)this.styleLabel)).addPreferredGap(0).add((Component)this.smallRadioButton).addPreferredGap(0).add((Component)this.mediumRadioButton).addPreferredGap(0).add((Component)this.largeRadioButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(20, 20, 20).add((Component)this.plainCheckBox).addPreferredGap(0).add((Component)this.boldCheckBox)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(62, 62, 62).add((Component)this.italicCheckBox))).addPreferredGap(0).add((Component)this.underlinedCheckBox)))).addPreferredGap(0).add((Component)this.jPanel2, -1, 55, Short.MAX_VALUE)));
    }

    private class StyleActionListener
    implements ActionListener {
        private StyleActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            if (object == FontEditorElement.this.plainCheckBox) {
                if (FontEditorElement.this.plainCheckBox.isSelected()) {
                    FontEditorElement.this.boldCheckBox.setSelected(false);
                    FontEditorElement.this.italicCheckBox.setSelected(false);
                    FontEditorElement.this.underlinedCheckBox.setSelected(false);
                }
            } else {
                FontEditorElement.this.plainCheckBox.setSelected(!FontEditorElement.this.boldCheckBox.isSelected() && !FontEditorElement.this.italicCheckBox.isSelected() && !FontEditorElement.this.underlinedCheckBox.isSelected());
                if (FontEditorElement.this.boldCheckBox.isSelected()) {
                    n |= 1;
                }
                if (FontEditorElement.this.italicCheckBox.isSelected()) {
                    n |= 2;
                }
                if (FontEditorElement.this.underlinedCheckBox.isSelected()) {
                    n |= 4;
                }
            }
            FontEditorElement.this.currentStub.setStyle(n);
            FontEditorElement.this.setSampleFont(false);
            FontEditorElement.this.fireElementChanged(FontEditorElement.this.currentStub.getComponentID(), "style", MidpTypes.createIntegerValue(n));
        }
    }

    private class FaceActionListener
    implements ActionListener {
        private FaceActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            if (object == FontEditorElement.this.monospaceRadioButton) {
                n = 32;
            } else if (object == FontEditorElement.this.proportionalRadioButton) {
                n = 64;
            }
            FontEditorElement.this.currentStub.setFace(n);
            FontEditorElement.this.setSampleFont(false);
            FontEditorElement.this.fireElementChanged(FontEditorElement.this.currentStub.getComponentID(), "face", MidpTypes.createIntegerValue(n));
        }
    }

    private class SizeActionListener
    implements ActionListener {
        private SizeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            if (object == FontEditorElement.this.smallRadioButton) {
                n = 8;
            } else if (object == FontEditorElement.this.largeRadioButton) {
                n = 16;
            }
            FontEditorElement.this.currentStub.setSize(n);
            FontEditorElement.this.setSampleFont(false);
            FontEditorElement.this.fireElementChanged(FontEditorElement.this.currentStub.getComponentID(), "bold", MidpTypes.createIntegerValue(n));
        }
    }

    private class KindActionListener
    implements ActionListener {
        private KindActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            if (object == FontEditorElement.this.customRadioButton) {
                FontEditorElement.this.setFaceSizeStyleEnabled(true);
                n = 1;
            } else if (object == FontEditorElement.this.defaultRadioButton) {
                FontEditorElement.this.setFaceSizeStyleEnabled(false);
                n = 0;
            } else if (object == FontEditorElement.this.staticRadioButton) {
                FontEditorElement.this.setFaceSizeStyleEnabled(false);
                n = 2;
            } else if (object == FontEditorElement.this.inputRadioButton) {
                FontEditorElement.this.setFaceSizeStyleEnabled(false);
                n = 3;
            }
            FontEditorElement.this.currentStub.setKind(n);
            FontEditorElement.this.setSampleFont(false);
            FontEditorElement.this.fireElementChanged(FontEditorElement.this.currentStub.getComponentID(), "fontKind", MidpTypes.createIntegerValue(n));
        }
    }

    private static class FontStub {
        private long componentID;
        private int kind;
        private int face;
        private int style;
        private int size;
        private boolean isChanged;

        public FontStub(long l, int n, int n2, int n3, int n4) {
            this.componentID = l;
            this.kind = n;
            this.face = n2;
            this.style = n3;
            this.size = n4;
        }

        public long getComponentID() {
            return this.componentID;
        }

        public boolean isChanged() {
            return this.isChanged;
        }

        public void setWasChanged(boolean bl) {
            this.isChanged = bl;
        }

        public int getKind() {
            return this.kind;
        }

        public void setKind(int n) {
            this.kind = n;
        }

        public int getFace() {
            return this.face;
        }

        public void setFace(int n) {
            this.face = n;
        }

        public int getStyle() {
            return this.style;
        }

        public void setStyle(int n) {
            this.style = n;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int n) {
            this.size = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[componentID=");
            stringBuffer.append(this.componentID);
            stringBuffer.append(", kind=");
            stringBuffer.append(this.kind);
            stringBuffer.append(", face=");
            stringBuffer.append(this.face);
            stringBuffer.append(", style=");
            stringBuffer.append(this.style);
            stringBuffer.append(", size=");
            stringBuffer.append(this.size);
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

