/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.date;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorDate
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final DateFormat FORMAT_DATE_TIME = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final DateFormat FORMAT_DATE = new SimpleDateFormat("dd.MM.yyyy");
    private static final DateFormat FORMAT_TIME = new SimpleDateFormat("HH:mm:ss");
    private static final String NON_DATE_TIME_TEXT = NbBundle.getMessage(PropertyEditorDate.class, (String)"MSG_NON_DATE_TIME");
    private static final String NON_DATE_TEXT = NbBundle.getMessage(PropertyEditorDate.class, (String)"MSG_NON_DATE");
    private static final String NON_TIME_TEXT = NbBundle.getMessage(PropertyEditorDate.class, (String)"MSG_NON_TIME");
    private CustomEditor customEditor;
    private JRadioButton radioButton;

    private PropertyEditorDate() {
        super(NbBundle.getMessage(PropertyEditorDate.class, (String)"LBL_DATE_UCLABEL"));
        this.initComponents();
        this.initElements(Collections.singleton(this));
    }

    public static final DesignPropertyEditor createInstance() {
        return new PropertyEditorDate();
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorDate.class, (String)"LBL_DATE_STR"));
        this.customEditor = new CustomEditor();
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return false;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        return this.getValueAsText((PropertyValue)super.getValue());
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setText(null);
        } else {
            this.customEditor.setText(this.getValueAsText(propertyValue));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        int n = this.getInputMode();
        try {
            Date date = this.getFormatter(n).parse(string);
            super.setValue((Object)MidpTypes.createLongValue(date.getTime()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    private String getValueAsText(PropertyValue propertyValue) {
        Date date = new Date();
        Object object = propertyValue.getPrimitiveValue();
        date.setTime((Long)object);
        int n = this.getInputMode();
        return this.getFormatter(n).format(date);
    }

    private DateFormat getFormatter(int n) {
        if (n == 1) {
            return FORMAT_DATE;
        }
        if (n == 2) {
            return FORMAT_TIME;
        }
        return FORMAT_DATE_TIME;
    }

    private int getInputMode() {
        final int[] nArray = new int[]{3};
        if (this.component != null && this.component.get() != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = designComponent.readProperty("inputMode");
                    if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                        nArray[0] = MidpTypes.getInteger(propertyValue);
                    }
                }
            });
        }
        return nArray[0];
    }

    private class CustomEditor
    extends JPanel
    implements DocumentListener,
    FocusListener {
        private JTextField textField;

        public CustomEditor() {
            PropertyEditorDate.this.radioButton.addFocusListener(this);
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
            this.add((Component)this.textField, "Center");
        }

        public void setText(String string) {
            this.textField.setText(string);
        }

        public String getText() {
            return this.textField.getText();
        }

        public void checkDateStatus() {
            int n = PropertyEditorDate.this.getInputMode();
            try {
                PropertyEditorDate.this.getFormatter(n).parse(this.textField.getText());
                PropertyEditorDate.this.clearErrorStatus();
            }
            catch (ParseException parseException) {
                PropertyEditorDate.this.displayWarning(this.getMessage(n));
            }
        }

        private String getMessage(int n) {
            if (n == 1) {
                return NON_DATE_TEXT;
            }
            if (n == 2) {
                return NON_TIME_TEXT;
            }
            return NON_DATE_TIME_TEXT;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorDate.this.radioButton.setSelected(true);
                this.checkDateStatus();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorDate.this.radioButton.setSelected(true);
                this.checkDateStatus();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == PropertyEditorDate.this.radioButton || focusEvent.getSource() == this.textField) {
                this.checkDateStatus();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            PropertyEditorDate.this.clearErrorStatus();
        }
    }
}

