/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.util.NbBundle;

public class PropertyEditorVersion
extends DesignPropertyEditor {
    private final CustomEditor customEditor = new CustomEditor();

    private PropertyEditorVersion() {
    }

    public static final PropertyEditorVersion createInstance() {
        return new PropertyEditorVersion();
    }

    public Component getCustomEditor() {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (propertyValue != null && propertyValue.getKind() != PropertyValue.Kind.NULL) {
            this.customEditor.setText((String)propertyValue.getPrimitiveValue());
        }
        return this.customEditor;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Boolean canEditAsText() {
        return false;
    }

    public String getAsText() {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (propertyValue == null || propertyValue.getKind() == PropertyValue.Kind.NULL) {
            return PropertyEditorUserCode.NULL_TEXT;
        }
        return (String)propertyValue.getPrimitiveValue();
    }

    public void setAsText(String string) {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        if (propertyValue != null && propertyValue.getPrimitiveValue().equals(string)) {
            return;
        }
        if (!PropertyEditorUserCode.NULL_TEXT.equals(string)) {
            this.saveValue(string);
        }
    }

    private void saveValue(String string) {
        if (string.length() > 0) {
            super.setValue((Object)MidpTypes.createStringValue(string));
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        this.saveValue(this.customEditor.getText());
    }

    public boolean supportsDefaultValue() {
        return false;
    }

    private final class CustomEditor
    extends JPanel {
        private JTextField textField;

        public CustomEditor() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel(NbBundle.getMessage(PropertyEditorVersion.class, (String)"LBL_VERSION_STR"));
            gridBagConstraints.insets = new Insets(12, 12, 12, 6);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 1;
            this.add((Component)jLabel, gridBagConstraints);
            this.textField = new JTextField();
            gridBagConstraints.insets = new Insets(12, 6, 12, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 1;
            this.add((Component)this.textField, gridBagConstraints);
            this.setPreferredSize(new Dimension(300, 40));
        }

        public void setText(String string) {
            this.textField.setText(string);
        }

        public String getText() {
            return this.textField.getText();
        }
    }
}

