/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorInputMode
extends PropertyEditorUserCode {
    private static final String[] PREDEFINED_INPUT_MODES = new String[]{"UCB_BASIC_LATIN", "UCB_GREEK", "UCB_CYRILLIC", "UCB_ARMENIAN", "UCB_HEBREW", "UCB_ARABIC", "UCB_DEVANAGARI", "UCB_BENGALI", "UCB_THAI", "UCB_HIRAGANA", "UCB_KATAKANA", "UCB_HANGUL_SYLLABLES"};
    private List<PropertyEditorElement> elements = new ArrayList<PropertyEditorElement>(2);

    private PropertyEditorInputMode() {
        super(NbBundle.getMessage(PropertyEditorInputMode.class, (String)"LBL_INPUT_MODE_UCLABEL"));
        this.elements.add(new PredefinedEditor());
        this.elements.add(new CustomEditor());
        this.initElements(this.elements);
    }

    public static final PropertyEditorInputMode createInstance() {
        return new PropertyEditorInputMode();
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return (String)propertyValue.getPrimitiveValue();
    }

    private void saveValue(String string) {
        if (string.length() > 0) {
            super.setValue((Object)MidpTypes.createStringValue(string));
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        for (PropertyEditorElement propertyEditorElement : this.elements) {
            if (!propertyEditorElement.getRadioButton().isSelected()) continue;
            this.saveValue(propertyEditorElement.getTextForPropertyValue());
            break;
        }
    }

    private boolean isPredefined(String string) {
        for (String string2 : PREDEFINED_INPUT_MODES) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private final class CustomEditor
    implements PropertyEditorElement,
    DocumentListener {
        private JRadioButton radioButton = new JRadioButton();
        private JTextField textField;

        public CustomEditor() {
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorInputMode.class, (String)"LBL_CUSTOM"));
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(this);
        }

        public void updateState(PropertyValue propertyValue) {
            if (!PropertyEditorInputMode.this.isCurrentValueANull() && propertyValue != null) {
                String string = (String)propertyValue.getPrimitiveValue();
                if (!PropertyEditorInputMode.this.isPredefined(string)) {
                    this.textField.setText(string);
                }
            } else {
                this.textField.setText(null);
            }
        }

        public void setTextForPropertyValue(String string) {
            PropertyEditorInputMode.this.saveValue(string);
        }

        public String getTextForPropertyValue() {
            return this.textField.getText();
        }

        public JComponent getCustomEditorComponent() {
            return this.textField;
        }

        public JRadioButton getRadioButton() {
            return this.radioButton;
        }

        public boolean isInitiallySelected() {
            return false;
        }

        public boolean isVerticallyResizable() {
            return false;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                this.radioButton.setSelected(true);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                this.radioButton.setSelected(true);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private final class PredefinedEditor
    implements PropertyEditorElement,
    ActionListener {
        private JRadioButton radioButton = new JRadioButton();
        private DefaultComboBoxModel model;
        private JComboBox combobox;

        public PredefinedEditor() {
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorInputMode.class, (String)"LBL_PREDEFINED"));
            this.model = new DefaultComboBoxModel<String>(PREDEFINED_INPUT_MODES);
            this.combobox = new JComboBox(this.model);
            this.combobox.addActionListener(this);
        }

        public void updateState(PropertyValue propertyValue) {
            if (!PropertyEditorInputMode.this.isCurrentValueANull() && propertyValue != null) {
                for (int i = 0; i < this.model.getSize(); ++i) {
                    String string = (String)this.model.getElementAt(i);
                    if (!string.equals((String)propertyValue.getPrimitiveValue())) continue;
                    this.model.setSelectedItem(string);
                    break;
                }
            }
        }

        public void setTextForPropertyValue(String string) {
            PropertyEditorInputMode.this.saveValue(string);
        }

        public String getTextForPropertyValue() {
            return (String)this.combobox.getSelectedItem();
        }

        public JComponent getCustomEditorComponent() {
            return this.combobox;
        }

        public JRadioButton getRadioButton() {
            return this.radioButton;
        }

        public boolean isInitiallySelected() {
            return true;
        }

        public boolean isVerticallyResizable() {
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.radioButton.setSelected(true);
        }
    }
}

