/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.Bitmask;
import org.netbeans.modules.vmd.midp.components.items.Constraints;
import org.netbeans.modules.vmd.midp.propertyeditors.Bundle;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorConstraints
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private CustomEditorConstraints customEditor;
    private JRadioButton radioButton;

    private PropertyEditorConstraints() {
        super(NbBundle.getMessage(PropertyEditorConstraints.class, (String)"LBL_CONSTR_UCLABEL"));
        this.initComponents();
        this.initElements(Collections.singleton(this));
    }

    public static final PropertyEditorConstraints createInstance() {
        return new PropertyEditorConstraints();
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorConstraints.class, (String)"LBL_CONSTR_STR"));
        this.customEditor = new CustomEditorConstraints(0);
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return true;
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        this.customEditor.setBitmask(MidpTypes.getInteger((PropertyValue)super.getValue()));
        return this.customEditor.getBitmaskAsText();
    }

    public void setTextForPropertyValue(String string) {
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setBitmask(0);
        } else {
            this.customEditor.setBitmask(MidpTypes.getInteger(propertyValue));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue() {
        super.setValue((Object)MidpTypes.createIntegerValue(this.customEditor.getBitMask()));
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue();
        }
    }

    public Boolean canEditAsText() {
        return false;
    }

    private class CustomEditorConstraints
    extends JPanel
    implements ItemListener {
        private Constraints constraints;
        private Map<JToggleButton, Bitmask.BitmaskItem> radioButtonsMap;
        private Map<JToggleButton, Bitmask.BitmaskItem> checkBoxesMap;
        private List<JToggleButton> guiItems;
        private JRadioButton anyRadioButton;
        private JCheckBox passwordCheckBox;
        private int bitMask;

        public CustomEditorConstraints(int n) {
            this.constraints = new Constraints(n);
            this.radioButtonsMap = new HashMap<JToggleButton, Bitmask.BitmaskItem>();
            this.checkBoxesMap = new HashMap<JToggleButton, Bitmask.BitmaskItem>();
            this.guiItems = new ArrayList<JToggleButton>();
            this.bitMask = n;
            this.initComponents();
        }

        private void initComponents() {
            ButtonGroup buttonGroup = new ButtonGroup();
            this.setLayout(new GridLayout(6, 2));
            this.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PNL_TEXTFIELDPE_NAME")));
            this.anyRadioButton = new JRadioButton(this.constraints.getBitmaskItem(0).getDisplayName());
            this.anyRadioButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_ANY"));
            buttonGroup.add(this.anyRadioButton);
            this.radioButtonsMap.put(this.anyRadioButton, this.constraints.getBitmaskItem(0));
            this.guiItems.add(this.anyRadioButton);
            this.add(this.anyRadioButton);
            this.passwordCheckBox = new JCheckBox(this.constraints.getBitmaskItem(65536).getDisplayName());
            this.passwordCheckBox.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_PASSWORD"));
            this.checkBoxesMap.put(this.passwordCheckBox, this.constraints.getBitmaskItem(65536));
            this.guiItems.add(this.passwordCheckBox);
            this.add(this.passwordCheckBox);
            JToggleButton jToggleButton = new JRadioButton(this.constraints.getBitmaskItem(2).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_NUMERIC"));
            buttonGroup.add(jToggleButton);
            this.radioButtonsMap.put(jToggleButton, this.constraints.getBitmaskItem(2));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton = new JCheckBox(this.constraints.getBitmaskItem(131072).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_UNEDITABLE"));
            this.checkBoxesMap.put(jToggleButton, this.constraints.getBitmaskItem(131072));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton = new JRadioButton(this.constraints.getBitmaskItem(1).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_EMAIL"));
            buttonGroup.add(jToggleButton);
            this.radioButtonsMap.put(jToggleButton, this.constraints.getBitmaskItem(1));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton = new JCheckBox(this.constraints.getBitmaskItem(262144).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_SENSITIVE"));
            this.checkBoxesMap.put(jToggleButton, this.constraints.getBitmaskItem(262144));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton = new JRadioButton(this.constraints.getBitmaskItem(3).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_PHONE"));
            buttonGroup.add(jToggleButton);
            this.radioButtonsMap.put(jToggleButton, this.constraints.getBitmaskItem(3));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton = new JCheckBox(this.constraints.getBitmaskItem(524288).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_NONPREDICTIVE"));
            this.checkBoxesMap.put(jToggleButton, this.constraints.getBitmaskItem(524288));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton = new JRadioButton(this.constraints.getBitmaskItem(4).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_URL"));
            buttonGroup.add(jToggleButton);
            this.radioButtonsMap.put(jToggleButton, this.constraints.getBitmaskItem(4));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton = new JCheckBox(this.constraints.getBitmaskItem(0x100000).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_CAPS_WORD"));
            this.checkBoxesMap.put(jToggleButton, this.constraints.getBitmaskItem(0x100000));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton = new JRadioButton(this.constraints.getBitmaskItem(5).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_DECIMAL"));
            buttonGroup.add(jToggleButton);
            this.radioButtonsMap.put(jToggleButton, this.constraints.getBitmaskItem(5));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton = new JCheckBox(this.constraints.getBitmaskItem(0x200000).getDisplayName());
            jToggleButton.setMnemonic(Bundle.getChar("MNM_TEXTFIELDPE_CAPS_SENTENCE"));
            this.checkBoxesMap.put(jToggleButton, this.constraints.getBitmaskItem(0x200000));
            this.guiItems.add(jToggleButton);
            this.add(jToggleButton);
            this.setGui();
            for (JToggleButton jToggleButton2 : this.guiItems) {
                jToggleButton2.addItemListener(this);
            }
        }

        public void setBitmask(int n) {
            for (JToggleButton jToggleButton : this.guiItems) {
                jToggleButton.removeItemListener(this);
            }
            this.constraints.setBitmask(n);
            this.setGui();
            for (JToggleButton jToggleButton : this.guiItems) {
                jToggleButton.addItemListener(this);
            }
            this.bitMask = n;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.constraints.setBitmask(0);
            for (JToggleButton jToggleButton : this.radioButtonsMap.keySet()) {
                if (!jToggleButton.isSelected()) continue;
                this.constraints.addToBitmask(this.radioButtonsMap.get(jToggleButton), true);
            }
            for (JToggleButton jToggleButton : this.checkBoxesMap.keySet()) {
                if (!jToggleButton.isSelected()) continue;
                this.constraints.addToBitmask(this.checkBoxesMap.get(jToggleButton), true);
            }
            this.bitMask = this.constraints.getBitmask();
        }

        private void setGui() {
            int n = 0;
            for (JToggleButton jToggleButton : this.radioButtonsMap.keySet()) {
                if (!this.constraints.isSet(this.radioButtonsMap.get(jToggleButton)) || n > this.radioButtonsMap.get(jToggleButton).getAffectedBits()) continue;
                n = this.radioButtonsMap.get(jToggleButton).getAffectedBits();
                jToggleButton.setSelected(true);
            }
            for (JToggleButton jToggleButton : this.checkBoxesMap.keySet()) {
                if (!this.constraints.isSet(this.checkBoxesMap.get(jToggleButton))) continue;
                jToggleButton.setSelected(true);
            }
        }

        public int getBitMask() {
            return this.bitMask;
        }

        public String getBitmaskAsText() {
            int n = 0;
            StringBuffer stringBuffer = null;
            for (JToggleButton jToggleButton : this.radioButtonsMap.keySet()) {
                if (!this.constraints.isSet(this.radioButtonsMap.get(jToggleButton)) || n > this.radioButtonsMap.get(jToggleButton).getAffectedBits()) continue;
                n = this.radioButtonsMap.get(jToggleButton).getAffectedBits();
                stringBuffer = new StringBuffer(this.radioButtonsMap.get(jToggleButton).getName());
            }
            for (JToggleButton jToggleButton : this.checkBoxesMap.keySet()) {
                if (!this.constraints.isSet(this.checkBoxesMap.get(jToggleButton))) continue;
                stringBuffer.append(" | ");
                stringBuffer.append(this.checkBoxesMap.get(jToggleButton).getName());
            }
            return stringBuffer.toString();
        }
    }
}

