/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptPresenter;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;

public class MidpAcceptProducerKindPresenter
extends AcceptPresenter {
    private Map<TypeID, String> typesMap;
    private TypeID currentType;

    public MidpAcceptProducerKindPresenter() {
        super(AcceptPresenter.Kind.COMPONENT_PRODUCER);
    }

    public MidpAcceptProducerKindPresenter addType(TypeID typeID, String string) {
        if (typeID == null || string == null || string.length() == 0) {
            throw new IllegalArgumentException("Illegal argument type or properytName");
        }
        if (this.typesMap != null && this.typesMap.keySet().contains(typeID)) {
            Debug.warning((Object[])new Object[]{"TypeID: " + typeID.toString() + " alredy exists in presenter: " + MidpAcceptProducerKindPresenter.class + " - component: " + this.getComponent()});
        }
        if (this.typesMap == null) {
            this.typesMap = new HashMap<TypeID, String>();
        }
        this.typesMap.put(typeID, string);
        return this;
    }

    public boolean isAcceptable(ComponentProducer componentProducer, AcceptSuggestion acceptSuggestion) {
        DescriptorRegistry descriptorRegistry = this.getComponent().getDocument().getDescriptorRegistry();
        for (TypeID typeID : this.typesMap.keySet()) {
            if (!descriptorRegistry.isInHierarchy(typeID, componentProducer.getMainComponentTypeID())) continue;
            this.currentType = typeID;
            return true;
        }
        return false;
    }

    public final ComponentProducer.Result accept(ComponentProducer componentProducer, AcceptSuggestion acceptSuggestion) {
        DesignDocument designDocument = this.getComponent().getDocument();
        DesignComponent designComponent = componentProducer.createComponent(designDocument).getMainComponent();
        MidpDocumentSupport.getCategoryComponent(designDocument, ResourcesCategoryCD.TYPEID).addComponent(designComponent);
        this.getComponent().writeProperty(this.typesMap.get(this.currentType), PropertyValue.createComponentReference((DesignComponent)designComponent));
        return new ComponentProducer.Result(new DesignComponent[]{designComponent});
    }
}

