/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.codegen;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.vmd.api.codegen.CodeNamePresenter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.ValidatorPresenter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceNameResolver {
    private InstanceNameResolver() {
    }

    public static PropertyValue createFromSuggested(DesignComponent designComponent, String string) {
        return InstanceNameResolver.createFromSuggested(designComponent, string, null);
    }

    public static PropertyValue createFromSuggested(DesignComponent designComponent, String string, Collection<String> collection) {
        assert (designComponent.getDocument().getTransactionManager().isAccess());
        Collection collection2 = designComponent.getPresenters(CodeNamePresenter.class);
        if (collection2.isEmpty()) {
            Debug.warning((Object[])new Object[]{"CodeNamePresenter is missing for", designComponent});
        }
        HashSet<String> hashSet = new HashSet<String>();
        InstanceNameResolver.gatherNames(designComponent.getDocument().getRootComponent(), designComponent, hashSet);
        if (collection != null) {
            hashSet.addAll(collection);
        }
        if (InstanceNameResolver.checkIfNameAlreadyReserved(collection2, string = InstanceNameResolver.checkForJavaIdentifierCompliant(string), hashSet)) {
            int n;
            for (n = string.length(); n >= 1 && Character.isDigit(string.charAt(n - 1)); --n) {
            }
            int n2 = n < string.length() ? Integer.parseInt(string.substring(n)) : 1;
            string = string.substring(0, n);
            string = InstanceNameResolver.findNumberedInstanceName(collection2, string, n2, hashSet);
        }
        return MidpTypes.createStringValue(string);
    }

    private static String findNumberedInstanceName(Collection<? extends CodeNamePresenter> collection, String string, int n, HashSet<String> hashSet) {
        String string2;
        while (InstanceNameResolver.checkIfNameAlreadyReserved(collection, string2 = string + n, hashSet)) {
            ++n;
        }
        return string2;
    }

    private static boolean checkIfNameAlreadyReserved(Collection<? extends CodeNamePresenter> collection, String string, HashSet<String> hashSet) {
        for (CodeNamePresenter codeNamePresenter : collection) {
            List list = codeNamePresenter.getReservedNamesFor(string);
            if (list == null) continue;
            for (String string2 : list) {
                if (!hashSet.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private static String checkForJavaIdentifierCompliant(String string) {
        if (string == null || string.length() < 1) {
            return "object";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            stringBuffer.append(string.charAt(0));
            ++n;
        } else {
            stringBuffer.append('a');
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static void gatherNames(DesignComponent designComponent, DesignComponent designComponent2, HashSet<String> hashSet) {
        assert (designComponent.getDocument().getTransactionManager().isAccess());
        if (designComponent == designComponent2) {
            return;
        }
        Collection collection = designComponent.getPresenters(CodeNamePresenter.class);
        for (CodeNamePresenter codeNamePresenter : collection) {
            List list = codeNamePresenter.getReservedNames();
            if (list == null) continue;
            hashSet.addAll(list);
        }
        for (CodeNamePresenter codeNamePresenter : designComponent.getComponents()) {
            InstanceNameResolver.gatherNames((DesignComponent)codeNamePresenter, designComponent2, hashSet);
        }
    }

    public static Presenter createValidatorPresenter() {
        return new ValidatorPresenter(){

            protected void checkCustomValidity() {
                InstanceNameResolver.checkValidity(this.getComponent().getDocument());
            }
        };
    }

    private static void checkValidity(DesignDocument designDocument) {
    }
}

