/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.analyzer;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.analyzer.Analyzer;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.analyzer.ResourcesAnalyzerPanel;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesAnalyzer
implements Analyzer {
    public String getProjectType() {
        return "vmd-midp";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ResourcesAnalyzer.class, (String)"ResourcesAnalyzer.displayName");
    }

    public String getToolTip() {
        return NbBundle.getMessage(ResourcesAnalyzer.class, (String)"ResourcesAnalyzer.toolTip");
    }

    public Image getIcon() {
        return null;
    }

    public JComponent createVisualRepresentation() {
        return new ResourcesAnalyzerPanel();
    }

    public void update(JComponent jComponent, final DesignDocument designDocument) {
        if (jComponent == null || designDocument == null) {
            return;
        }
        final ResourcesAnalyzerPanel resourcesAnalyzerPanel = (ResourcesAnalyzerPanel)jComponent;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                designDocument.getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>();
                        DesignComponent designComponent = designDocument.getRootComponent();
                        if (designComponent != null) {
                            DesignComponent designComponent2;
                            DesignComponent designComponent3 = MidpDocumentSupport.getCategoryComponent(designDocument, CommandsCategoryCD.TYPEID);
                            if (designComponent3 != null) {
                                designComponent2 = designComponent3.getComponents().iterator();
                                while (designComponent2.hasNext()) {
                                    DesignComponent designComponent4 = (DesignComponent)designComponent2.next();
                                    if (!MidpTypes.getBoolean(designComponent4.readProperty("ordinary"))) continue;
                                    arrayList.add(designComponent4);
                                }
                            }
                            if ((designComponent2 = MidpDocumentSupport.getCategoryComponent(designDocument, ResourcesCategoryCD.TYPEID)) != null) {
                                arrayList.addAll(designComponent2.getComponents());
                            }
                            ResourcesAnalyzer.this.filterResources(designComponent, arrayList);
                        }
                        resourcesAnalyzerPanel.setUnusedResources(designDocument, arrayList);
                    }
                });
            }
        });
    }

    private void filterResources(DesignComponent designComponent, Collection<DesignComponent> collection) {
        for (Object object : designComponent.getComponents()) {
            this.filterResources((DesignComponent)object, collection);
        }
        ArrayList arrayList = new ArrayList();
        for (PropertyDescriptor propertyDescriptor : designComponent.getComponentDescriptor().getPropertyDescriptors()) {
            Debug.collectAllComponentReferences((PropertyValue)designComponent.readProperty(propertyDescriptor.getName()), (Collection)arrayList);
            collection.removeAll(arrayList);
            arrayList.clear();
        }
    }
}

