/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.actions;

import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.AddActionItem;
import org.netbeans.modules.vmd.api.model.presenters.actions.AddActionPresenter;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class UnusedCommandsAddActionPresenter
extends AddActionPresenter {
    public static final String DISPLAY_NAME_ADD = NbBundle.getMessage(UnusedCommandsAddActionPresenter.class, (String)"NAME_UnusedCommandsAddActionPresenter");
    private Integer order;
    private String displayName;
    private List<Action> newAddActions;

    public static Presenter createForDisplayable(String string, int n) {
        return new UnusedCommandsAddActionPresenter(string, n){
            private DesignComponent selectedCommandSource;

            protected synchronized void insideActionPerformed(final DesignComponent designComponent) {
                DesignDocument designDocument = designComponent.getDocument();
                designDocument.getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        selectedCommandSource = MidpDocumentSupport.attachCommandToDisplayable(this.getComponent(), designComponent);
                    }
                });
                UnusedCommandsAddActionPresenter.selectComponent(this.selectedCommandSource);
                this.selectedCommandSource = null;
            }
        };
    }

    public static Presenter createForItem(String string, int n) {
        return new UnusedCommandsAddActionPresenter(string, n){
            private DesignComponent selectedCommandSource;

            protected synchronized void insideActionPerformed(final DesignComponent designComponent) {
                DesignDocument designDocument = designComponent.getDocument();
                designDocument.getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        selectedCommandSource = MidpDocumentSupport.attachCommandToItem(this.getComponent(), designComponent);
                    }
                });
                UnusedCommandsAddActionPresenter.selectComponent(this.selectedCommandSource);
                this.selectedCommandSource = null;
            }
        };
    }

    private static void selectComponent(final DesignComponent designComponent) {
        final DesignDocument designDocument = designComponent.getDocument();
        designDocument.getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                designDocument.setSelectedComponents(null, Collections.singleton(designComponent));
            }
        });
    }

    private UnusedCommandsAddActionPresenter(String string, int n) {
        this.order = n;
        this.displayName = string;
    }

    protected abstract void insideActionPerformed(DesignComponent var1);

    public String getName() {
        return this.displayName;
    }

    public Integer getOrder() {
        return this.order;
    }

    public AddActionItem[] getAddActionItems() {
        if (this.newAddActions == null) {
            this.newAddActions = new ArrayList<Action>();
        } else {
            this.newAddActions.clear();
        }
        Collection<DesignComponent> collection = MidpDocumentSupport.getAvailableCommandsForComponent(this.getComponent());
        if (collection == null) {
            return null;
        }
        for (DesignComponent designComponent : collection) {
            InfoPresenter infoPresenter = (InfoPresenter)designComponent.getPresenter(InfoPresenter.class);
            if (infoPresenter == null) {
                throw new IllegalStateException("No Info Presenter for component: " + designComponent);
            }
            AddActionItem addActionItem = UnusedCommandsAddActionPresenter.createUnusedCommandAction(new WeakReference<DesignComponent>(designComponent), new WeakReference<InfoPresenter>(infoPresenter), new WeakReference<UnusedCommandsAddActionPresenter>(this));
            addActionItem.resolveAction(this.getComponent());
            this.newAddActions.add((Action)addActionItem);
        }
        return this.newAddActions.toArray(new AddActionItem[this.newAddActions.size()]);
    }

    private static AddActionItem createUnusedCommandAction(final WeakReference<DesignComponent> weakReference, final WeakReference<InfoPresenter> weakReference2, final WeakReference<UnusedCommandsAddActionPresenter> weakReference3) {
        return new AddActionItem(((DesignComponent)weakReference.get()).getType()){
            private ImageIcon icon;

            public void actionPerformed(ActionEvent actionEvent) {
                ((UnusedCommandsAddActionPresenter)((Object)weakReference3.get())).insideActionPerformed((DesignComponent)weakReference.get());
            }

            public void resolveAction(DesignComponent designComponent) {
                InfoPresenter infoPresenter = (InfoPresenter)weakReference2.get();
                this.icon = this.icon == null ? (this.icon = new ImageIcon(infoPresenter.getIcon(InfoPresenter.IconType.COLOR_16x16))) : this.icon;
                this.putValue("Name", infoPresenter.getDisplayName(InfoPresenter.NameType.PRIMARY));
                this.putValue("SmallIcon", this.icon);
            }
        };
    }
}

