/*
 * Decompiled with CFR 0.152.
 */
package jdbc_adapter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import jdbc_adapter.JdbcConnectionFactory;
import jdbc_adapter.JdbcDerbySpec;
import jdbc_adapter.JdbcMySQLSpec;
import jdbc_adapter.SQLBlock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.util.ByteList;

public class JdbcAdapterInternalService
implements BasicLibraryService {
    private static RubyObjectAdapter rubyApi;
    private static final Pattern HAS_SMALL;
    private static final DateFormat FORMAT;

    public boolean basicLoad(Ruby ruby) throws IOException {
        RubyClass rubyClass = ((RubyModule)ruby.getModule("ActiveRecord").getConstant("ConnectionAdapters")).defineClassUnder("JdbcConnection", ruby.getObject(), ruby.getObject().getAllocator());
        rubyClass.defineAnnotatedMethods(JdbcAdapterInternalService.class);
        RubyModule rubyModule = ruby.getOrCreateModule("JdbcSpec");
        rubyApi = JavaEmbedUtils.newObjectAdapter();
        JdbcMySQLSpec.load(rubyModule);
        JdbcDerbySpec.load(rubyModule, rubyApi);
        return true;
    }

    private static int whitespace(int n, int n2, ByteList byteList) {
        block3: while (n < n2) {
            switch (byteList.bytes[n]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ++n;
                    continue block3;
                }
            }
            return n;
        }
        return n;
    }

    @JRubyMethod(name={"insert?"}, required=1, meta=true)
    public static IRubyObject insert_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ByteList byteList = rubyApi.convertToRubyString(iRubyObject2).getByteList();
        int n = byteList.begin;
        int n2 = n + byteList.realSize;
        if (n2 - (n = JdbcAdapterInternalService.whitespace(n, n2, byteList)) >= 6) {
            switch (byteList.bytes[n++]) {
                case 73: 
                case 105: {
                    switch (byteList.bytes[n++]) {
                        case 78: 
                        case 110: {
                            switch (byteList.bytes[n++]) {
                                case 83: 
                                case 115: {
                                    switch (byteList.bytes[n++]) {
                                        case 69: 
                                        case 101: {
                                            switch (byteList.bytes[n++]) {
                                                case 82: 
                                                case 114: {
                                                    switch (byteList.bytes[n++]) {
                                                        case 84: 
                                                        case 116: {
                                                            return iRubyObject.getRuntime().getTrue();
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return iRubyObject.getRuntime().getFalse();
    }

    @JRubyMethod(name={"select?"}, required=1, meta=true)
    public static IRubyObject select_p(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ByteList byteList = rubyApi.convertToRubyString(iRubyObject2).getByteList();
        int n = byteList.begin;
        int n2 = n + byteList.realSize;
        if (n2 - (n = JdbcAdapterInternalService.whitespace(n, n2, byteList)) >= 6) {
            if (byteList.bytes[n] == 40) {
                ++n;
                n = JdbcAdapterInternalService.whitespace(n, n2, byteList);
            }
            if (n2 - n >= 6) {
                switch (byteList.bytes[n++]) {
                    case 83: 
                    case 115: {
                        switch (byteList.bytes[n++]) {
                            case 69: 
                            case 101: {
                                switch (byteList.bytes[n++]) {
                                    case 76: 
                                    case 108: {
                                        switch (byteList.bytes[n++]) {
                                            case 69: 
                                            case 101: {
                                                switch (byteList.bytes[n++]) {
                                                    case 67: 
                                                    case 99: {
                                                        switch (byteList.bytes[n++]) {
                                                            case 84: 
                                                            case 116: {
                                                                return iRubyObject.getRuntime().getTrue();
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            case 72: 
                            case 104: {
                                switch (byteList.bytes[n++]) {
                                    case 79: 
                                    case 111: {
                                        switch (byteList.bytes[n++]) {
                                            case 87: 
                                            case 119: {
                                                return iRubyObject.getRuntime().getTrue();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return iRubyObject.getRuntime().getFalse();
    }

    @JRubyMethod(name={"connection"})
    public static IRubyObject connection(IRubyObject iRubyObject) {
        Connection connection = JdbcAdapterInternalService.getConnection(iRubyObject);
        if (connection == null) {
            JdbcAdapterInternalService.reconnect(iRubyObject);
        }
        return rubyApi.getInstanceVariable(iRubyObject, "@connection");
    }

    @JRubyMethod(name={"disconnect!"})
    public static IRubyObject disconnect(IRubyObject iRubyObject) {
        JdbcAdapterInternalService.setConnection(iRubyObject, null);
        return iRubyObject;
    }

    @JRubyMethod(name={"reconnect!"})
    public static IRubyObject reconnect(IRubyObject iRubyObject) {
        JdbcAdapterInternalService.setConnection(iRubyObject, JdbcAdapterInternalService.getConnectionFactory(iRubyObject).newConnection());
        return iRubyObject;
    }

    @JRubyMethod(name={"with_connection_retry_guard"}, frame=true)
    public static IRubyObject with_connection_retry_guard(final IRubyObject iRubyObject, final Block block) {
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, new SQLBlock(){

            public IRubyObject call(Connection connection) throws SQLException {
                return block.call(iRubyObject.getRuntime().getCurrentContext(), new IRubyObject[]{JdbcAdapterInternalService.wrappedConnection(iRubyObject, connection)});
            }
        });
    }

    private static IRubyObject withConnectionAndRetry(IRubyObject iRubyObject, SQLBlock sQLBlock) {
        int n = 1;
        Throwable throwable = null;
        for (int i = 0; i < n; ++i) {
            Connection connection = JdbcAdapterInternalService.getConnection(iRubyObject);
            try {
                return sQLBlock.call(connection);
            }
            catch (Exception exception) {
                for (throwable = exception; throwable.getCause() != null && throwable.getCause() != throwable; throwable = throwable.getCause()) {
                }
                if (i == 0 && (n = (int)rubyApi.convertToRubyInteger(JdbcAdapterInternalService.config_value(iRubyObject, "retry_count")).getLongValue()) <= 0) {
                    n = 1;
                }
                if (JdbcAdapterInternalService.isConnectionBroken(iRubyObject, connection)) {
                    JdbcAdapterInternalService.reconnect(iRubyObject);
                    continue;
                }
                throw JdbcAdapterInternalService.wrap(iRubyObject, throwable);
            }
        }
        throw JdbcAdapterInternalService.wrap(iRubyObject, throwable);
    }

    private static SQLBlock tableLookupBlock(final Ruby ruby, final String string, final String string2, final String string3, final String[] stringArray) {
        return new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(Connection connection) throws SQLException {
                ResultSet resultSet = null;
                try {
                    String string4;
                    Object object;
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String string22 = databaseMetaData.getClass().getName().toLowerCase();
                    boolean bl = string22.indexOf("oracle") != -1 || string22.indexOf("oci") != -1;
                    String string32 = string2;
                    if (string32 == null && bl) {
                        object = databaseMetaData.getSchemas();
                        string4 = databaseMetaData.getUserName();
                        while (object.next()) {
                            if (!object.getString(1).equalsIgnoreCase(string4)) continue;
                            string32 = object.getString(1);
                            break;
                        }
                        object.close();
                    }
                    resultSet = databaseMetaData.getTables(string, string32, string3, stringArray);
                    object = new ArrayList();
                    while (resultSet.next()) {
                        string4 = resultSet.getString(3).toLowerCase();
                        if (bl && string4.startsWith("bin$")) continue;
                        object.add(RubyString.newUnicodeString((Ruby)ruby, (String)string4));
                    }
                    string4 = ruby.newArray((List)object);
                    return string4;
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    @JRubyMethod(name={"tables"}, rest=true)
    public static IRubyObject tables(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        String string = JdbcAdapterInternalService.getCatalog(iRubyObjectArray);
        String string2 = JdbcAdapterInternalService.getSchemaPattern(iRubyObjectArray);
        String string3 = JdbcAdapterInternalService.getTablePattern(iRubyObjectArray);
        String[] stringArray = JdbcAdapterInternalService.getTypes(iRubyObjectArray);
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, JdbcAdapterInternalService.tableLookupBlock(ruby, string, string2, string3, stringArray));
    }

    private static String getCatalog(IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray != null && iRubyObjectArray.length > 0) {
            return JdbcAdapterInternalService.convertToStringOrNull(iRubyObjectArray[0]);
        }
        return null;
    }

    private static String getSchemaPattern(IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray != null && iRubyObjectArray.length > 1) {
            return JdbcAdapterInternalService.convertToStringOrNull(iRubyObjectArray[1]);
        }
        return null;
    }

    private static String getTablePattern(IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray != null && iRubyObjectArray.length > 2) {
            return JdbcAdapterInternalService.convertToStringOrNull(iRubyObjectArray[2]);
        }
        return null;
    }

    private static String[] getTypes(IRubyObject[] iRubyObjectArray) {
        String[] stringArray = new String[]{"TABLE"};
        if (iRubyObjectArray != null && iRubyObjectArray.length > 3) {
            IRubyObject iRubyObject = iRubyObjectArray[3];
            if (iRubyObject instanceof RubyArray) {
                IRubyObject[] iRubyObjectArray2 = rubyApi.convertToJavaArray(iRubyObject);
                stringArray = new String[iRubyObjectArray2.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = iRubyObjectArray2[i].toString();
                }
            } else {
                stringArray = new String[]{stringArray.toString()};
            }
        }
        return stringArray;
    }

    @JRubyMethod(name={"native_database_types"})
    public static IRubyObject native_database_types(IRubyObject iRubyObject) {
        return rubyApi.getInstanceVariable(iRubyObject, "@tps");
    }

    @JRubyMethod(name={"set_native_database_types"})
    public static IRubyObject set_native_database_types(IRubyObject iRubyObject) throws SQLException, IOException {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject2 = JdbcAdapterInternalService.unmarshal_result_downcase(iRubyObject, JdbcAdapterInternalService.getConnection(iRubyObject).getMetaData().getTypeInfo());
        IRubyObject iRubyObject3 = ((RubyModule)ruby.getModule("ActiveRecord").getConstant("ConnectionAdapters")).getConstant("JdbcTypeConverter");
        IRubyObject iRubyObject4 = rubyApi.callMethod(rubyApi.callMethod(iRubyObject3, "new", iRubyObject2), "choose_best_types");
        rubyApi.setInstanceVariable(iRubyObject, "@native_types", iRubyObject4);
        return ruby.getNil();
    }

    @JRubyMethod(name={"database_name"})
    public static IRubyObject database_name(IRubyObject iRubyObject) throws SQLException {
        String string = JdbcAdapterInternalService.getConnection(iRubyObject).getCatalog();
        if (null == string && null == (string = JdbcAdapterInternalService.getConnection(iRubyObject).getMetaData().getUserName())) {
            string = "db1";
        }
        return iRubyObject.getRuntime().newString(string);
    }

    @JRubyMethod(name={"begin"})
    public static IRubyObject begin(IRubyObject iRubyObject) throws SQLException {
        JdbcAdapterInternalService.getConnection(iRubyObject).setAutoCommit(false);
        return iRubyObject.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"commit"})
    public static IRubyObject commit(IRubyObject iRubyObject) throws SQLException {
        try {
            JdbcAdapterInternalService.getConnection(iRubyObject).commit();
            IRubyObject iRubyObject2 = iRubyObject.getRuntime().getNil();
            return iRubyObject2;
        }
        finally {
            JdbcAdapterInternalService.getConnection(iRubyObject).setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"rollback"})
    public static IRubyObject rollback(IRubyObject iRubyObject) throws SQLException {
        try {
            JdbcAdapterInternalService.getConnection(iRubyObject).rollback();
            IRubyObject iRubyObject2 = iRubyObject.getRuntime().getNil();
            return iRubyObject2;
        }
        finally {
            JdbcAdapterInternalService.getConnection(iRubyObject).setAutoCommit(true);
        }
    }

    @JRubyMethod(name={"columns", "columns_internal"}, required=1, optional=2)
    public static IRubyObject columns_internal(final IRubyObject iRubyObject, final IRubyObject[] iRubyObjectArray) throws SQLException, IOException {
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(Connection connection) throws SQLException {
                ResultSet resultSet = null;
                try {
                    String string;
                    ResultSet resultSet2;
                    boolean bl;
                    DatabaseMetaData databaseMetaData;
                    String string2;
                    String string3 = rubyApi.convertToRubyString(iRubyObjectArray[0]).getUnicodeValue();
                    String string4 = null;
                    if (string3.indexOf(".") != -1) {
                        string4 = string3.substring(string3.indexOf(".") + 1);
                        string3 = string3.substring(0, string3.indexOf(".") + 1);
                    }
                    boolean bl2 = (string2 = (databaseMetaData = connection.getMetaData()).getClass().getName().toLowerCase()).indexOf("derby") != -1;
                    boolean bl3 = bl = string2.indexOf("oracle") != -1 || string2.indexOf("oci") != -1;
                    if (iRubyObjectArray.length > 2) {
                        string4 = iRubyObjectArray[2].toString();
                    }
                    if (databaseMetaData.storesUpperCaseIdentifiers()) {
                        string3 = string3.toUpperCase();
                    } else if (databaseMetaData.storesLowerCaseIdentifiers()) {
                        string3 = string3.toLowerCase();
                    }
                    if (string4 == null && (bl2 || bl)) {
                        resultSet2 = databaseMetaData.getSchemas();
                        string = databaseMetaData.getUserName();
                        while (resultSet2.next()) {
                            if (!resultSet2.getString(1).equalsIgnoreCase(string)) continue;
                            string4 = resultSet2.getString(1);
                            break;
                        }
                        resultSet2.close();
                    }
                    if ((resultSet2 = (RubyArray)JdbcAdapterInternalService.tableLookupBlock(iRubyObject.getRuntime(), connection.getCatalog(), string4, string3, new String[]{"TABLE", "VIEW"}).call(connection)).isEmpty()) {
                        throw new SQLException("Table " + string3 + " does not exist");
                    }
                    resultSet = databaseMetaData.getColumns(connection.getCatalog(), string4, string3, null);
                    string = JdbcAdapterInternalService.unmarshal_columns(iRubyObject, databaseMetaData, resultSet);
                    return string;
                }
                finally {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject unmarshal_columns(IRubyObject iRubyObject, DatabaseMetaData databaseMetaData, ResultSet resultSet) throws SQLException {
        try {
            String string;
            ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
            String string2 = databaseMetaData.getClass().getName().toLowerCase();
            boolean bl = string2.indexOf("derby") != -1;
            boolean bl2 = string2.indexOf("oracle") != -1 || string2.indexOf("oci") != -1;
            Ruby ruby = iRubyObject.getRuntime();
            IRubyObject iRubyObject2 = rubyApi.callMethod(iRubyObject, "adapter");
            RubyHash rubyHash = (RubyHash)rubyApi.callMethod(iRubyObject2, "native_database_types");
            IRubyObject iRubyObject3 = ((RubyModule)ruby.getModule("ActiveRecord").getConstant("ConnectionAdapters")).getConstant("JdbcColumn");
            while (resultSet.next()) {
                IRubyObject iRubyObject4;
                String string3;
                string = resultSet.getString(4);
                if (databaseMetaData.storesUpperCaseIdentifiers() && !HAS_SMALL.matcher(string).find()) {
                    string = string.toLowerCase();
                }
                String string4 = resultSet.getString(7);
                String string5 = resultSet.getString(9);
                int n = -1;
                int n2 = -1;
                if (string4 != null) {
                    n = Integer.parseInt(string4);
                    if (string5 != null) {
                        n2 = Integer.parseInt(string5);
                    }
                }
                String string6 = resultSet.getString(6);
                if (string4 != null && n > 0) {
                    string6 = string6 + "(" + n;
                    if (string5 != null && n2 > 0) {
                        string6 = string6 + "," + n2;
                    }
                    string6 = string6 + ")";
                }
                if ((string3 = resultSet.getString(13)) == null || bl2 && string3.toLowerCase().trim().equals("null")) {
                    iRubyObject4 = ruby.getNil();
                } else {
                    if (bl2) {
                        string3 = string3.trim();
                    }
                    if ((bl || bl2) && string3.length() > 0 && string3.charAt(0) == '\'') {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    iRubyObject4 = RubyString.newUnicodeString((Ruby)ruby, (String)string3);
                }
                IRubyObject iRubyObject5 = rubyApi.getInstanceVariable(iRubyObject, "@config");
                IRubyObject iRubyObject6 = rubyApi.callMethod(iRubyObject3, "new", new IRubyObject[]{iRubyObject5, RubyString.newUnicodeString((Ruby)ruby, (String)string), iRubyObject4, RubyString.newUnicodeString((Ruby)ruby, (String)string6), ruby.newBoolean(!resultSet.getString(18).trim().equals("NO"))});
                arrayList.add(iRubyObject6);
                IRubyObject iRubyObject7 = rubyHash.fastARef(rubyApi.callMethod(iRubyObject6, "type"));
                if (iRubyObject7 == null || iRubyObject7.isNil() || !rubyApi.callMethod(iRubyObject7, "[]", (IRubyObject)ruby.newSymbol("limit")).isNil()) continue;
                rubyApi.callMethod(iRubyObject6, "limit=", ruby.getNil());
                if (rubyApi.callMethod(iRubyObject6, "type").equals(ruby.newSymbol("decimal"))) continue;
                rubyApi.callMethod(iRubyObject6, "precision=", ruby.getNil());
            }
            string = ruby.newArray(arrayList);
            return string;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
    }

    @JRubyMethod(name={"primary_keys"}, required=1)
    public static IRubyObject primary_keys(final IRubyObject iRubyObject, final IRubyObject iRubyObject2) throws SQLException {
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, new SQLBlock(){

            public IRubyObject call(Connection connection) throws SQLException {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = iRubyObject2.toString();
                if (databaseMetaData.storesUpperCaseIdentifiers()) {
                    string = string.toUpperCase();
                } else if (databaseMetaData.storesLowerCaseIdentifiers()) {
                    string = string.toLowerCase();
                }
                ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, string);
                ArrayList<RubyString> arrayList = new ArrayList<RubyString>();
                Ruby ruby = iRubyObject.getRuntime();
                while (resultSet.next()) {
                    String string2 = resultSet.getString(4);
                    if (databaseMetaData.storesUpperCaseIdentifiers() && !HAS_SMALL.matcher(string2).find()) {
                        string2 = string2.toLowerCase();
                    }
                    arrayList.add(RubyString.newUnicodeString((Ruby)ruby, (String)string2));
                }
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ruby.newArray(arrayList);
            }
        });
    }

    @JRubyMethod(name={"execute_id_insert"}, required=2)
    public static IRubyObject execute_id_insert(IRubyObject iRubyObject, final IRubyObject iRubyObject2, final IRubyObject iRubyObject3) throws SQLException {
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(Connection connection) throws SQLException {
                PreparedStatement preparedStatement = connection.prepareStatement(rubyApi.convertToRubyString(iRubyObject2).getUnicodeValue());
                try {
                    preparedStatement.setLong(1, RubyNumeric.fix2long((IRubyObject)iRubyObject3));
                    preparedStatement.executeUpdate();
                }
                finally {
                    preparedStatement.close();
                }
                return iRubyObject3;
            }
        });
    }

    @JRubyMethod(name={"execute_update"}, required=1)
    public static IRubyObject execute_update(final IRubyObject iRubyObject, final IRubyObject iRubyObject2) throws SQLException {
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(Connection connection) throws SQLException {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    RubyFixnum rubyFixnum = iRubyObject.getRuntime().newFixnum((long)statement.executeUpdate(rubyApi.convertToRubyString(iRubyObject2).getUnicodeValue()));
                    return rubyFixnum;
                }
                finally {
                    if (null != statement) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
    }

    @JRubyMethod(name={"execute_query"}, rest=true)
    public static IRubyObject execute_query(final IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) throws SQLException, IOException {
        final IRubyObject iRubyObject2 = iRubyObjectArray[0];
        final int n = iRubyObjectArray.length > 1 ? RubyNumeric.fix2int((IRubyObject)iRubyObjectArray[1]) : 0;
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(Connection connection) throws SQLException {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    statement.setMaxRows(n);
                    IRubyObject iRubyObject3 = JdbcAdapterInternalService.unmarshal_result(iRubyObject, statement.executeQuery(rubyApi.convertToRubyString(iRubyObject2).getUnicodeValue()));
                    return iRubyObject3;
                }
                finally {
                    if (null != statement) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
    }

    @JRubyMethod(name={"execute_insert"}, required=1)
    public static IRubyObject execute_insert(final IRubyObject iRubyObject, final IRubyObject iRubyObject2) throws SQLException {
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(Connection connection) throws SQLException {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    statement.executeUpdate(rubyApi.convertToRubyString(iRubyObject2).getUnicodeValue(), 1);
                    IRubyObject iRubyObject3 = JdbcAdapterInternalService.unmarshal_id_result(iRubyObject.getRuntime(), statement.getGeneratedKeys());
                    return iRubyObject3;
                }
                finally {
                    if (null != statement) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject unmarshal_result_downcase(IRubyObject iRubyObject, ResultSet resultSet) throws SQLException, IOException {
        ArrayList<RubyHash> arrayList = new ArrayList<RubyHash>();
        Ruby ruby = iRubyObject.getRuntime();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            IRubyObject[] iRubyObjectArray = new IRubyObject[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                iRubyObjectArray[i] = RubyString.newUnicodeString((Ruby)ruby, (String)resultSetMetaData.getColumnLabel(i + 1).toLowerCase());
                nArray[i] = resultSetMetaData.getColumnType(i + 1);
                nArray2[i] = resultSetMetaData.getScale(i + 1);
            }
            while (resultSet.next()) {
                RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
                for (int i = 0; i < n; ++i) {
                    rubyApi.callMethod((IRubyObject)rubyHash, "[]=", new IRubyObject[]{iRubyObjectArray[i], JdbcAdapterInternalService.jdbc_to_ruby(ruby, i + 1, nArray[i], nArray2[i], resultSet)});
                }
                arrayList.add(rubyHash);
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        return ruby.newArray(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject unmarshal_result(IRubyObject iRubyObject, ResultSet resultSet) throws SQLException {
        Ruby ruby = iRubyObject.getRuntime();
        ArrayList<RubyHash> arrayList = new ArrayList<RubyHash>();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            boolean bl = resultSet.getStatement().getConnection().getMetaData().storesUpperCaseIdentifiers();
            int n = resultSetMetaData.getColumnCount();
            IRubyObject[] iRubyObjectArray = new IRubyObject[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                String string = resultSetMetaData.getColumnLabel(i + 1);
                if (bl && !HAS_SMALL.matcher(string).find()) {
                    string = string.toLowerCase();
                }
                iRubyObjectArray[i] = RubyString.newUnicodeString((Ruby)ruby, (String)string);
                nArray[i] = resultSetMetaData.getColumnType(i + 1);
                nArray2[i] = resultSetMetaData.getScale(i + 1);
            }
            while (resultSet.next()) {
                RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
                for (int i = 0; i < n; ++i) {
                    rubyApi.callMethod((IRubyObject)rubyHash, "[]=", new IRubyObject[]{iRubyObjectArray[i], JdbcAdapterInternalService.jdbc_to_ruby(ruby, i + 1, nArray[i], nArray2[i], resultSet)});
                }
                arrayList.add(rubyHash);
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        return ruby.newArray(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"unmarshal_result"}, required=1)
    public static IRubyObject unmarshal_result(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) throws SQLException, IOException {
        Ruby ruby = iRubyObject.getRuntime();
        ResultSet resultSet = JdbcAdapterInternalService.intoResultSet(iRubyObject2);
        ArrayList<RubyHash> arrayList = new ArrayList<RubyHash>();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            IRubyObject[] iRubyObjectArray = new IRubyObject[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                iRubyObjectArray[i] = RubyString.newUnicodeString((Ruby)ruby, (String)resultSetMetaData.getColumnLabel(i + 1));
                nArray[i] = resultSetMetaData.getColumnType(i + 1);
                nArray2[i] = resultSetMetaData.getScale(i + 1);
            }
            if (block.isGiven()) {
                while (resultSet.next()) {
                    if (!block.yield(ruby.getCurrentContext(), iRubyObject2).isTrue()) continue;
                    RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
                    for (int i = 0; i < n; ++i) {
                        rubyApi.callMethod((IRubyObject)rubyHash, "[]=", new IRubyObject[]{iRubyObjectArray[i], JdbcAdapterInternalService.jdbc_to_ruby(ruby, i + 1, nArray[i], nArray2[i], resultSet)});
                    }
                    arrayList.add(rubyHash);
                }
            } else {
                while (resultSet.next()) {
                    RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
                    for (int i = 0; i < n; ++i) {
                        rubyApi.callMethod((IRubyObject)rubyHash, "[]=", new IRubyObject[]{iRubyObjectArray[i], JdbcAdapterInternalService.jdbc_to_ruby(ruby, i + 1, nArray[i], nArray2[i], resultSet)});
                    }
                    arrayList.add(rubyHash);
                }
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        return ruby.newArray(arrayList);
    }

    private static IRubyObject jdbc_to_ruby(Ruby ruby, int n, int n2, int n3, ResultSet resultSet) throws SQLException {
        try {
            switch (n2) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    int n4;
                    InputStream inputStream = resultSet.getBinaryStream(n);
                    if (inputStream == null || resultSet.wasNull()) {
                        return ruby.getNil();
                    }
                    ByteList byteList = new ByteList(2048);
                    byte[] byArray = new byte[2048];
                    while ((n4 = inputStream.read(byArray)) != -1) {
                        byteList.append(byArray, 0, n4);
                    }
                    inputStream.close();
                    return ruby.newString(byteList);
                }
                case -1: 
                case 2005: {
                    int n5;
                    Reader reader = resultSet.getCharacterStream(n);
                    if (reader == null || resultSet.wasNull()) {
                        return ruby.getNil();
                    }
                    StringBuffer stringBuffer = new StringBuffer(2048);
                    char[] cArray = new char[2048];
                    while ((n5 = reader.read(cArray)) != -1) {
                        stringBuffer.append(cArray, 0, n5);
                    }
                    reader.close();
                    return RubyString.newUnicodeString((Ruby)ruby, (String)stringBuffer.toString());
                }
                case 93: {
                    Timestamp timestamp = resultSet.getTimestamp(n);
                    if (timestamp == null || resultSet.wasNull()) {
                        return ruby.getNil();
                    }
                    String string = timestamp.toString();
                    if (string.endsWith(" 00:00:00.0")) {
                        string = string.substring(0, string.length() - " 00:00:00.0".length());
                    }
                    return RubyString.newUnicodeString((Ruby)ruby, (String)string);
                }
            }
            String string = resultSet.getString(n);
            if (string == null || resultSet.wasNull()) {
                return ruby.getNil();
            }
            return RubyString.newUnicodeString((Ruby)ruby, (String)string);
        }
        catch (IOException iOException) {
            throw (SQLException)new SQLException(iOException.getMessage()).initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject unmarshal_id_result(Ruby ruby, ResultSet resultSet) throws SQLException {
        if (resultSet.next() && resultSet.getMetaData().getColumnCount() > 0) {
            RubyFixnum rubyFixnum = ruby.newFixnum(resultSet.getLong(1));
            return rubyFixnum;
        }
        IRubyObject iRubyObject = ruby.getNil();
        return iRubyObject;
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
    }

    private static String convertToStringOrNull(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return null;
        }
        return iRubyObject.toString();
    }

    private static int getTypeValueFor(Ruby ruby, IRubyObject iRubyObject) throws SQLException {
        if (!(iRubyObject instanceof RubySymbol)) {
            iRubyObject = rubyApi.callMethod(iRubyObject, "type");
        }
        if (iRubyObject == ruby.newSymbol("string")) {
            return 12;
        }
        if (iRubyObject == ruby.newSymbol("text")) {
            return 2005;
        }
        if (iRubyObject == ruby.newSymbol("integer")) {
            return 4;
        }
        if (iRubyObject == ruby.newSymbol("decimal")) {
            return 3;
        }
        if (iRubyObject == ruby.newSymbol("float")) {
            return 6;
        }
        if (iRubyObject == ruby.newSymbol("datetime")) {
            return 93;
        }
        if (iRubyObject == ruby.newSymbol("timestamp")) {
            return 93;
        }
        if (iRubyObject == ruby.newSymbol("time")) {
            return 92;
        }
        if (iRubyObject == ruby.newSymbol("date")) {
            return 91;
        }
        if (iRubyObject == ruby.newSymbol("binary")) {
            return 2004;
        }
        if (iRubyObject == ruby.newSymbol("boolean")) {
            return 16;
        }
        return -1;
    }

    private static void setValue(PreparedStatement preparedStatement, int n, Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) throws SQLException {
        int n2 = JdbcAdapterInternalService.getTypeValueFor(ruby, iRubyObject2);
        if (iRubyObject.isNil()) {
            preparedStatement.setNull(n, n2);
            return;
        }
        switch (n2) {
            case 12: 
            case 2005: {
                preparedStatement.setString(n, RubyString.objAsString((ThreadContext)threadContext, (IRubyObject)iRubyObject).toString());
                break;
            }
            case 4: {
                preparedStatement.setLong(n, RubyNumeric.fix2long((IRubyObject)iRubyObject));
                break;
            }
            case 6: {
                preparedStatement.setDouble(n, ((RubyNumeric)iRubyObject).getDoubleValue());
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (!(iRubyObject instanceof RubyTime)) {
                    try {
                        Date date = FORMAT.parse(RubyString.objAsString((ThreadContext)threadContext, (IRubyObject)iRubyObject).toString());
                        preparedStatement.setTimestamp(n, new Timestamp(date.getTime()), Calendar.getInstance());
                    }
                    catch (Exception exception) {
                        preparedStatement.setString(n, RubyString.objAsString((ThreadContext)threadContext, (IRubyObject)iRubyObject).toString());
                    }
                    break;
                }
                RubyTime rubyTime = (RubyTime)iRubyObject;
                Date date = rubyTime.getJavaDate();
                long l = date.getTime();
                long l2 = rubyTime.microseconds() - l / 1000L;
                Timestamp timestamp = new Timestamp(l);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                timestamp.setNanos((int)(l2 * 1000L));
                preparedStatement.setTimestamp(n, timestamp, calendar);
                break;
            }
            case 16: {
                preparedStatement.setBoolean(n, iRubyObject.isTrue());
                break;
            }
            default: {
                throw new RuntimeException("type " + iRubyObject2 + " not supported in _bind yet");
            }
        }
    }

    private static void setValuesOnPS(PreparedStatement preparedStatement, Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) throws SQLException {
        RubyArray rubyArray = (RubyArray)iRubyObject;
        RubyArray rubyArray2 = (RubyArray)iRubyObject2;
        int n = rubyArray.getLength();
        for (int i = 0; i < n; ++i) {
            JdbcAdapterInternalService.setValue(preparedStatement, i + 1, ruby, threadContext, rubyArray.eltInternal(i), rubyArray2.eltInternal(i));
        }
    }

    @JRubyMethod(name={"insert_bind"}, required=3, rest=true)
    public static IRubyObject insert_bind(final ThreadContext threadContext, IRubyObject iRubyObject, final IRubyObject[] iRubyObjectArray) throws SQLException {
        final Ruby ruby = iRubyObject.getRuntime();
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(Connection connection) throws SQLException {
                Statement statement = null;
                try {
                    statement = connection.prepareStatement(rubyApi.convertToRubyString(iRubyObjectArray[0]).toString(), 1);
                    JdbcAdapterInternalService.setValuesOnPS((PreparedStatement)statement, ruby, threadContext, iRubyObjectArray[1], iRubyObjectArray[2]);
                    statement.executeUpdate();
                    IRubyObject iRubyObject = JdbcAdapterInternalService.unmarshal_id_result(ruby, statement.getGeneratedKeys());
                    return iRubyObject;
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @JRubyMethod(name={"update_bind"}, required=3, rest=true)
    public static IRubyObject update_bind(final ThreadContext threadContext, IRubyObject iRubyObject, final IRubyObject[] iRubyObjectArray) throws SQLException {
        final Ruby ruby = iRubyObject.getRuntime();
        Arity.checkArgumentCount((Ruby)ruby, (IRubyObject[])iRubyObjectArray, (int)3, (int)4);
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(Connection connection) throws SQLException {
                Statement statement = null;
                try {
                    statement = connection.prepareStatement(rubyApi.convertToRubyString(iRubyObjectArray[0]).toString());
                    JdbcAdapterInternalService.setValuesOnPS((PreparedStatement)statement, ruby, threadContext, iRubyObjectArray[1], iRubyObjectArray[2]);
                    statement.executeUpdate();
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
                return ruby.getNil();
            }
        });
    }

    @JRubyMethod(name={"write_large_object"}, required=6)
    public static IRubyObject write_large_object(IRubyObject iRubyObject, final IRubyObject[] iRubyObjectArray) throws SQLException, IOException {
        final Ruby ruby = iRubyObject.getRuntime();
        return JdbcAdapterInternalService.withConnectionAndRetry(iRubyObject, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject call(Connection connection) throws SQLException {
                String string = "UPDATE " + rubyApi.convertToRubyString(iRubyObjectArray[2]) + " SET " + rubyApi.convertToRubyString(iRubyObjectArray[1]) + " = ? WHERE " + rubyApi.convertToRubyString(iRubyObjectArray[3]) + "=" + rubyApi.convertToRubyString(iRubyObjectArray[4]);
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(string);
                    if (iRubyObjectArray[0].isTrue()) {
                        ByteList byteList = rubyApi.convertToRubyString(iRubyObjectArray[5]).getByteList();
                        preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteList.bytes, byteList.begin, byteList.realSize), byteList.realSize);
                    } else {
                        String string2 = rubyApi.convertToRubyString(iRubyObjectArray[5]).getUnicodeValue();
                        preparedStatement.setCharacterStream(1, (Reader)new StringReader(string2), string2.length());
                    }
                    preparedStatement.executeUpdate();
                }
                finally {
                    try {
                        preparedStatement.close();
                    }
                    catch (Exception exception) {}
                }
                return ruby.getNil();
            }
        });
    }

    private static Connection getConnection(IRubyObject iRubyObject) {
        Connection connection = (Connection)iRubyObject.dataGetStruct();
        return connection;
    }

    private static RuntimeException wrap(IRubyObject iRubyObject, Throwable throwable) {
        RubyClass rubyClass = iRubyObject.getRuntime().getModule("ActiveRecord").getClass("ActiveRecordError");
        return (RuntimeException)new RaiseException(iRubyObject.getRuntime(), rubyClass, throwable.getMessage(), false).initCause(throwable);
    }

    private static ResultSet intoResultSet(IRubyObject iRubyObject) {
        JavaObject javaObject = iRubyObject instanceof JavaObject ? (JavaObject)iRubyObject : (JavaObject)rubyApi.getInstanceVariable(iRubyObject, "@java_object");
        return (ResultSet)javaObject.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isConnectionBroken(IRubyObject iRubyObject, Connection connection) {
        try {
            IRubyObject iRubyObject2 = JdbcAdapterInternalService.config_value(iRubyObject, "connection_alive_sql");
            if (JdbcAdapterInternalService.select_p(iRubyObject, iRubyObject2).isTrue()) {
                String string = rubyApi.convertToRubyString(iRubyObject2).toString();
                Statement statement = connection.createStatement();
                try {
                    statement.execute(string);
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                return true;
            }
            return !connection.isClosed();
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    private static IRubyObject setConnection(IRubyObject iRubyObject, Connection connection) {
        Connection connection2 = JdbcAdapterInternalService.getConnection(iRubyObject);
        if (connection2 != null) {
            try {
                connection2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        IRubyObject iRubyObject2 = iRubyObject.getRuntime().getNil();
        if (connection != null) {
            iRubyObject2 = JdbcAdapterInternalService.wrappedConnection(iRubyObject, connection);
        }
        rubyApi.setInstanceVariable(iRubyObject, "@connection", iRubyObject2);
        iRubyObject.dataWrapStruct((Object)connection);
        return iRubyObject;
    }

    private static IRubyObject wrappedConnection(IRubyObject iRubyObject, Connection connection) {
        return Java.java_to_ruby((IRubyObject)iRubyObject, (IRubyObject)JavaObject.wrap((Ruby)iRubyObject.getRuntime(), (Object)connection), (Block)Block.NULL_BLOCK);
    }

    private static JdbcConnectionFactory getConnectionFactory(IRubyObject iRubyObject) throws RaiseException {
        IRubyObject iRubyObject2 = rubyApi.getInstanceVariable(iRubyObject, "@connection_factory");
        JdbcConnectionFactory jdbcConnectionFactory = null;
        try {
            jdbcConnectionFactory = (JdbcConnectionFactory)((JavaObject)rubyApi.getInstanceVariable(iRubyObject2, "@java_object")).getValue();
        }
        catch (Exception exception) {
            jdbcConnectionFactory = null;
        }
        if (jdbcConnectionFactory == null) {
            throw iRubyObject.getRuntime().newRuntimeError("@connection_factory not set properly");
        }
        return jdbcConnectionFactory;
    }

    private static IRubyObject config_value(IRubyObject iRubyObject, String string) {
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject2 = rubyApi.getInstanceVariable(iRubyObject, "@config");
        return rubyApi.callMethod(iRubyObject2, "[]", (IRubyObject)ruby.newSymbol(string));
    }

    static {
        HAS_SMALL = Pattern.compile("[a-z]");
        FORMAT = new SimpleDateFormat("%y-%M-%d %H:%m:%s");
    }
}

