/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.catalog;

import java.awt.Dialog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import org.netbeans.modules.mobility.cldcplatform.wizard.InstallerIterator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutionEngine;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class PlatformCatalogAutoInstaller
implements Runnable,
FileChangeListener,
LookupListener {
    private boolean running = false;
    private final FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("platform_installers");
    private final Lookup.Result res;
    private static final String TEMPLATE = "Templates/Services/Platforms/org-netbeans-api-java-Platform/javaplatform.xml";
    private static final String STORAGE = "Services/Platforms/org-netbeans-api-java-Platform";

    public PlatformCatalogAutoInstaller() {
        assert (this.fo != null);
        this.fo.addFileChangeListener((FileChangeListener)this);
        this.res = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        this.res.allInstances();
        this.res.addLookupListener((LookupListener)this);
        this.res.allInstances();
        Repository.getDefault().getDefaultFileSystem().findResource("Modules").addFileChangeListener((FileChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        boolean bl = false;
        Object object2 = this;
        synchronized (object2) {
            if (this.running) {
                return;
            }
            this.running = true;
        }
        this.fo.refresh(true);
        boolean bl2 = false;
        while ((object2 = this.fo.getData(false)).hasMoreElements()) {
            try {
                object = (FileObject)object2.nextElement();
                final File file = FileUtil.toFile((FileObject)object);
                if (Utilities.getOperatingSystem() == 16 || Utilities.getOperatingSystem() == 8) {
                    Runtime.getRuntime().exec(new String[]{"chmod", "+x", file.getAbsolutePath()}).waitFor();
                }
                final InputOutput inputOutput = IOProvider.getDefault().getIO(file.getName(), false);
                inputOutput.setErrSeparated(false);
                inputOutput.setErrVisible(true);
                inputOutput.setInputVisible(true);
                inputOutput.setOutputVisible(true);
                inputOutput.setFocusTaken(true);
                bl2 = ExecutionEngine.getDefault().execute(file.getName(), new Runnable(){

                    public void run() {
                        try {
                            Process process = Runtime.getRuntime().exec(new String[]{file.getAbsolutePath()});
                            RequestProcessor.getDefault().post((Runnable)new StreamPumper(inputOutput.getIn(), new OutputStreamWriter(process.getOutputStream())));
                            RequestProcessor.getDefault().post((Runnable)new StreamPumper(new InputStreamReader(process.getInputStream()), (Writer)inputOutput.getOut()));
                            RequestProcessor.getDefault().post((Runnable)new StreamPumper(new InputStreamReader(process.getErrorStream()), (Writer)inputOutput.getErr()));
                            process.waitFor();
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                        }
                    }
                }, null).result() == 0 | bl2;
                if (!file.delete()) {
                    object.delete();
                }
                this.fo.refresh(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = true;
            }
        }
        if (bl2) {
            this.launchAddPlatformWizard();
        }
        if (bl) {
            RequestProcessor.getDefault().post((Runnable)this, 400);
        }
        object = this;
        synchronized (object) {
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchAddPlatformWizard() {
        try {
            WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)InstallerIterator.getDefault());
            DataObject dataObject = DataObject.find((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(TEMPLATE));
            wizardDescriptor.putProperty("targetTemplate", (Object)dataObject);
            DataFolder dataFolder = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource(STORAGE));
            wizardDescriptor.putProperty("targetFolder", (Object)dataFolder);
            wizardDescriptor.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
            wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
            wizardDescriptor.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
            wizardDescriptor.setTitle(NbBundle.getMessage(PlatformCatalogAutoInstaller.class, (String)"CTL_AddPlatformTitle"));
            wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            try {
                dialog.setVisible(true);
                wizardDescriptor.getValue();
            }
            finally {
                dialog.dispose();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
        }
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
        if (!this.running) {
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void resultChanged(LookupEvent lookupEvent) {
        if (!this.running) {
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    private static class StreamPumper
    implements Runnable {
        private final Reader in;
        private final Writer out;

        public StreamPumper(Reader reader, Writer writer) {
            this.in = reader;
            this.out = new BufferedWriter(writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n;
                while ((n = this.in.read()) >= 0) {
                    this.out.write(n);
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
    }
}

