/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.ruby.debugger.DebuggerAnnotation;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.model.CallSite;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallStackAnnotation {
    private static Map<CallSite, DebuggerAnnotation> stackAnnotations;
    private static CallSite[] callSites;
    private static RequestProcessor rp;
    private static RequestProcessor.Task taskRemove;
    private static RequestProcessor.Task taskAnnotate;

    private CallStackAnnotation() {
    }

    private static DebuggerAnnotation annotateCallSite(CallSite callSite) {
        Line line = EditorUtil.getLineAnnotable(callSite.getPath(), callSite.getLine());
        if (line == null) {
            return null;
        }
        DebuggerAnnotation debuggerAnnotation = new DebuggerAnnotation("CallSite", (Annotatable)line);
        return debuggerAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAnnotations() {
        RequestProcessor requestProcessor = rp;
        synchronized (requestProcessor) {
            if (taskRemove == null) {
                taskRemove = rp.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Set set = Collections.emptySet();
                        RequestProcessor requestProcessor = rp;
                        synchronized (requestProcessor) {
                            if (stackAnnotations != null) {
                                set = new HashSet(stackAnnotations.values());
                                stackAnnotations.clear();
                                stackAnnotations = null;
                            }
                        }
                        CallStackAnnotation.detachAnnotations(set);
                    }
                });
            }
        }
        taskRemove.schedule(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void annotate(CallSite[] callSiteArray) {
        RequestProcessor requestProcessor = rp;
        synchronized (requestProcessor) {
            if (taskRemove != null) {
                taskRemove.cancel();
            }
            callSites = callSiteArray;
            if (taskAnnotate == null) {
                taskAnnotate = rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Set set = Collections.emptySet();
                        RequestProcessor requestProcessor = rp;
                        synchronized (requestProcessor) {
                            HashMap<CallSite, DebuggerAnnotation> hashMap = new HashMap<CallSite, DebuggerAnnotation>();
                            CallSite[] callSiteArray = callSites;
                            if (stackAnnotations == null) {
                                stackAnnotations = new HashMap();
                            }
                            for (int i = 0; i < callSiteArray.length; ++i) {
                                CallSite callSite = callSiteArray[i];
                                if (hashMap.containsKey(callSite)) continue;
                                DebuggerAnnotation debuggerAnnotation = (DebuggerAnnotation)((Object)stackAnnotations.remove(callSite));
                                if (debuggerAnnotation == null) {
                                    debuggerAnnotation = CallStackAnnotation.annotateCallSite(callSite);
                                }
                                if (debuggerAnnotation == null) continue;
                                hashMap.put(callSite, debuggerAnnotation);
                            }
                            set = new HashSet(stackAnnotations.values());
                            stackAnnotations = hashMap;
                        }
                        CallStackAnnotation.detachAnnotations(set);
                    }
                });
            }
        }
        taskAnnotate.schedule(500);
    }

    private static void detachAnnotations(Collection<DebuggerAnnotation> collection) {
        for (DebuggerAnnotation debuggerAnnotation : collection) {
            debuggerAnnotation.detach();
        }
    }

    static {
        rp = new RequestProcessor("Ruby Debugger CallStack Annotation Refresher");
    }
}

