/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.model;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public final class SessionsTableModelFilter
implements TableModelFilter {
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public Object getValueAt(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        if (object instanceof Session && SessionsTableModelFilter.isRubySession((Session)object)) {
            if ("SessionState".equals(string)) {
                return this.getSessionState((Session)object);
            }
            if ("SessionLanguage".equals(string)) {
                return object;
            }
            if ("SessionHostName".equals(string)) {
                return ((Session)object).getLocationName();
            }
            throw new UnknownTypeException(object);
        }
        return tableModel.getValueAt(object, string);
    }

    public boolean isReadOnly(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        return tableModel.isReadOnly(object, string);
    }

    public void setValueAt(TableModel tableModel, Object object, String string, Object object2) throws UnknownTypeException {
        tableModel.setValueAt(object, string, object2);
    }

    private static boolean isRubySession(Session session) {
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return false;
        }
        return debuggerEngine.lookupFirst(null, RubySession.class) != null;
    }

    private String getSessionState(Session session) {
        String string;
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return SessionsTableModelFilter.getMessage("MSG_Session.State.Starting");
        }
        RubySession rubySession = (RubySession)debuggerEngine.lookupFirst(null, RubySession.class);
        switch (rubySession.getState()) {
            case RUNNING: {
                string = SessionsTableModelFilter.getMessage("MSG_Session.State.Running");
                break;
            }
            case STARTING: {
                string = SessionsTableModelFilter.getMessage("MSG_Session.State.Starting");
                break;
            }
            case STOPPED: {
                string = SessionsTableModelFilter.getMessage("MSG_Session.State.Stopped");
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(SessionsTableModelFilter.class, (String)string);
    }
}

