/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.breakpoints.BreakpointLineUpdater;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;

public final class RubyBreakpointManager {
    private static final Map<RubyBreakpoint, BreakpointLineUpdater> BLUS = new HashMap<RubyBreakpoint, BreakpointLineUpdater>();

    private RubyBreakpointManager() {
    }

    static RubyBreakpoint createBreakpoint(Line line) {
        RubyBreakpoint rubyBreakpoint = new RubyBreakpoint(line);
        BreakpointLineUpdater breakpointLineUpdater = new BreakpointLineUpdater(rubyBreakpoint);
        try {
            breakpointLineUpdater.attach();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        BLUS.put(rubyBreakpoint, breakpointLineUpdater);
        return rubyBreakpoint;
    }

    public static RubyBreakpoint addBreakpoint(Line line) throws RubyDebuggerException {
        RubyBreakpoint rubyBreakpoint = RubyBreakpointManager.createBreakpoint(line);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)rubyBreakpoint);
        for (RubyDebuggerProxy rubyDebuggerProxy : RubyDebuggerProxy.PROXIES) {
            rubyDebuggerProxy.addBreakpoint((IRubyBreakpoint)rubyBreakpoint);
        }
        return rubyBreakpoint;
    }

    public static void removeBreakpoint(RubyBreakpoint rubyBreakpoint) {
        BreakpointLineUpdater breakpointLineUpdater = BLUS.remove((Object)rubyBreakpoint);
        assert (breakpointLineUpdater != null) : "No BreakpointLineUpdater for RubyBreakpoint:" + (Object)((Object)rubyBreakpoint);
        if (breakpointLineUpdater != null) {
            breakpointLineUpdater.detach();
        }
        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)rubyBreakpoint);
        for (RubyDebuggerProxy rubyDebuggerProxy : RubyDebuggerProxy.PROXIES) {
            rubyDebuggerProxy.removeBreakpoint((IRubyBreakpoint)rubyBreakpoint);
        }
    }

    public static RubyBreakpoint[] getBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<RubyBreakpoint> arrayList = new ArrayList<RubyBreakpoint>();
        for (Breakpoint breakpoint : breakpointArray) {
            if (!(breakpoint instanceof RubyBreakpoint)) continue;
            arrayList.add((RubyBreakpoint)breakpoint);
        }
        return arrayList.toArray(new RubyBreakpoint[arrayList.size()]);
    }

    static IRubyBreakpoint[] getBreakpoints(FileObject fileObject) {
        assert (fileObject != null);
        ArrayList<RubyBreakpoint> arrayList = new ArrayList<RubyBreakpoint>();
        for (RubyBreakpoint rubyBreakpoint : RubyBreakpointManager.getBreakpoints()) {
            FileObject fileObject2 = rubyBreakpoint.getFileObject();
            if (!fileObject.equals(fileObject2)) continue;
            arrayList.add(rubyBreakpoint);
        }
        return arrayList.toArray(new RubyBreakpoint[arrayList.size()]);
    }

    public static boolean isBreakpointOnLine(FileObject fileObject, int n) {
        for (RubyBreakpoint rubyBreakpoint : RubyBreakpointManager.getBreakpoints()) {
            if (!fileObject.equals(rubyBreakpoint.getFileObject()) || n != rubyBreakpoint.getLineNumber()) continue;
            return true;
        }
        return false;
    }

    static RubyBreakpoint getCurrentLineBreakpoint() {
        Line line = EditorUtil.getCurrentLine();
        if (line == null) {
            return null;
        }
        for (RubyBreakpoint rubyBreakpoint : RubyBreakpointManager.getBreakpoints()) {
            if (!rubyBreakpoint.getLine().equals(line)) continue;
            return rubyBreakpoint;
        }
        return null;
    }
}

